/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.Portable;
import org.mortbay.io.View;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpStatus;
import org.mortbay.jetty.HttpTokens;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.log.Log;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.UrlEncoded;

public class HttpGenerator
implements HttpTokens {
    public static final int STATE_HEADER = 0;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_FLUSHING = 3;
    public static final int STATE_END = 4;
    public static final boolean LAST = true;
    public static final boolean MORE = false;
    private static byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private static byte[] CONTENT_LENGTH_0 = Portable.getBytes("Content-Length: 0\r\n");
    private static byte[] CONNECTION_KEEP_ALIVE = Portable.getBytes("Connection: keep-alive\r\n");
    private static byte[] CONNECTION_CLOSE = Portable.getBytes("Connection: close\r\n");
    private static byte[] TRANSFER_ENCODING_CHUNKED = Portable.getBytes("Transfer-Encoding: chunked\r\n");
    private static byte[] SERVER = Portable.getBytes("Server: Jetty(6.0.x)\r\n");
    private static int CHUNK_SPACE = 12;
    private static String[] __reasons = new String[505];
    private int _state = 0;
    private int _version = 11;
    private int _status = 200;
    private String _reason;
    private long _contentWritten = 0L;
    private long _contentLength = -3L;
    private boolean _last = false;
    private boolean _head = false;
    private boolean _noContent = false;
    private boolean _close = false;
    private Buffers _buffers;
    private EndPoint _endp;
    private Buffer _header;
    private Buffer _buffer;
    private Buffer _content;
    private boolean _bypass = false;
    private boolean _needCRLF = false;
    private boolean _needEOC = false;
    private boolean _bufferChunked = false;
    private int _headerBufferSize;
    private int _contentBufferSize;
    private boolean _sendServerVersion;

    public static void setServerVersion(String version) {
        SERVER = Portable.getBytes("Server: Jetty(" + version + ")\r\n");
    }

    public static String getReason(int code) {
        if (code < __reasons.length) {
            return __reasons[code];
        }
        return TypeUtil.toString((int)code);
    }

    public HttpGenerator(Buffers buffers, EndPoint io, int headerBufferSize, int contentBufferSize) {
        this._buffers = buffers;
        this._endp = io;
        this._headerBufferSize = headerBufferSize;
        this._contentBufferSize = contentBufferSize;
    }

    public void reset(boolean returnBuffers) {
        this._state = 0;
        this._version = 11;
        this._status = 200;
        this._last = false;
        this._head = false;
        this._noContent = false;
        this._close = false;
        this._contentWritten = 0L;
        this._contentLength = -3L;
        if (returnBuffers) {
            if (this._header != null) {
                this._buffers.returnBuffer(this._header);
            }
            this._header = null;
            if (this._buffer != null) {
                this._buffers.returnBuffer(this._buffer);
            }
            this._buffer = null;
        } else {
            if (this._header != null) {
                this._header.clear();
            }
            if (this._buffer != null) {
                this._buffers.returnBuffer(this._buffer);
                this._buffer = null;
            }
        }
        this._content = null;
        this._bypass = false;
        this._needCRLF = false;
        this._needEOC = false;
    }

    public void resetBuffer() {
        if (this._state >= 3) {
            throw new IllegalStateException("Flushed");
        }
        this._last = false;
        this._close = false;
        this._contentWritten = 0L;
        this._contentLength = -3L;
        this._bypass = false;
        this._content = null;
        if (this._buffer != null) {
            this._buffer.clear();
        }
    }

    public Buffer getUncheckedBuffer() {
        return this._buffer;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public int getState() {
        return this._state;
    }

    public boolean isState(int state) {
        return this._state == state;
    }

    public boolean isComplete() {
        return this._state == 4;
    }

    public boolean isCommitted() {
        return this._state != 0;
    }

    public boolean isHead() {
        return this._head;
    }

    public void setHead(boolean head) {
        this._head = head;
    }

    public boolean isPersistent() {
        return !this._close;
    }

    public void setVersion(int version) {
        if (this._state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this._version = version;
    }

    public void setRequest(Buffer method, Buffer uri) {
        Portable.throwNotSupported();
    }

    public void setResponse(int status, String reason) {
        if (this._state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this._status = status;
        this._reason = reason == null ? reason : UrlEncoded.encodeString((String)reason);
    }

    public void addContent(Buffer content, boolean last) throws IOException {
        if (this._noContent) {
            content.clear();
            return;
        }
        if (content.isImmutable()) {
            throw new IllegalArgumentException("immutable");
        }
        if (this._last || this._state == 4) {
            Log.debug((String)"Ignoring extra content {}", (Object)content);
            content.clear();
            return;
        }
        this._last = last;
        if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
            this.flushBuffers();
            if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        this._content = content;
        this._contentWritten += (long)content.length();
        if (this._head) {
            content.clear();
            this._content = null;
        } else if (this._endp != null && this._buffer == null && content.length() > 0 && this._last) {
            this._bypass = true;
        } else {
            if (this._buffer == null) {
                this._buffer = this._buffers.getBuffer(this._contentBufferSize);
            }
            int len = this._buffer.put(this._content);
            this._content.skip(len);
            if (this._content.length() == 0) {
                this._content = null;
            }
        }
    }

    public boolean addContent(byte b) throws IOException {
        if (this._noContent) {
            return false;
        }
        if (this._last || this._state == 4) {
            throw new IllegalStateException("Closed");
        }
        if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
            this.flushBuffers();
            if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        ++this._contentWritten;
        if (this._head) {
            return false;
        }
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer(this._contentBufferSize);
        }
        this._buffer.put(b);
        return this._buffer.space() <= (this._contentLength == -2L ? CHUNK_SPACE : 0);
    }

    int prepareUncheckedAddContent() throws IOException {
        if (this._noContent) {
            return -1;
        }
        if (this._last || this._state == 4) {
            throw new IllegalStateException("Closed");
        }
        Buffer content = this._content;
        if (content != null && content.length() > 0 || this._bufferChunked) {
            this.flushBuffers();
            if (content != null && content.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer(this._contentBufferSize);
        }
        this._contentWritten -= (long)this._buffer.length();
        if (this._head) {
            return Integer.MAX_VALUE;
        }
        return this._buffer.space() - (this._contentLength == -2L ? CHUNK_SPACE : 0);
    }

    void uncheckedAddContent(int b) {
        this._buffer.put((byte)b);
    }

    void completeUncheckedAddContent() {
        if (this._noContent) {
            if (this._buffer != null) {
                this._buffer.clear();
            }
            return;
        }
        this._contentWritten += (long)this._buffer.length();
        if (this._head) {
            this._buffer.clear();
        }
    }

    public boolean isBufferFull() {
        boolean full = this._state == 3 || this._bypass || this._buffer != null && this._buffer.space() == 0 || this._contentLength == -2L && this._buffer != null && this._buffer.space() < CHUNK_SPACE;
        return full;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
        if (this._state != 0) {
            return;
        }
        if (this._last && !allContentAdded) {
            throw new IllegalStateException("last?");
        }
        this._last |= allContentAdded;
        if (this._version == 9) {
            this._close = true;
            this._contentLength = -1L;
        } else {
            Buffer line;
            boolean has_server = false;
            if (this._version == 10) {
                this._close = true;
            }
            if (this._header == null) {
                this._header = this._buffers.getBuffer(this._headerBufferSize);
            }
            if ((line = HttpStatus.getResponseLine(this._status)) != null && this._reason == null) {
                this._header.put(line);
            } else {
                byte[] r;
                if (this._reason != null) {
                    if (this._reason.length() > this._header.capacity() / 2) {
                        this._reason = this._reason.substring(0, this._header.capacity() / 2);
                    }
                } else {
                    this._reason = HttpGenerator.getReason(this._status);
                }
                if (line == null) {
                    this._header.put(HttpVersions.HTTP_1_1_BUFFER);
                    this._header.put((byte)32);
                    this._header.put((byte)(48 + this._status / 100));
                    this._header.put((byte)(48 + this._status % 100 / 10));
                    this._header.put((byte)(48 + this._status % 10));
                    this._header.put((byte)32);
                    r = Portable.getBytes(this._reason == null ? "Unknown" : this._reason);
                    this._header.put(r, 0, r.length);
                    this._header.put(CRLF);
                } else if (this._reason != null) {
                    this._header.put(line.array(), 0, HttpVersions.HTTP_1_1_BUFFER.length() + 5);
                    r = Portable.getBytes(this._reason);
                    this._header.put(r, 0, r.length);
                    this._header.put(CRLF);
                } else {
                    this._reason = HttpGenerator.getReason(this._status);
                }
            }
            if (this._status == 100 || this._status == 204 || this._status == 304) {
                this._noContent = true;
                this._content = null;
                if (this._buffer != null) {
                    this._buffer.clear();
                }
            }
            HttpFields.Field content_length = null;
            HttpFields.Field transfer_encoding = null;
            HttpFields.Field connection = null;
            boolean keep_alive = false;
            if (fields != null) {
                Iterator iter = fields.getFields();
                block13: while (iter.hasNext()) {
                    HttpFields.Field field = (HttpFields.Field)iter.next();
                    switch (field.getNameOrdinal()) {
                        case 12: {
                            content_length = field;
                            this._contentLength = field.getLongValue();
                            if (this._contentLength < this._contentWritten || this._last && this._contentLength != this._contentWritten) {
                                content_length = null;
                            }
                            field.put(this._header);
                            continue block13;
                        }
                        case 16: {
                            if (BufferUtil.isPrefix(MimeTypes.MULTIPART_BYTERANGES_BUFFER, field.getValueBuffer())) {
                                this._contentLength = -4L;
                            }
                            field.put(this._header);
                            continue block13;
                        }
                        case 5: {
                            if (this._version != 11) continue block13;
                            transfer_encoding = field;
                            continue block13;
                        }
                        case 1: {
                            connection = field;
                            int connection_value = field.getValueOrdinal();
                            this._close = HttpHeaderValues.CLOSE_ORDINAL == connection_value;
                            boolean bl = keep_alive = HttpHeaderValues.KEEP_ALIVE_ORDINAL == connection_value;
                            if (keep_alive && this._version == 10) {
                                this._close = false;
                            }
                            if (!this._close || this._contentLength != -3L) continue block13;
                            this._contentLength = -1L;
                            continue block13;
                        }
                        case 48: {
                            if (!this.getSendServerVersion()) continue block13;
                            has_server = true;
                            field.put(this._header);
                            continue block13;
                        }
                    }
                    field.put(this._header);
                }
            }
            switch ((int)this._contentLength) {
                case -3: {
                    if (this._contentWritten == 0L && (this._status < 200 || this._status == 204 || this._status == 304)) {
                        this._contentLength = 0L;
                        break;
                    }
                    if (this._last) {
                        this._contentLength = this._contentWritten;
                        if (content_length != null) break;
                        this._header.put(HttpHeaders.CONTENT_LENGTH_BUFFER);
                        this._header.put((byte)58);
                        this._header.put((byte)32);
                        BufferUtil.putDecLong(this._header, this._contentLength);
                        this._header.put(CRLF);
                        break;
                    }
                    this._contentLength = this._close || this._version < 11 ? -1L : -2L;
                    break;
                }
                case 0: {
                    if (content_length != null || this._status < 200 || this._status == 204 || this._status == 304) break;
                    this._header.put(CONTENT_LENGTH_0);
                    break;
                }
                case -1: {
                    this._close = true;
                    break;
                }
                case -2: {
                    break;
                }
            }
            if (this._contentLength == -2L) {
                if (transfer_encoding != null && HttpHeaderValues.CHUNKED_ORDINAL != transfer_encoding.getValueOrdinal()) {
                    String c = transfer_encoding.getValue();
                    if (!c.endsWith("chunked")) throw new IllegalArgumentException("BAD TE");
                    transfer_encoding.put(this._header);
                } else {
                    this._header.put(TRANSFER_ENCODING_CHUNKED);
                }
            }
            if (this._close || this._contentLength == -1L) {
                if (this._version > 10 || connection != null) {
                    this._header.put(CONNECTION_CLOSE);
                }
                this._close = true;
            } else if (keep_alive && this._version == 10) {
                this._header.put(CONNECTION_KEEP_ALIVE);
            } else if (connection != null) {
                connection.put(this._header);
            }
            if (!has_server && this._status > 100 && this.getSendServerVersion()) {
                this._header.put(SERVER);
            }
            this._header.put(CRLF);
        }
        this._state = 2;
    }

    public void complete() throws IOException {
        if (this._state == 4) {
            return;
        }
        if (this._state == 0) {
            throw new IllegalStateException("State==HEADER");
        }
        if (this._contentLength >= 0L && this._contentLength != this._contentWritten && !this._head) {
            if (this._endp.isOpen()) {
                Log.warn((String)("ContentLength written==" + this._contentWritten + " != contentLength==" + this._contentLength));
            }
            this._close = true;
        }
        if (this._state != 3) {
            this._state = 3;
            if (this._contentLength == -2L) {
                this._needEOC = true;
            }
        }
        this.flushBuffers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long flushBuffers() throws IOException {
        try {
            if (this._state == 0) {
                throw new IllegalStateException("State==HEADER");
            }
            this.prepareBuffers();
            if (this._endp == null) {
                if (this._needCRLF && this._buffer != null) {
                    this._buffer.put(CRLF);
                }
                if (!this._needEOC) return 0L;
                if (this._buffer == null) return 0L;
                this._buffer.put(LAST_CHUNK);
                return 0L;
            }
            int total = 0;
            long last_len = -1L;
            while (true) {
                int len = -1;
                int to_flush = (this._header != null && this._header.length() > 0 ? 4 : 0) | (this._buffer != null && this._buffer.length() > 0 ? 2 : 0) | (this._bypass && this._content != null && this._content.length() > 0 ? 1 : 0);
                switch (to_flush) {
                    case 7: {
                        throw new IllegalStateException();
                    }
                    case 6: {
                        len = this._endp.flush(this._header, this._buffer, null);
                        break;
                    }
                    case 5: {
                        len = this._endp.flush(this._header, this._content, null);
                        break;
                    }
                    case 4: {
                        len = this._endp.flush(this._header);
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        len = this._endp.flush(this._buffer);
                        break;
                    }
                    case 1: {
                        len = this._endp.flush(this._content);
                        break;
                    }
                    case 0: {
                        if (this._header != null) {
                            this._header.clear();
                        }
                        this._bypass = false;
                        this._bufferChunked = false;
                        if (this._buffer != null) {
                            this._buffer.clear();
                            if (this._contentLength == -2L) {
                                this._buffer.setPutIndex(CHUNK_SPACE);
                                this._buffer.setGetIndex(CHUNK_SPACE);
                                if (this._content != null && this._content.length() < this._buffer.space() && this._state != 3) {
                                    this._buffer.put(this._content);
                                    this._content.clear();
                                    this._content = null;
                                    return total;
                                }
                            }
                        }
                        if (!(this._needCRLF || this._needEOC || this._content != null && this._content.length() != 0)) {
                            if (this._state == 3) {
                                this._state = 4;
                            }
                            if (this._state != 4) return total;
                            if (!this._close) return total;
                            this._endp.close();
                            return total;
                        }
                        this.prepareBuffers();
                    }
                }
                if (len <= 0) {
                    if (last_len > 0L) return total;
                    return total;
                }
                last_len = len;
                total += len;
            }
        }
        catch (IOException e) {
            IOException iOException;
            Log.ignore((Throwable)e);
            if (e instanceof EofException) {
                iOException = e;
                throw iOException;
            }
            iOException = new EofException(e);
            throw iOException;
        }
    }

    private void prepareBuffers() {
        if (!this._bufferChunked) {
            if (this._content != null && this._content.length() > 0 && this._buffer != null && this._buffer.space() > 0) {
                int len = this._buffer.put(this._content);
                this._content.skip(len);
                if (this._content.length() == 0) {
                    this._content = null;
                }
            }
            if (this._contentLength == -2L) {
                int size;
                int n = size = this._buffer == null ? 0 : this._buffer.length();
                if (size > 0) {
                    this._bufferChunked = true;
                    if (this._buffer.getIndex() == CHUNK_SPACE) {
                        this._buffer.poke(this._buffer.getIndex() - 2, CRLF, 0, 2);
                        this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                        BufferUtil.prependHexInt(this._buffer, size);
                        if (this._needCRLF) {
                            this._buffer.poke(this._buffer.getIndex() - 2, CRLF, 0, 2);
                            this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                            this._needCRLF = false;
                        }
                    } else {
                        if (this._needCRLF) {
                            if (this._header.length() > 0) {
                                throw new IllegalStateException("EOC");
                            }
                            this._header.put(CRLF);
                            this._needCRLF = false;
                        }
                        BufferUtil.putHexInt(this._header, size);
                        this._header.put(CRLF);
                    }
                    if (this._buffer.space() >= 2) {
                        this._buffer.put(CRLF);
                    } else {
                        this._needCRLF = true;
                    }
                }
                if (this._needEOC && (this._content == null || this._content.length() == 0)) {
                    if (this._needCRLF) {
                        if (this._buffer == null && this._header.space() >= 2) {
                            this._header.put(CRLF);
                            this._needCRLF = false;
                        } else if (this._buffer.space() >= 2) {
                            this._buffer.put(CRLF);
                            this._needCRLF = false;
                        }
                    }
                    if (!this._needCRLF && this._needEOC) {
                        if (this._buffer == null && this._header.space() >= LAST_CHUNK.length) {
                            this._header.put(LAST_CHUNK);
                            this._bufferChunked = true;
                            this._needEOC = false;
                        } else if (this._buffer.space() >= LAST_CHUNK.length) {
                            this._buffer.put(LAST_CHUNK);
                            this._bufferChunked = true;
                            this._needEOC = false;
                        }
                    }
                }
            }
        }
        if (this._content != null && this._content.length() == 0) {
            this._content = null;
        }
    }

    public void sendError(int code, String reason, String content, boolean close) throws IOException {
        if (!this.isCommitted()) {
            this.setResponse(code, reason);
            this._close = close;
            this.completeHeader(null, false);
            if (content != null) {
                this.addContent(new View(new ByteArrayBuffer(content)), true);
            }
            this.complete();
        }
    }

    public int getContentBufferSize() {
        return this._contentBufferSize;
    }

    public void increaseContentBufferSize(int contentBufferSize) {
        if (contentBufferSize > this._contentBufferSize) {
            this._contentBufferSize = contentBufferSize;
            if (this._buffer != null) {
                Buffer nb = this._buffers.getBuffer(this._contentBufferSize);
                nb.put(this._buffer);
                this._buffers.returnBuffer(this._buffer);
                this._buffer = nb;
            }
        }
    }

    public long getContentWritten() {
        return this._contentWritten;
    }

    static {
        Field[] fields = HttpServletResponse.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 8) == 0 || !fields[i].getName().startsWith("SC_")) continue;
            try {
                int code = fields[i].getInt(null);
                if (code >= __reasons.length) continue;
                HttpGenerator.__reasons[code] = fields[i].getName().substring(3);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static class OutputWriter
    extends Writer {
        Output _out;
        HttpGenerator _generator;
        EndPoint _endp;
        int _maxChar;
        String _characterEncoding;
        Writer _converter;
        ByteArrayOutputStream2 _bytes;
        char[] _chars;
        private int _space;
        int _surrogate;
        int _writeChunk = 1500;

        public OutputWriter(Output out) {
            this._out = out;
            this._generator = this._out._generator;
            this._endp = this._generator._endp;
        }

        public void setCharacterEncoding(String encoding) {
            if (this._characterEncoding == null || !this._characterEncoding.equalsIgnoreCase(encoding)) {
                this._converter = null;
            }
            this._characterEncoding = encoding;
            this._maxChar = this._characterEncoding == null ? 256 : (StringUtil.__ISO_8859_1.equalsIgnoreCase(this._characterEncoding) ? 256 : ("UTF-8".equalsIgnoreCase(this._characterEncoding) ? 128 : 0));
        }

        public void close() throws IOException {
            this._out.close();
        }

        public void flush() throws IOException {
            this._out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String s, int offset, int length) throws IOException {
            if (this._maxChar == 128) {
                this.writeUtf8(s, offset, length);
                return;
            }
            if (this._bytes == null) {
                this._bytes = new ByteArrayOutputStream2(this._writeChunk * 2);
            }
            if (this._converter == null) {
                Writer writer = this._converter = this._characterEncoding == null ? new OutputStreamWriter((OutputStream)this._bytes) : new OutputStreamWriter((OutputStream)this._bytes, this._characterEncoding);
            }
            if (length > 16) {
                if (this._chars == null) {
                    this._chars = new char[this._writeChunk];
                }
                int end = offset + length;
                int i = offset;
                while (i < end) {
                    int chunk = this._writeChunk;
                    int next = i + chunk;
                    if (next > end) {
                        next = end;
                        chunk = next - i;
                    }
                    s.getChars(i, next, this._chars, 0);
                    i += chunk;
                    int n = 0;
                    while (n < chunk) {
                        char c = this._chars[n];
                        if (c < this._maxChar) {
                            this._bytes.writeUnchecked((int)c);
                            ++n;
                            continue;
                        }
                        int i0 = n++;
                        if ((n += (this._writeChunk + 5) / 6) > chunk) {
                            n = chunk;
                        }
                        this._converter.write(this._chars, i0, n - i0);
                        this._converter.flush();
                    }
                    this._out.write(this._bytes.getBuf(), 0, this._bytes.getCount());
                    this._bytes.reset();
                }
            } else {
                ByteArrayOutputStream2 byteArrayOutputStream2 = this._bytes;
                synchronized (byteArrayOutputStream2) {
                    int end = offset + length;
                    int i = offset;
                    while (i < end) {
                        int next = i + this._writeChunk;
                        if (next > end) {
                            next = end;
                        }
                        while (i < next) {
                            char c = s.charAt(i);
                            if (c < this._maxChar) {
                                this._bytes.writeUnchecked((int)c);
                                ++i;
                                continue;
                            }
                            int i0 = i;
                            if ((i += this._writeChunk / 2) > next) {
                                i = next;
                            }
                            this._converter.write(s, i0, i - i0);
                            this._converter.flush();
                        }
                        this._out.write(this._bytes.getBuf(), 0, this._bytes.getCount());
                        this._bytes.reset();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(char[] s, int offset, int length) throws IOException {
            if (this._maxChar == 128) {
                this.writeUtf8(s, offset, length);
            } else {
                if (this._bytes == null) {
                    this._bytes = new ByteArrayOutputStream2(this._writeChunk * 2);
                }
                ByteArrayOutputStream2 byteArrayOutputStream2 = this._bytes;
                synchronized (byteArrayOutputStream2) {
                    int end = offset + length;
                    int i = offset;
                    while (i < end) {
                        int next = i + this._writeChunk;
                        if (next > end) {
                            next = end;
                        }
                        while (i < next) {
                            char c = s[i];
                            if (c < this._maxChar) {
                                ++i;
                                this._bytes.writeUnchecked((int)c);
                                continue;
                            }
                            if (this._converter == null) {
                                this._converter = new OutputStreamWriter((OutputStream)this._bytes, this._characterEncoding);
                            }
                            int i0 = i;
                            if ((i += this._writeChunk / 2) > next) {
                                i = next;
                            }
                            this._converter.write(s, i0, i - i0);
                            this._converter.flush();
                        }
                        byte[] b = this._bytes.getBuf();
                        this._out.write(b, 0, this._bytes.getCount());
                        this._bytes.reset();
                    }
                }
            }
        }

        public void writeUtf8(char[] s, int offset, int length) throws IOException {
            if (this._out._closed) {
                throw new IOException("Closed");
            }
            this._space = this._generator.prepareUncheckedAddContent();
            if (this._space < 0) {
                return;
            }
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                char c;
                if (this._space < 6 && this._endp.isOpen()) {
                    this._generator.completeUncheckedAddContent();
                    this._out.flush();
                    this._space = this._generator.prepareUncheckedAddContent();
                }
                if ((c = s[i]) < '\ud800' || c > '\udfff') {
                    this.writeUtf8(c);
                    continue;
                }
                if (c < '\udc00') {
                    this._surrogate = c - 55296 << 10;
                    continue;
                }
                this.writeUtf8(this._surrogate + c - 56320);
            }
            this._generator.completeUncheckedAddContent();
            if (this._space == 0 && this._endp.isOpen()) {
                this._out.flush();
            }
        }

        public void writeUtf8(String s, int offset, int length) throws IOException {
            if (this._out._closed) {
                throw new IOException("Closed");
            }
            this._space = this._generator.prepareUncheckedAddContent();
            if (this._space < 0) {
                return;
            }
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                char c;
                if (this._space < 6 && this._endp.isOpen()) {
                    this._generator.completeUncheckedAddContent();
                    this._out.flush();
                    this._space = this._generator.prepareUncheckedAddContent();
                }
                if ((c = s.charAt(i)) < '\ud800' || c > '\udfff') {
                    this.writeUtf8(c);
                    continue;
                }
                if (c < '\udc00') {
                    this._surrogate = c - 55296 << 10;
                    continue;
                }
                this.writeUtf8(this._surrogate + c - 56320);
            }
            this._generator.completeUncheckedAddContent();
            if (this._space == 0 && this._endp.isOpen()) {
                this._out.flush();
            }
        }

        private void writeUtf8(int code) {
            if ((code & 0xFFFFFF80) == 0) {
                this._generator.uncheckedAddContent(code);
                --this._space;
            } else if ((code & 0xFFFFF800) == 0) {
                this._generator.uncheckedAddContent(0xC0 | code >> 6);
                this._generator.uncheckedAddContent(0x80 | code & 0x3F);
                this._space -= 2;
            } else if ((code & 0xFFFF0000) == 0) {
                this._generator.uncheckedAddContent(0xE0 | code >> 12);
                this._generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code & 0x3F);
                this._space -= 3;
            } else if ((code & 0xFF200000) == 0) {
                this._generator.uncheckedAddContent(0xF0 | code >> 18);
                this._generator.uncheckedAddContent(0x80 | code >> 12 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code & 0x3F);
                this._space -= 4;
            } else if ((code & 0xF4000000) == 0) {
                this._generator.uncheckedAddContent(0xF8 | code >> 24);
                this._generator.uncheckedAddContent(0x80 | code >> 18 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code >> 12 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code & 0x3F);
                this._space -= 5;
            } else if ((code & Integer.MIN_VALUE) == 0) {
                this._generator.uncheckedAddContent(0xFC | code >> 30);
                this._generator.uncheckedAddContent(0x80 | code >> 24 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code >> 18 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code >> 12 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code >> 6 & 0x3F);
                this._generator.uncheckedAddContent(0x80 | code & 0x3F);
                this._space -= 6;
            } else {
                this._generator.uncheckedAddContent(63);
            }
        }
    }

    public static class Output
    extends ServletOutputStream {
        protected HttpGenerator _generator;
        protected long _maxIdleTime;
        protected ByteArrayBuffer _buf1 = null;
        protected ByteArrayBuffer _bufn = null;
        protected boolean _closed;

        public Output(HttpGenerator generator, long maxIdleTime) {
            this._generator = generator;
            this._maxIdleTime = maxIdleTime;
        }

        public void close() throws IOException {
            this._closed = true;
        }

        void reopen() {
            this._closed = false;
        }

        public void flush() throws IOException {
            Buffer content = this._generator._content;
            Buffer buffer = this._generator._buffer;
            if (content != null && content.length() > 0 || buffer != null && buffer.length() > 0) {
                this._generator.flushBuffers();
                while (content != null && content.length() > 0 || buffer != null && buffer.length() > 0) {
                    if (!this._generator._endp.isBlocking()) {
                        this._generator._endp.blockWritable(this._maxIdleTime);
                    }
                    this._generator.flushBuffers();
                }
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this._bufn == null) {
                this._bufn = new ByteArrayBuffer(b, off, len);
            } else {
                this._bufn.wrap(b, off, len);
            }
            this.write(this._bufn);
        }

        public void write(byte[] b) throws IOException {
            if (this._bufn == null) {
                this._bufn = new ByteArrayBuffer(b);
            } else {
                this._bufn.wrap(b);
            }
            this.write(this._bufn);
        }

        public void write(int b) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            while (this._generator.isBufferFull() && this._generator._endp.isOpen()) {
                if (!this._generator._endp.isBlocking()) {
                    this._generator._endp.blockWritable(this._maxIdleTime);
                }
                this.flush();
            }
            if (this._generator.addContent((byte)b)) {
                this.flush();
            }
        }

        private void write(Buffer buffer) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            while (this._generator.isBufferFull() && this._generator._endp.isOpen()) {
                if (!this._generator._endp.isBlocking()) {
                    this._generator._endp.blockWritable(this._maxIdleTime);
                }
                this.flush();
            }
            this._generator.addContent(buffer, false);
            if (this._generator.isBufferFull()) {
                this.flush();
            }
            while (buffer.length() > 0 && this._generator._endp.isOpen()) {
                if (!this._generator._endp.isBlocking()) {
                    this._generator._endp.blockWritable(this._maxIdleTime);
                }
                this.flush();
            }
        }

        public void print(String s) throws IOException {
            this.write(s.getBytes());
        }
    }
}

