/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.support;

import java.util.Stack;
import org.openymsg.support.MessageDecoderSettings;
import org.openymsg.support.MessageElement;

public class MessageDecoder {
    protected char[] msg;
    protected StringBuffer out = new StringBuffer();
    protected int pos;
    protected Stack<MessageElement> stack = new Stack();
    private MessageDecoderSettings settings = null;
    protected static final char ESC = '\u001b';
    protected static final String ESC_SEQ = "\u001b[";

    public MessageDecoder() {
    }

    public MessageDecoder(MessageDecoderSettings messageDecoderSettings) {
        this();
        this.settings = messageDecoderSettings;
    }

    public void setDecoderSettings(MessageDecoderSettings messageDecoderSettings) {
        this.settings = messageDecoderSettings;
    }

    public MessageDecoderSettings getDecoderSettings() {
        return this.settings;
    }

    public synchronized MessageElement decode(String string) {
        this.msg = string.toCharArray();
        this.out.setLength(0);
        this.stack.removeAllElements();
        this.pos = 0;
        MessageElement messageElement = new MessageElement(this.settings, -1);
        this.stack.push(messageElement);
        while (this.pos < this.msg.length) {
            if (this.startsWith("<font ")) {
                this.handleFont();
            } else if (this.startsWith("<fade ")) {
                this.handleFade();
            } else if (this.startsWith("<alt ")) {
                this.handleAlt();
            } else if (this.startsWith(ESC_SEQ)) {
                this.handleEscape();
            } else if (this.startsWith("</font>")) {
                this.handleFontExit();
            } else if (this.startsWith("</fade>")) {
                this.handleFadeExit();
            } else if (this.startsWith("</alt>")) {
                this.handleAltExit();
            } else if (this.startsWith("<")) {
                this.handleOtherTag();
            } else {
                this.out.append(this.msg[this.pos]);
            }
            ++this.pos;
        }
        this.addText();
        return messageElement;
    }

    public String decodeToHTML(String string) {
        MessageElement messageElement = this.decode(string);
        return messageElement.toHTML();
    }

    public String decodeToText(String string) {
        MessageElement messageElement = this.decode(string);
        return messageElement.toText();
    }

    protected void handleFont() {
        this.addText();
        this.pos += 6;
        int n = this.nextNonLiteral('>');
        String string = new String(this.msg, this.pos, n - this.pos);
        this.add(new MessageElement(this.settings, 5, string));
        this.pos = n;
    }

    protected void handleFade() {
        this.addText();
        this.pos += 6;
        int n = this.nextNonLiteral('>');
        String string = new String(this.msg, this.pos, n - this.pos);
        this.add(new MessageElement(this.settings, 6, string));
        this.pos = this.nextNonLiteral('>');
    }

    protected void handleAlt() {
        this.addText();
        this.pos += 5;
        int n = this.nextNonLiteral('>');
        String string = new String(this.msg, this.pos, n - this.pos);
        this.add(new MessageElement(this.settings, 7, string));
        this.pos = this.nextNonLiteral('>');
    }

    protected void handleEscape() {
        this.addText();
        this.pos += 2;
        MessageElement messageElement = null;
        char c = this.msg[this.pos];
        if (c >= '1' && c <= '4') {
            switch (c) {
                case '1': {
                    messageElement = new MessageElement(this.settings, 1);
                    break;
                }
                case '2': {
                    messageElement = new MessageElement(this.settings, 2);
                    break;
                }
                case '3': {
                    messageElement = new MessageElement(this.settings, 3, "" + this.msg[this.pos + 1]);
                    break;
                }
                case '4': {
                    messageElement = new MessageElement(this.settings, 4);
                }
            }
            this.add(messageElement);
        } else if (c == 'x') {
            ++this.pos;
            int n = -1;
            switch (this.msg[this.pos]) {
                case '1': {
                    n = 1;
                    break;
                }
                case '2': {
                    n = 2;
                    break;
                }
                case '4': {
                    n = 4;
                }
            }
            if (n > -1) {
                this.remove(n);
            }
        } else if (c == '#') {
            ++this.pos;
            String string = new String(this.msg, this.pos, 6);
            messageElement = new MessageElement(this.settings, 8, string);
            this.add(messageElement);
        }
        this.pos = this.nextNonLiteral('m');
    }

    protected void handleFontExit() {
        this.addText();
        this.pos += 6;
        this.remove(5);
    }

    protected void handleFadeExit() {
        this.addText();
        this.pos += 6;
        this.remove(6);
    }

    protected void handleAltExit() {
        this.addText();
        this.pos += 5;
        this.remove(7);
    }

    protected void handleOtherTag() {
        this.addText();
        ++this.pos;
        int n = this.nextNonLiteral('>');
        String string = new String(this.msg, this.pos, n - this.pos).toLowerCase();
        int n2 = MessageElement.whichColourName(string);
        if (n2 >= 0) {
            MessageElement messageElement = new MessageElement(this.settings, 9, n2);
            this.add(messageElement);
            this.pos = n;
        } else if (string.equals("b")) {
            this.add(new MessageElement(this.settings, 1));
            ++this.pos;
        } else if (string.equals("/b")) {
            this.remove(1);
            this.pos += 2;
        } else if (string.equals("i")) {
            this.add(new MessageElement(this.settings, 2));
            ++this.pos;
        } else if (string.equals("/i")) {
            this.remove(2);
            this.pos += 2;
        } else if (string.equals("u")) {
            this.add(new MessageElement(this.settings, 4));
            ++this.pos;
        } else if (string.equals("/u")) {
            this.remove(4);
            this.pos += 2;
        } else if (string.length() > 1 && string.charAt(0) == '/') {
            int n3 = MessageElement.whichColourName(string.substring(1));
            if (n3 >= 0) {
                this.remove(9, n3);
            }
            this.pos = n;
        } else if (string.startsWith("#")) {
            this.add(new MessageElement(this.settings, 8, string.substring(1)));
            this.pos += 7;
        } else {
            this.out.append('<');
            --this.pos;
        }
    }

    private void add(MessageElement messageElement) {
        this.stack.peek().addChild(messageElement);
        this.stack.push(messageElement);
    }

    private void remove(int n) {
        if (this.stack.size() > 1) {
            MessageElement messageElement = this.stack.pop();
            while (messageElement.type != n && this.stack.size() > 1) {
                messageElement = this.stack.pop();
            }
        }
    }

    private void remove(int n, int n2) {
        if (this.stack.size() > 1) {
            MessageElement messageElement = this.stack.pop();
            while (!(messageElement.type == n && messageElement.colourEquals(n2) || this.stack.size() <= 1)) {
                messageElement = this.stack.pop();
            }
        }
    }

    private void addText() {
        if (this.out.length() > 0) {
            MessageElement messageElement = this.stack.peek();
            MessageElement messageElement2 = new MessageElement(this.settings, 0, this.out.toString());
            messageElement.addChild(messageElement2);
            this.out = new StringBuffer();
        }
    }

    private boolean startsWith(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.pos + i >= this.msg.length) {
                return false;
            }
            char c = this.msg[this.pos + i];
            if (c >= 'A' && c <= 'Z') {
                c = Character.toLowerCase(c);
            }
            if (c == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int nextNonLiteral(char c) {
        int n;
        boolean bl = false;
        for (n = this.pos; n < this.msg.length && (this.msg[n] != c || bl); ++n) {
            if (this.msg[n] != '\"') continue;
            bl = !bl;
        }
        return n;
    }
}

