/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongSMS {
    private static final Logger logger = LoggerFactory.getLogger(LongSMS.class);
    private static final int MAX_MESSAGE_SEGMENT_8BIT = 133;
    private static final int MAX_MESSAGE_SEGMENT_7BIT = 152;
    private static final byte UDHIE_IDENTIFIER_SAR = 8;
    private static final byte UDHIE_SAR_LENGTH = 4;
    private static int referenceNumber = 0;

    private LongSMS() {
        throw new InstantiationError("This class must not be instantiated");
    }

    private static synchronized int getReferenceNumber() {
        if (++referenceNumber >= 65536) {
            referenceNumber = 0;
        }
        return referenceNumber;
    }

    private static byte[] copyShort2Bytes(int integer) {
        byte[] bytes = new byte[]{(byte)(integer >> 8 & 0xFF), (byte)(integer & 0xFF)};
        return bytes;
    }

    public static byte[][] splitMessage8Bit(byte[] aMessage) {
        int segmentNum = aMessage.length / 133;
        int messageLength = aMessage.length;
        if (segmentNum > 255) {
            segmentNum = 255;
            messageLength = segmentNum * 133;
        }
        if (messageLength % 133 > 0) {
            ++segmentNum;
        }
        byte[][] segments = new byte[segmentNum][];
        byte[] referenceNumber = LongSMS.copyShort2Bytes(LongSMS.getReferenceNumber());
        for (int i = 0; i < segmentNum; ++i) {
            logger.debug("i = " + i);
            int lengthOfData = segmentNum - i == 1 ? messageLength - i * 133 : 133;
            logger.debug("Length of data = " + lengthOfData);
            segments[i] = new byte[7 + lengthOfData];
            logger.debug("segments[" + i + "].length = " + segments[i].length);
            segments[i][0] = 6;
            segments[i][1] = 8;
            segments[i][2] = 4;
            System.arraycopy(referenceNumber, 0, segments[i], 3, 2);
            segments[i][5] = (byte)segmentNum;
            segments[i][6] = (byte)(i + 1);
            System.arraycopy(aMessage, i * 133, segments[i], 7, lengthOfData);
        }
        return segments;
    }

    private static byte[][] splitMessage7Bit(byte[] aMessage) {
        int segmentNum = aMessage.length / 152;
        int messageLength = aMessage.length;
        if (segmentNum > 255) {
            segmentNum = 255;
            messageLength = segmentNum * 152;
        }
        if (messageLength % 152 > 0) {
            ++segmentNum;
        }
        byte[][] segments = new byte[segmentNum][];
        byte[] tempBytes = new byte[152];
        byte[] referenceNumber = LongSMS.copyShort2Bytes(LongSMS.getReferenceNumber());
        for (int i = 0; i < segmentNum; ++i) {
            int lengthOfData = segmentNum - i == 1 ? messageLength - i * 152 : 152;
            System.arraycopy(aMessage, i * 152, tempBytes, 0, lengthOfData);
            byte[] data7Bit = LongSMS.encode7Bit(new String(tempBytes, 0, lengthOfData));
            segments[i] = new byte[7 + data7Bit.length];
            segments[i][0] = 6;
            segments[i][1] = 8;
            segments[i][2] = 4;
            System.arraycopy(referenceNumber, 0, segments[i], 3, 2);
            segments[i][5] = (byte)segmentNum;
            segments[i][6] = (byte)(i + 1);
            System.arraycopy(data7Bit, 0, segments[i], 7, data7Bit.length);
        }
        return segments;
    }

    private static byte[] encode7Bit(String aString) {
        int length = aString.length();
        char[] tempChars = new char[length + 1];
        byte[] tempBytes = new byte[length];
        aString.getChars(0, length, tempChars, 0);
        tempChars[length] = '\u0000';
        int i = 0;
        int j = 0;
        int power = 1;
        while (i < length) {
            if (power == 8) {
                if (++i >= length) break;
                power = 1;
            }
            tempBytes[j] = (byte)(tempChars[i] & (1 << 8 - power) - 1 | (tempChars[i + 1] & (1 << power) - 1) << 8 - power);
            tempChars[i + 1] = (char)(tempChars[i + 1] >> power);
            ++i;
            ++j;
            ++power;
        }
        byte[] bytes = new byte[j];
        System.arraycopy(tempBytes, 0, bytes, 0, j);
        return bytes;
    }
}

