/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.voxeo.exceptions.InputException;
import com.voxeo.exceptions.VException;
import com.voxeo.utils.Closer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class XML {
    public static org.w3c.dom.Document parseDOM(InputStream input, boolean validating, boolean namespaceAware) throws SAXException, IOException {
        try {
            DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
            parserFactory.setValidating(validating);
            parserFactory.setNamespaceAware(namespaceAware);
            DocumentBuilder xmlParser = parserFactory.newDocumentBuilder();
            return xmlParser.parse(input);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failed to create XML parser", e);
        }
    }

    public static String render(org.w3c.dom.Document document) throws VException {
        try {
            StringWriter writer = new StringWriter();
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
            return writer.toString();
        }
        catch (Exception e) {
            throw new VException("Error serializing DOM", e);
        }
    }

    public static org.w3c.dom.Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Document parseDom4jDocument(String xml) {
        try {
            return DocumentHelper.parseText((String)xml);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing XML", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String filter(String xml, XMLFilter filter) {
        String string;
        ByteArrayInputStream istream = new ByteArrayInputStream(xml.getBytes());
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        try {
            XML.filter(istream, ostream, filter);
            string = new String(ostream.toByteArray());
        }
        catch (Throwable throwable) {
            Closer.closeAll(istream, ostream);
            throw throwable;
        }
        Closer.closeAll(istream, ostream);
        return string;
    }

    public static void filter(InputStream istream, OutputStream ostream, XMLFilter filter) {
        try {
            assert (filter != null);
            XMLSerializer serializer = new XMLSerializer();
            serializer.setOutputByteStream(ostream);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader reader = parser.getXMLReader();
            filter.setParent(reader);
            filter.setContentHandler(serializer.asContentHandler());
            filter.parse(new InputSource(istream));
        }
        catch (Exception exception) {
            throw new InputException("Error parsing xml", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renameElement(String xml, String from, String to) {
        String string;
        ByteArrayInputStream istream = new ByteArrayInputStream(xml.getBytes());
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        try {
            XML.renameElement(istream, ostream, from, to);
            string = new String(ostream.toByteArray());
        }
        catch (Throwable throwable) {
            Closer.closeAll(istream, ostream);
            throw throwable;
        }
        Closer.closeAll(istream, ostream);
        return string;
    }

    public static void renameElement(InputStream istream, OutputStream ostream, String fromPattern, final String replacement) {
        final Pattern pattern = Pattern.compile(fromPattern);
        XML.filter(istream, ostream, new XMLFilterImpl(){

            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                Matcher matcher;
                if (localName != null) {
                    matcher = pattern.matcher(localName);
                    localName = matcher.replaceAll(replacement);
                }
                if (qName != null) {
                    matcher = pattern.matcher(qName);
                    qName = matcher.replaceAll(replacement);
                }
                super.startElement(uri, localName, qName, atts);
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                Matcher matcher;
                if (localName != null) {
                    matcher = pattern.matcher(localName);
                    localName = matcher.replaceAll(replacement);
                }
                if (qName != null) {
                    matcher = pattern.matcher(qName);
                    qName = matcher.replaceAll(replacement);
                }
                super.endElement(uri, localName, qName);
            }
        });
    }

    public static String replacePattern(String xml, String patternString, String replacement) {
        return XML.replacePattern(xml, null, patternString, replacement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replacePattern(String xml, String elementName, String patternString, String replacement) {
        String string;
        ByteArrayInputStream istream = new ByteArrayInputStream(xml.getBytes());
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        try {
            XML.replacePattern(istream, ostream, elementName, patternString, replacement);
            string = new String(ostream.toByteArray());
        }
        catch (Throwable throwable) {
            Closer.closeAll(istream, ostream);
            throw throwable;
        }
        Closer.closeAll(istream, ostream);
        return string;
    }

    public static void replacePattern(InputStream istream, OutputStream ostream, final String elementName, String fromPattern, final String replacement) {
        final Pattern pattern = Pattern.compile(fromPattern);
        XML.filter(istream, ostream, new XMLFilterImpl(){
            boolean filterOn = false;

            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                this.filterOn = elementName == null || elementName.equals(localName) || elementName.equals(qName);
                super.startElement(uri, localName, qName, atts);
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                this.filterOn = false;
                super.endElement(uri, localName, qName);
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.filterOn) {
                    String text = new String(ch, start, length);
                    Matcher matcher = pattern.matcher(text);
                    text = matcher.replaceAll(replacement);
                    super.characters(text.toCharArray(), 0, text.length());
                } else {
                    super.characters(ch, start, length);
                }
            }
        });
    }

    public static void main(String[] args) {
        XML.parseDom4jDocument("<slp version=\"1.0\"><ping interval=\"20\"/></slp>");
    }
}

