/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.Messages;

public class DefaultAccessControl
implements AccessControl {
    private Map policyMap = new HashMap();
    private Map roleRestrictMap = new HashMap();
    private static final String PACKAGE_DWR = "uk.ltd.getahead.dwr.";
    static /* synthetic */ Class class$0;

    public String getReasonToNotExecute(HttpServletRequest req, Creator creator, String className, Method method) {
        String problem = this.getReasonToNotDisplay(req, creator, className, method);
        if (problem != null) {
            return problem;
        }
        String methodName = method.getName();
        Set roles = this.getRoleRestrictions(className, methodName);
        if (roles != null) {
            boolean allowed = false;
            Iterator it = roles.iterator();
            while (it.hasNext() && !allowed) {
                String role = (String)it.next();
                if (!req.isUserInRole(role)) continue;
                allowed = true;
            }
            if (!allowed) {
                StringBuffer buffer = new StringBuffer();
                Iterator it2 = roles.iterator();
                while (it2.hasNext()) {
                    String role = (String)it2.next();
                    buffer.append(role);
                    if (!it2.hasNext()) continue;
                    buffer.append(", ");
                }
                return Messages.getString("ExecuteQuery.DeniedByJ2EERoles", buffer.toString());
            }
        }
        return null;
    }

    public String getReasonToNotDisplay(HttpServletRequest req, Creator creator, String className, Method method) {
        String methodName = method.getName();
        if (!Modifier.isPublic(method.getModifiers())) {
            return Messages.getString("ExecuteQuery.DeniedNonPublic");
        }
        if (!this.isExecutable(className, methodName)) {
            return Messages.getString("ExecuteQuery.DeniedByAccessRules");
        }
        if (creator.getType().getName().startsWith(PACKAGE_DWR)) {
            return Messages.getString("ExecuteQuery.DeniedCoreDWR");
        }
        int j = 0;
        while (j < method.getParameterTypes().length) {
            Class<?> paramType = method.getParameterTypes()[j];
            if (paramType.getName().startsWith(PACKAGE_DWR)) {
                return Messages.getString("ExecuteQuery.DeniedParamDWR");
            }
            ++j;
        }
        Class<?> clazz = method.getDeclaringClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return Messages.getString("ExecuteQuery.DeniedObjectMethod");
        }
        return null;
    }

    public void addRoleRestriction(String scriptName, String methodName, String role) {
        String key = String.valueOf(scriptName) + '.' + methodName;
        HashSet<String> roles = (HashSet<String>)this.roleRestrictMap.get(key);
        if (roles == null) {
            roles = new HashSet<String>();
            this.roleRestrictMap.put(key, roles);
        }
        roles.add(role);
    }

    private Set getRoleRestrictions(String scriptName, String methodName) {
        String key = String.valueOf(scriptName) + '.' + methodName;
        return (Set)this.roleRestrictMap.get(key);
    }

    public void addIncludeRule(String scriptName, String methodName) {
        Policy policy = this.getPolicy(scriptName);
        if (policy.defaultAllow) {
            if (policy.rules.size() > 0) {
                throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.MixedIncludesAndExcludes", scriptName));
            }
            policy.defaultAllow = false;
        }
        policy.rules.add(methodName);
    }

    public void addExcludeRule(String scriptName, String methodName) {
        Policy policy = this.getPolicy(scriptName);
        if (!policy.defaultAllow) {
            if (policy.rules.size() > 0) {
                throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.MixedIncludesAndExcludes", scriptName));
            }
            policy.defaultAllow = true;
        }
        policy.rules.add(methodName);
    }

    private boolean isExecutable(String scriptName, String methodName) {
        Policy policy = (Policy)this.policyMap.get(scriptName);
        if (policy == null) {
            return true;
        }
        String match = null;
        Iterator it = policy.rules.iterator();
        while (it.hasNext() && match == null) {
            String test = (String)it.next();
            if (!methodName.equals(test)) continue;
            match = test;
        }
        if (policy.defaultAllow && match != null) {
            return false;
        }
        return policy.defaultAllow || match != null;
    }

    private Policy getPolicy(String type) {
        Policy policy = (Policy)this.policyMap.get(type);
        if (policy == null) {
            policy = new Policy();
            this.policyMap.put(type, policy);
        }
        return policy;
    }

    static class Policy {
        boolean defaultAllow = true;
        List rules = new ArrayList();

        Policy() {
        }
    }
}

