/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctModCmd;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class AuthResponse
extends AuthCommand {
    public static final int ERROR_INVALID_SN_OR_PASS_A = 1;
    public static final int ERROR_INVALID_SN_OR_PASS_B = 4;
    public static final int ERROR_BAD_PASSWORD = 5;
    public static final int ERROR_BAD_INPUT = 6;
    public static final int ERROR_ACCOUNT_DELETED = 8;
    public static final int ERROR_SIGNON_BLOCKED = 17;
    public static final int ERROR_TEMP_UNAVAILABLE_A = 12;
    public static final int ERROR_TEMP_UNAVAILABLE_B = 13;
    public static final int ERROR_TEMP_UNAVAILABLE_C = 19;
    public static final int ERROR_TEMP_UNAVAILABLE_D = 20;
    public static final int ERROR_TEMP_UNAVAILABLE_E = 21;
    public static final int ERROR_TEMP_UNAVAILABLE_F = 26;
    public static final int ERROR_TEMP_UNAVAILABLE_G = 31;
    public static final int ERROR_CONNECTING_TOO_MUCH_A = 24;
    public static final int ERROR_CONNECTING_TOO_MUCH_B = 29;
    public static final int ERROR_CLIENT_TOO_OLD = 27;
    public static final int ERROR_SOMETHING_FUNNY = 28;
    public static final int ERROR_INVALID_SECURID = 32;
    public static final int ERROR_UNDER_13 = 34;
    private static final int TYPE_SN = 1;
    private static final int TYPE_SERVER = 5;
    private static final int TYPE_COOKIE = 6;
    private static final int TYPE_EMAIL = 17;
    private static final int TYPE_ERRCODE = 8;
    private static final int TYPE_ERRURL = 4;
    private static final int TYPE_REGSTATUS = 19;
    private static final int TYPE_PASSWORD_URL = 84;
    private final String sn;
    private final String server;
    private final int port;
    private final ByteBlock cookie;
    private final int regstatus;
    private final String email;
    private final int errorCode;
    private final String errorUrl;
    private final String passwordUrl;

    protected AuthResponse(SnacPacket packet) {
        super(3);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ImmutableTlvChain chain = TlvTools.readChain(packet.getData());
        this.sn = chain.getString(1);
        String serverport = chain.getString(5);
        String tserver = null;
        int tport = -1;
        if (serverport != null && serverport.indexOf(58) != -1) {
            serverport = serverport.trim();
            int colon = serverport.indexOf(58);
            String portString = serverport.substring(colon + 1);
            try {
                tport = Integer.parseInt(portString);
                tserver = serverport.substring(0, colon);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        this.server = tserver;
        this.port = tport;
        this.cookie = chain.hasTlv(6) ? chain.getLastTlv(6).getData() : null;
        this.email = chain.getString(17);
        this.regstatus = chain.getUShort(19);
        this.errorCode = chain.getUShort(8);
        this.errorUrl = chain.getString(4);
        this.passwordUrl = chain.getString(84);
    }

    public AuthResponse(String sn, String server, int port, ByteBlock cookie, int regStatus, String email, String passwordUrl) {
        this(sn, server, port, cookie, regStatus, email, -1, null, passwordUrl);
    }

    public AuthResponse(int errorCode, String errorUrl) {
        this(null, null, -1, null, -1, null, errorCode, errorUrl, null);
    }

    public AuthResponse(String sn, String server, int port, ByteBlock cookie, int regStatus, String email, int errorCode, String errorUrl, String passwordUrl) {
        super(3);
        DefensiveTools.checkRange((int)port, (String)"port", (int)-1);
        DefensiveTools.checkRange((int)regStatus, (String)"regStatus", (int)-1);
        DefensiveTools.checkRange((int)errorCode, (String)"errorCode", (int)-1);
        this.sn = sn;
        this.server = server;
        this.port = port;
        this.cookie = cookie;
        this.regstatus = regStatus;
        this.email = email;
        this.errorCode = errorCode;
        this.errorUrl = errorUrl;
        this.passwordUrl = passwordUrl;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final String getServer() {
        return this.server;
    }

    public final int getPort() {
        return this.port;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public final int getRegstatus() {
        return this.regstatus;
    }

    public final String getEmail() {
        return this.email;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorUrl() {
        return this.errorUrl;
    }

    public String getPasswordUrl() {
        return this.passwordUrl;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(out);
        }
        if (this.server != null) {
            String host = this.server;
            if (this.port != -1) {
                host = host + ":" + this.port;
            }
            Tlv.getStringInstance(5, host).write(out);
        }
        if (this.cookie != null) {
            new Tlv(6, (Writable)this.cookie).write(out);
        }
        if (this.errorCode != -1) {
            Tlv.getUShortInstance(8, this.errorCode).write(out);
        }
        if (this.errorUrl != null) {
            Tlv.getStringInstance(4, this.errorUrl).write(out);
        }
        if (this.email != null) {
            Tlv.getStringInstance(17, this.email).write(out);
        }
        if (this.regstatus != -1) {
            Tlv.getUShortInstance(19, this.regstatus).write(out);
        }
    }

    public String toString() {
        String errorName = null;
        if (this.errorCode != -1) {
            errorName = MiscTools.findIntField(AuthResponse.class, this.errorCode, "ERROR_.*");
        }
        String regName = null;
        if (this.regstatus != -1) {
            regName = MiscTools.findIntField(AcctModCmd.class, this.regstatus, "REGSTATUS_.*");
        }
        return "AuthResponse: sn='" + this.sn + "'" + ", server='" + this.server + "'" + ", port=" + this.port + (this.regstatus == -1 ? "" : ", regStatus=0x" + Integer.toHexString(this.regstatus) + " (" + (regName == null ? "unknown status code" : regName) + ")") + ", email='" + this.email + "'" + (this.errorCode == -1 ? "" : ", errorCode=0x" + Integer.toHexString(this.errorCode) + " (" + (errorName == null ? "unknown error code" : errorName) + ")") + (this.errorUrl == null ? "" : ", errorURL='" + this.errorUrl + "'");
    }
}

