/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.XMLConfigurator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AvalonConfigurator
implements Component,
Configurable,
ThreadSafe,
Disposable {
    private static final Log LOG = LogFactory.getLog((Class)AvalonConfigurator.class);
    public static final String ROLE = AvalonConfigurator.class.getName();
    public static final String CLOSE_ON_DISPOSE_ATTRIBUTE = "close-on-dispose";
    private boolean closeOnDispose = true;
    private final List configuredPools = new ArrayList(3);

    public void configure(Configuration configuration) throws ConfigurationException {
        XMLConfigurator xmlConfigurator = new XMLConfigurator();
        this.closeOnDispose = configuration.getAttributeAsBoolean(CLOSE_ON_DISPOSE_ATTRIBUTE, true);
        Configuration[] children = configuration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getName().equals("proxool")) continue;
            throw new ConfigurationException("Found element named " + children[i].getName() + ". Only " + "proxool" + " top level elements are alowed.");
        }
        try {
            xmlConfigurator.startDocument();
            this.reportProperties(xmlConfigurator, configuration.getChildren());
            xmlConfigurator.endDocument();
        }
        catch (SAXException e) {
            throw new ConfigurationException("", (Throwable)e);
        }
    }

    public void dispose() {
        LOG.info((Object)"Disposing.");
        if (this.closeOnDispose) {
            Iterator configuredPools = this.configuredPools.iterator();
            String alias = null;
            while (configuredPools.hasNext()) {
                alias = (String)configuredPools.next();
                LOG.info((Object)("Closing connection pool '" + alias + "'."));
                try {
                    ProxoolFacade.removeConnectionPool(alias);
                }
                catch (ProxoolException e) {
                    LOG.error((Object)("Closing of connection pool '" + alias + "' failed."), (Throwable)e);
                }
            }
        } else {
            LOG.info((Object)"close-on-dispose attribute is not set, so configured pools will not be closed.");
        }
        LOG.info((Object)"Disposed.");
    }

    private void reportProperties(XMLConfigurator xmlConfigurator, Configuration[] properties) throws ConfigurationException, SAXException {
        Configuration[] children = null;
        String value = null;
        String namespace = null;
        for (int i = 0; i < properties.length; ++i) {
            Configuration configuration = properties[i];
            namespace = configuration.getNamespace();
            if (namespace == null) {
                namespace = "";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reporting element start for " + configuration.getName()));
            }
            String lName = namespace.length() == 0 ? "" : configuration.getName();
            String qName = namespace.length() == 0 ? configuration.getName() : "";
            xmlConfigurator.startElement(namespace, lName, qName, this.getAttributes(configuration));
            children = configuration.getChildren();
            if (children == null || children.length < 1) {
                value = configuration.getValue(null);
                if (value != null) {
                    xmlConfigurator.characters(value.toCharArray(), 0, value.length());
                }
            } else {
                this.reportProperties(xmlConfigurator, children);
            }
            xmlConfigurator.endElement(namespace, lName, qName);
            if (!lName.equals("proxool") && !qName.equals("proxool")) continue;
            Configuration conf = configuration.getChild("alias", false);
            if (conf != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding to configured pools: " + conf.getValue()));
                }
                this.configuredPools.add(conf.getValue());
                continue;
            }
            LOG.error((Object)"proxool element was missing required element 'alias'");
        }
    }

    private Attributes getAttributes(Configuration configuration) throws ConfigurationException {
        AttributesImpl attributes = new AttributesImpl();
        String[] avalonAttributeNames = configuration.getAttributeNames();
        if (avalonAttributeNames != null && avalonAttributeNames.length > 0) {
            for (int i = 0; i < avalonAttributeNames.length; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding attribute " + avalonAttributeNames[i] + " with value " + configuration.getAttribute(avalonAttributeNames[i])));
                }
                attributes.addAttribute("", avalonAttributeNames[i], avalonAttributeNames[i], "CDATA", configuration.getAttribute(avalonAttributeNames[i]));
                LOG.debug((Object)("In attributes: " + avalonAttributeNames[i] + " with value " + attributes.getValue(avalonAttributeNames[i])));
            }
        }
        return attributes;
    }
}

