/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.BasicOperationService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class IsStillExecutingOperation
extends AbstractOperation
implements UrgentSystemOperation {
    private long operationCallId;

    IsStillExecutingOperation() {
    }

    IsStillExecutingOperation(long operationCallId) {
        this.operationCallId = operationCallId;
    }

    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        BasicOperationService operationService = (BasicOperationService)nodeEngine.operationService;
        boolean executing = operationService.isOperationExecuting(this.getCallerAddress(), this.getCallerUuid(), this.operationCallId);
        this.getResponseHandler().sendResponse(executing);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.operationCallId = in.readLong();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.operationCallId);
    }
}

