/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionAddBackupOperation;
import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CollectionAddOperation
extends CollectionBackupAwareOperation {
    protected Data value;
    protected long itemId = -1L;

    public CollectionAddOperation() {
    }

    public CollectionAddOperation(String name, Data value) {
        super(name);
        this.value = value;
    }

    @Override
    public boolean shouldBackup() {
        return this.itemId != -1L;
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionAddBackupOperation(this.name, this.itemId, this.value);
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        if (this.hasEnoughCapacity(1)) {
            this.itemId = this.getOrCreateContainer().add(this.value);
        }
        this.response = this.itemId != -1L;
    }

    @Override
    public void afterRun() throws Exception {
        if (this.itemId != -1L) {
            this.publishEvent(ItemEventType.ADDED, this.value);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.value);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.value = in.readData();
    }
}

