/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.msnftp;

import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnMessenger;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.net.Message;
import net.sf.jml.net.Session;
import net.sf.jml.net.SessionAdapter;
import net.sf.jml.protocol.WrapperMessage;
import net.sf.jml.protocol.msnftp.MsnftpMessage;
import net.sf.jml.protocol.msnftp.MsnftpMessageRecognizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MsnftpSession {
    private static final Log log = LogFactory.getLog(MsnftpSession.class);
    private static final int DEFAULT_TIMEOUT = 30000;
    private final MsnFileTransfer transfer;
    private final Session session = new Session();

    public MsnftpSession(MsnFileTransfer msnFileTransfer) {
        this.transfer = msnFileTransfer;
        this.session.setSessionTimeout(30000);
        this.session.setAttachment(msnFileTransfer);
        this.session.setMessageRecognizer(MsnftpMessageRecognizer.getInstance());
        final MsnMessenger msnMessenger = msnFileTransfer.getMessenger();
        this.session.addSessionListener(new SessionAdapter(){

            public void sessionTimeout(Session session) {
                session.close();
            }

            public void messageReceived(Session session, Message message) {
                if (msnMessenger.isLogIncoming()) {
                    log.info((Object)(msnMessenger.getOwner().getEmail() + " FTP <<< " + message.toString()));
                }
                MsnftpMessage msnftpMessage = (MsnftpMessage)((WrapperMessage)message).getMessage();
                msnftpMessage.messageReceived(MsnftpSession.this);
            }

            public void messageSent(Session session, Message message) {
                if (msnMessenger.isLogOutgoing()) {
                    log.info((Object)(msnMessenger.getOwner().getEmail() + " FTP >>> " + message.toString()));
                }
                MsnftpMessage msnftpMessage = (MsnftpMessage)((WrapperMessage)message).getMessage();
                msnftpMessage.messageSent(MsnftpSession.this);
            }

            public void exceptionCaught(Session session, Throwable throwable) {
                ((AbstractMessenger)msnMessenger).fireExceptionCaught(throwable);
            }
        });
    }

    public MsnFileTransfer getFileTransfer() {
        return this.transfer;
    }

    public Session getSocketSession() {
        return this.session;
    }

    public void close() {
        this.session.close();
    }

    public void sendAsynchronousMessage(MsnftpMessage msnftpMessage) {
        if (msnftpMessage != null) {
            this.session.write(new WrapperMessage(msnftpMessage));
        }
    }

    public boolean sendSynchronousMessage(MsnftpMessage msnftpMessage) {
        if (msnftpMessage != null) {
            return this.session.blockWrite(new WrapperMessage(msnftpMessage));
        }
        return false;
    }
}

