/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import pl.mn.communicator.GGException;
import pl.mn.communicator.GGSessionException;
import pl.mn.communicator.IPublicDirectoryService;
import pl.mn.communicator.PersonalInfo;
import pl.mn.communicator.PublicDirSearchQuery;
import pl.mn.communicator.PublicDirSearchReply;
import pl.mn.communicator.Session;
import pl.mn.communicator.SessionState;
import pl.mn.communicator.event.PublicDirListener;
import pl.mn.communicator.packet.out.GGPubdirRequest;

public class DefaultPublicDirectoryService
implements IPublicDirectoryService {
    private HashSet m_directoryListeners = new HashSet();
    private Session m_session = null;

    DefaultPublicDirectoryService(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
    }

    public void search(PublicDirSearchQuery publicDirQuery) throws GGException {
        if (publicDirQuery == null) {
            throw new NullPointerException("publicDirQuery cannot be null");
        }
        this.checkSessionState();
        try {
            GGPubdirRequest pubdirRequest = GGPubdirRequest.createSearchPubdirRequest(publicDirQuery);
            this.notifyPubdirSearchStarted(pubdirRequest.getSequenceID(), publicDirQuery);
            this.m_session.getSessionAccessor().sendPackage(pubdirRequest);
        }
        catch (IOException ex) {
            throw new GGException("Unable to perform search.", ex);
        }
    }

    public void readFromPublicDirectory() throws GGException {
        this.checkSessionState();
        try {
            GGPubdirRequest pubdirRequest = GGPubdirRequest.createReadPubdirRequest();
            this.m_session.getSessionAccessor().sendPackage(pubdirRequest);
        }
        catch (IOException ex) {
            throw new GGException("Unable to read information from public directory.", ex);
        }
    }

    public void writeToPublicDirectory(PersonalInfo publicDirInfo) throws GGException {
        if (publicDirInfo == null) {
            throw new NullPointerException("publicDirInfo cannot be null");
        }
        this.checkSessionState();
        try {
            GGPubdirRequest pubdirRequest = GGPubdirRequest.createWritePubdirRequest(publicDirInfo);
            this.m_session.getSessionAccessor().sendPackage(pubdirRequest);
        }
        catch (IOException ex) {
            throw new GGException("Unable to write or update information in public directory.");
        }
    }

    public void addPublicDirListener(PublicDirListener publicDirListener) {
        if (publicDirListener == null) {
            throw new NullPointerException("publicDirListener cannot be null");
        }
        this.m_directoryListeners.add(publicDirListener);
    }

    public void removePublicDirListener(PublicDirListener publicDirListener) {
        if (publicDirListener == null) {
            throw new NullPointerException("pubDirListener cannot be null");
        }
        this.m_directoryListeners.remove(publicDirListener);
    }

    protected void notifyPubdirRead(int queryID, PersonalInfo publicDirInfo) {
        if (publicDirInfo == null) {
            throw new NullPointerException("publicDirInfo cannot be null");
        }
        Iterator it = this.m_directoryListeners.iterator();
        while (it.hasNext()) {
            PublicDirListener publicDirListener = (PublicDirListener)it.next();
            publicDirListener.onPublicDirectoryRead(queryID, publicDirInfo);
        }
    }

    protected void notifyPubdirUpdated(int queryID) {
        Iterator it = this.m_directoryListeners.iterator();
        while (it.hasNext()) {
            PublicDirListener publicDirListener = (PublicDirListener)it.next();
            publicDirListener.onPublicDirectoryUpdated(queryID);
        }
    }

    protected void notifyPubdirSearchStarted(int queryID, PublicDirSearchQuery publicDirSearchQuery) {
        if (publicDirSearchQuery == null) {
            throw new NullPointerException("publicDirSearchQuery cannot be null");
        }
        Iterator it = this.m_directoryListeners.iterator();
        while (it.hasNext()) {
            PublicDirListener publicDirListener = (PublicDirListener)it.next();
            publicDirListener.onPublicDirectorySearchStarted(queryID, publicDirSearchQuery);
        }
    }

    protected void notifyPubdirGotSearchResults(int queryID, PublicDirSearchReply publicDirSearchReply) {
        if (publicDirSearchReply == null) {
            throw new NullPointerException("publicDirSearchReply cannot be null");
        }
        Iterator it = this.m_directoryListeners.iterator();
        while (it.hasNext()) {
            PublicDirListener publicDirListener = (PublicDirListener)it.next();
            publicDirListener.onPublicDirectorySearchReply(queryID, publicDirSearchReply);
        }
    }

    private void checkSessionState() throws GGSessionException {
        if (this.m_session.getSessionState() != SessionState.LOGGED_IN) {
            throw new GGSessionException(this.m_session.getSessionState());
        }
    }
}

