/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.util.Date;
import pl.mn.communicator.IStatus;
import pl.mn.communicator.StatusType;

public abstract class AbstractStatus
implements IStatus {
    private StatusType m_statusType = StatusType.ONLINE;
    private String m_description = null;
    private Date m_returnTime = null;

    protected AbstractStatus(StatusType statusType, String description, Date returnDate) {
        if (statusType == null) {
            throw new NullPointerException("statusType cannot be null");
        }
        this.m_statusType = statusType;
        this.m_description = description;
        this.m_returnTime = returnDate;
    }

    protected AbstractStatus(StatusType statusType, String description) {
        this(statusType, description, null);
    }

    protected AbstractStatus(StatusType statusType) {
        this(statusType, null, null);
    }

    public StatusType getStatusType() {
        return this.m_statusType;
    }

    public void setStatusType(StatusType status) {
        this.m_statusType = status;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public Date getReturnDate() {
        if (this.m_returnTime == null) {
            return null;
        }
        return new Date(this.m_returnTime.getTime());
    }

    public void setReturnDate(Date returnTime) {
        if (returnTime == null) {
            throw new NullPointerException("returnTime cannot be null");
        }
        this.m_returnTime = new Date(returnTime.getTime());
    }

    public boolean isDescriptionSet() {
        return this.m_description != null;
    }

    public boolean isReturnDateSet() {
        return this.m_returnTime != null;
    }
}

