/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LogWriter;
import gov.nist.core.ThreadAuditor;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.DefaultNetworkLayer;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.DefaultAddressResolver;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.LogRecordFactory;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.ServerLog;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;

public abstract class SIPTransactionStack
implements SIPTransactionEventListener {
    public static final int BASE_TIMER_INTERVAL = 500;
    public static final int CONNECTION_LINGER_TIME = 8;
    protected ConcurrentHashMap retransmissionAlertTransactions;
    protected ConcurrentHashMap dialogTable;
    protected HashSet dialogCreatingMethods;
    protected Timer timer;
    private ConcurrentHashMap pendingTransactions;
    private ConcurrentHashMap clientTransactionTable;
    private boolean unlimitedServerTransactionTableSize = false;
    protected boolean unlimitedClientTransactionTableSize = true;
    protected int serverTransactionTableHighwaterMark = 5000;
    protected int serverTransactionTableLowaterMark = 4000;
    protected int clientTransactionTableHiwaterMark = 1000;
    protected int clientTransactionTableLowaterMark = 800;
    private int activeClientTransactionCount;
    private ConcurrentHashMap serverTransactionTable;
    private ConcurrentHashMap mergeTable;
    protected LogWriter logWriter;
    protected ServerLog serverLog;
    boolean udpFlag;
    protected DefaultRouter defaultRouter;
    protected boolean needsLogging;
    private boolean non2XXAckPassedToListener;
    protected IOHandler ioHandler;
    protected boolean toExit = false;
    protected String stackName;
    protected String stackAddress;
    protected InetAddress stackInetAddress;
    protected StackMessageFactory sipMessageFactory;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    protected boolean cacheServerConnections = true;
    protected boolean cacheClientConnections = true;
    protected boolean useRouterForAll;
    protected int maxContentLength;
    protected int maxMessageSize;
    private Collection messageProcessors;
    protected int readTimeout = -1;
    protected NetworkLayer networkLayer;
    protected String outboundProxy;
    protected String routerPath;
    protected boolean isAutomaticDialogSupportEnabled;
    protected HashSet forkedEvents;
    protected boolean generateTimeStampHeader;
    protected AddressResolver addressResolver;
    protected int maxListenerResponseTime = -1;
    protected boolean useTlsAccelerator;
    protected ThreadAuditor threadAuditor = new ThreadAuditor();
    protected LogRecordFactory logRecordFactory;

    protected SIPTransactionStack() {
        this.forkedEvents = new HashSet();
        this.messageProcessors = new ArrayList();
        this.ioHandler = new IOHandler(this);
        this.dialogCreatingMethods = new HashSet();
        this.dialogCreatingMethods.add("REFER");
        this.dialogCreatingMethods.add("INVITE");
        this.dialogCreatingMethods.add("SUBSCRIBE");
        this.addressResolver = new DefaultAddressResolver();
        this.dialogTable = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.timer = new Timer();
        this.pendingTransactions = new ConcurrentHashMap();
        if (this.getThreadAuditor().isEnabled()) {
            this.timer.schedule((TimerTask)new PingTimer(null), 0L);
        }
    }

    protected void reInit() {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Re-initializing !");
        }
        this.messageProcessors = new ArrayList();
        this.ioHandler = new IOHandler(this);
        this.pendingTransactions = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.dialogTable = new ConcurrentHashMap();
        this.timer = new Timer();
    }

    public void disableLogging() {
        this.getLogWriter().disableLogging();
    }

    public void enableLogging() {
        this.getLogWriter().enableLogging();
    }

    public void printDialogTable() {
        if (this.getLogWriter().isLoggingEnabled()) {
            this.getLogWriter().logDebug("dialog table  = " + this.dialogTable);
            System.out.println("dialog table = " + this.dialogTable);
        }
    }

    public SIPServerTransaction getRetransmissionAlertTransaction(String string) {
        return (SIPServerTransaction)this.retransmissionAlertTransactions.get((Object)string);
    }

    public boolean isDialogCreated(String string) {
        boolean bl = this.dialogCreatingMethods.contains(string);
        if (this.isLoggingEnabled()) {
            this.getLogWriter().logDebug("isDialogCreated : " + string + " returning " + bl);
        }
        return bl;
    }

    public void addExtensionMethod(String string) {
        if (string.equals("NOTIFY")) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("NOTIFY Supported Natively");
            }
        } else {
            this.dialogCreatingMethods.add(string.trim().toUpperCase());
        }
    }

    public void putDialog(SIPDialog sIPDialog) {
        String string = sIPDialog.getDialogId();
        if (this.dialogTable.containsKey((Object)string)) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("putDialog: dialog already exists" + string + " in table = " + this.dialogTable.get((Object)string));
            }
            return;
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("putDialog dialogId=" + string + " dialog = " + sIPDialog);
        }
        sIPDialog.setStack(this);
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logStackTrace();
        }
        this.dialogTable.put((Object)string, (Object)sIPDialog);
    }

    public SIPDialog createDialog(SIPTransaction sIPTransaction) {
        SIPDialog sIPDialog = new SIPDialog(sIPTransaction);
        return sIPDialog;
    }

    public Iterator getDialogs() {
        return this.dialogTable.values().iterator();
    }

    public void removeDialog(SIPDialog sIPDialog) {
        Object object;
        String string = sIPDialog.getDialogId();
        if (string != null && (object = this.dialogTable.remove((Object)string)) != null && !sIPDialog.testAndSetIsDialogTerminatedEventDelivered()) {
            DialogTerminatedEvent dialogTerminatedEvent = new DialogTerminatedEvent((Object)sIPDialog.getSipProvider(), (Dialog)sIPDialog);
            sIPDialog.getSipProvider().handleEvent((EventObject)dialogTerminatedEvent, null);
        }
    }

    public SIPDialog getDialog(String string) {
        SIPDialog sIPDialog = (SIPDialog)this.dialogTable.get((Object)string);
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("getDialog(" + string + ") : returning " + sIPDialog);
        }
        return sIPDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIPClientTransaction findSubscribeTransaction(SIPRequest var1_1, ListeningPointImpl var2_2) {
        var3_3 = null;
        try {
            var4_4 = this.clientTransactionTable.values().iterator();
            this.logWriter.logDebug("ct table size = " + this.clientTransactionTable.size());
            var5_5 = var1_1.getTo().getTag();
            if (var5_5 == null) {
                var6_6 = var3_3;
                if (this.isLoggingEnabled()) {
                    this.logWriter.logDebug("findSubscribeTransaction : returning " + var3_3);
                }
                return var6_6;
            }
        }
        catch (Throwable var18_20) {
            if (this.isLoggingEnabled()) {
                this.logWriter.logDebug("findSubscribeTransaction : returning " + var3_3);
            }
            throw var18_20;
        }
        {
            var6_7 = (Event)var1_1.getHeader("Event");
            if (var6_7 != null) ** GOTO lbl-1000
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("event Header is null -- returning null");
            }
            var7_8 = var3_3;
            if (this.isLoggingEnabled()) {
                this.logWriter.logDebug("findSubscribeTransaction : returning " + var3_3);
            }
            return var7_8;
        }
lbl-1000:
        // 4 sources

        {
            while (var4_4.hasNext()) {
                var7_9 = (SIPClientTransaction)var4_4.next();
                if (!var7_9.getMethod().equals("SUBSCRIBE")) continue;
                var8_10 = var7_9.getOriginalRequest();
                var9_11 = var8_10.getContactHeader();
                var10_12 = var9_11.getAddress();
                var11_13 = (SipURI)var10_12.getURI();
                var12_14 = var11_13.getHost();
                var13_15 = var11_13.getPort();
                var14_16 = var11_13.getTransportParam();
                if (var14_16 == null) {
                    var14_16 = "udp";
                }
                if (var13_15 == -1) {
                    var13_15 = var14_16.equals("udp") != false || var14_16.equals("tcp") != false ? 5060 : 5061;
                }
                var15_17 = var7_9.from.getTag();
                var16_18 = var7_9.event;
                if (var16_18 == null) continue;
                if (this.isLoggingEnabled()) {
                    this.logWriter.logDebug("ct.fromTag = " + var15_17);
                    this.logWriter.logDebug("thisToTag = " + var5_5);
                    this.logWriter.logDebug("hisEvent = " + var16_18);
                    this.logWriter.logDebug("eventHdr " + var6_7);
                }
                if (var2_2.getPort() != var13_15 || !var2_2.getIPAddress().equals(var12_14) || !var15_17.equalsIgnoreCase(var5_5) || var16_18 == null || !var6_7.match(var16_18) || !var1_1.getCallId().getCallId().equalsIgnoreCase(var7_9.callId.getCallId())) continue;
                if (var7_9.acquireSem()) {
                    var3_3 = var7_9;
                }
                var17_19 = var3_3;
                if (this.isLoggingEnabled()) {
                    this.logWriter.logDebug("findSubscribeTransaction : returning " + var3_3);
                }
                return var17_19;
            }
        }
        {
            var7_9 = var3_3;
            if (this.isLoggingEnabled()) {
                this.logWriter.logDebug("findSubscribeTransaction : returning " + var3_3);
            }
            return var7_9;
        }
    }

    public SIPTransaction findTransaction(SIPMessage sIPMessage, boolean bl) {
        SIPTransaction sIPTransaction = null;
        if (bl) {
            Object object;
            Via via = sIPMessage.getTopmostVia();
            if (via.getBranch() != null) {
                object = sIPMessage.getTransactionId();
                sIPTransaction = (SIPTransaction)this.serverTransactionTable.get(object);
                if (this.logWriter.isLoggingEnabled()) {
                    this.getLogWriter().logDebug("serverTx: looking for key " + (String)object + " existing=" + this.serverTransactionTable);
                }
                if (((String)object).startsWith("z9hg4bk")) {
                    return sIPTransaction;
                }
            }
            object = this.serverTransactionTable.values().iterator();
            while (object.hasNext()) {
                SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)object.next();
                if (!sIPServerTransaction.isMessagePartOfTransaction(sIPMessage)) continue;
                return sIPServerTransaction;
            }
        } else {
            Object object;
            Via via = sIPMessage.getTopmostVia();
            if (via.getBranch() != null) {
                object = sIPMessage.getTransactionId();
                if (this.logWriter.isLoggingEnabled()) {
                    this.getLogWriter().logDebug("clientTx: looking for key " + (String)object);
                }
                sIPTransaction = (SIPTransaction)this.clientTransactionTable.get(object);
                if (((String)object).startsWith("z9hg4bk")) {
                    return sIPTransaction;
                }
            }
            object = this.clientTransactionTable.values().iterator();
            while (object.hasNext()) {
                SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)object.next();
                if (!sIPClientTransaction.isMessagePartOfTransaction(sIPMessage)) continue;
                return sIPClientTransaction;
            }
        }
        return null;
    }

    public SIPTransaction findCancelTransaction(SIPRequest sIPRequest, boolean bl) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("findCancelTransaction request= \n" + sIPRequest + "\nfindCancelRequest isServer=" + bl);
        }
        if (bl) {
            Iterator iterator = this.serverTransactionTable.values().iterator();
            while (iterator.hasNext()) {
                SIPTransaction sIPTransaction = (SIPTransaction)iterator.next();
                SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)sIPTransaction;
                if (!sIPServerTransaction.doesCancelMatchTransaction(sIPRequest)) continue;
                return sIPServerTransaction;
            }
        } else {
            Iterator iterator = this.clientTransactionTable.values().iterator();
            while (iterator.hasNext()) {
                SIPTransaction sIPTransaction = (SIPTransaction)iterator.next();
                SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)sIPTransaction;
                if (!sIPClientTransaction.doesCancelMatchTransaction(sIPRequest)) continue;
                return sIPClientTransaction;
            }
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Could not find transaction for cancel request");
        }
        return null;
    }

    protected SIPTransactionStack(StackMessageFactory stackMessageFactory) {
        this();
        this.sipMessageFactory = stackMessageFactory;
    }

    public SIPServerTransaction findPendingTransaction(SIPRequest sIPRequest) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("looking for pending tx for :" + sIPRequest.getTransactionId());
        }
        return (SIPServerTransaction)this.pendingTransactions.get((Object)sIPRequest.getTransactionId());
    }

    public SIPServerTransaction findMergedTransaction(SIPRequest sIPRequest) {
        if (!this.isDialogCreated(sIPRequest.getMethod())) {
            return null;
        }
        String string = sIPRequest.getMergeId();
        if (string != null) {
            return (SIPServerTransaction)this.mergeTable.get((Object)string);
        }
        return null;
    }

    public void removePendingTransaction(SIPServerTransaction sIPServerTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("removePendingTx: " + sIPServerTransaction.getTransactionId());
        }
        this.pendingTransactions.remove((Object)sIPServerTransaction.getTransactionId());
    }

    public void removeFromMergeTable(SIPServerTransaction sIPServerTransaction) {
        String string;
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Removing tx from merge table ");
        }
        if ((string = ((SIPRequest)sIPServerTransaction.getRequest()).getMergeId()) != null) {
            this.mergeTable.remove((Object)string);
        }
    }

    public void putInMergeTable(SIPServerTransaction sIPServerTransaction, SIPRequest sIPRequest) {
        String string = sIPRequest.getMergeId();
        if (string != null) {
            this.mergeTable.put((Object)string, (Object)sIPServerTransaction);
        }
    }

    public void mapTransaction(SIPServerTransaction sIPServerTransaction) {
        if (sIPServerTransaction.isMapped) {
            return;
        }
        this.addTransactionHash(sIPServerTransaction);
        sIPServerTransaction.startTransactionTimer();
        sIPServerTransaction.isMapped = true;
    }

    public ServerRequestInterface newSIPServerRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        String string = sIPRequest.getTransactionId();
        sIPRequest.setMessageChannel(messageChannel);
        SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)this.serverTransactionTable.get((Object)string);
        if (sIPServerTransaction == null || !sIPServerTransaction.isMessagePartOfTransaction(sIPRequest)) {
            Iterator iterator = this.serverTransactionTable.values().iterator();
            sIPServerTransaction = null;
            if (!string.toLowerCase().startsWith("z9hg4bk")) {
                while (iterator.hasNext() && sIPServerTransaction == null) {
                    SIPServerTransaction sIPServerTransaction2 = (SIPServerTransaction)iterator.next();
                    if (!sIPServerTransaction2.isMessagePartOfTransaction(sIPRequest)) continue;
                    sIPServerTransaction = sIPServerTransaction2;
                }
            }
            if (sIPServerTransaction == null) {
                sIPServerTransaction = this.findPendingTransaction(sIPRequest);
                if (sIPServerTransaction != null) {
                    sIPRequest.setTransaction(sIPServerTransaction);
                    if (sIPServerTransaction != null && sIPServerTransaction.acquireSem()) {
                        return sIPServerTransaction;
                    }
                    return null;
                }
                sIPServerTransaction = this.createServerTransaction(messageChannel);
                if (sIPServerTransaction != null) {
                    sIPServerTransaction.setOriginalRequest(sIPRequest);
                    sIPRequest.setTransaction(sIPServerTransaction);
                }
            }
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("newSIPServerRequest( " + sIPRequest.getMethod() + ":" + sIPRequest.getTopmostVia().getBranch() + "):" + sIPServerTransaction);
        }
        if (sIPServerTransaction != null) {
            sIPServerTransaction.setRequestInterface(this.sipMessageFactory.newSIPServerRequest(sIPRequest, sIPServerTransaction));
        }
        if (sIPServerTransaction != null && sIPServerTransaction.acquireSem()) {
            return sIPServerTransaction;
        }
        return null;
    }

    protected ServerResponseInterface newSIPServerResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        String string = sIPResponse.getTransactionId();
        SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.clientTransactionTable.get((Object)string);
        if (sIPClientTransaction == null || !sIPClientTransaction.isMessagePartOfTransaction(sIPResponse)) {
            Iterator iterator = this.clientTransactionTable.values().iterator();
            sIPClientTransaction = null;
            while (iterator.hasNext() && sIPClientTransaction == null) {
                SIPClientTransaction sIPClientTransaction2 = (SIPClientTransaction)iterator.next();
                if (!sIPClientTransaction2.isMessagePartOfTransaction(sIPResponse)) continue;
                sIPClientTransaction = sIPClientTransaction2;
            }
            if (sIPClientTransaction == null) {
                if (this.logWriter.isLoggingEnabled(16)) {
                    messageChannel.logResponse(sIPResponse, System.currentTimeMillis(), "before processing");
                }
                return this.sipMessageFactory.newSIPServerResponse(sIPResponse, messageChannel);
            }
        }
        sIPClientTransaction.setResponseInterface(this.sipMessageFactory.newSIPServerResponse(sIPResponse, sIPClientTransaction));
        if (this.logWriter.isLoggingEnabled(16)) {
            sIPClientTransaction.logResponse(sIPResponse, System.currentTimeMillis(), "before processing");
        }
        if (sIPClientTransaction.acquireSem()) {
            return sIPClientTransaction;
        }
        return null;
    }

    public MessageChannel createMessageChannel(SIPRequest sIPRequest, MessageProcessor messageProcessor, Hop hop) throws IOException {
        Host host = new Host();
        host.setHostname(hop.getHost());
        HostPort hostPort = new HostPort();
        hostPort.setHost(host);
        hostPort.setPort(hop.getPort());
        MessageChannel messageChannel = messageProcessor.createMessageChannel(hostPort);
        if (messageChannel == null) {
            return null;
        }
        SIPClientTransaction sIPClientTransaction = this.createClientTransaction(sIPRequest, messageChannel);
        sIPClientTransaction.setViaPort(hop.getPort());
        sIPClientTransaction.setViaHost(hop.getHost());
        this.addTransactionHash(sIPClientTransaction);
        ((SIPTransaction)sIPClientTransaction).startTransactionTimer();
        return sIPClientTransaction;
    }

    public SIPClientTransaction createClientTransaction(SIPRequest sIPRequest, MessageChannel messageChannel) {
        SIPClientTransaction sIPClientTransaction = new SIPClientTransaction(this, messageChannel);
        sIPClientTransaction.setOriginalRequest(sIPRequest);
        return sIPClientTransaction;
    }

    public SIPServerTransaction createServerTransaction(MessageChannel messageChannel) {
        boolean bl;
        if (this.unlimitedServerTransactionTableSize || this.serverTransactionTable.size() < this.serverTransactionTableLowaterMark) {
            return new SIPServerTransaction(this, messageChannel);
        }
        if (this.serverTransactionTable.size() >= this.serverTransactionTableHighwaterMark) {
            return null;
        }
        float f = (float)(this.serverTransactionTable.size() - this.serverTransactionTableLowaterMark) / (float)(this.serverTransactionTableHighwaterMark - this.serverTransactionTableLowaterMark);
        boolean bl2 = bl = Math.random() > 1.0 - (double)f;
        if (bl) {
            return null;
        }
        return new SIPServerTransaction(this, messageChannel);
    }

    public int getClientTransactionTableSize() {
        return this.clientTransactionTable.size();
    }

    public void addTransaction(SIPClientTransaction sIPClientTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("added transaction " + sIPClientTransaction);
        }
        this.addTransactionHash(sIPClientTransaction);
        sIPClientTransaction.startTransactionTimer();
    }

    public void removeTransaction(SIPTransaction sIPTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Removing Transaction = " + sIPTransaction.getTransactionId() + " transaction = " + sIPTransaction);
        }
        if (sIPTransaction instanceof SIPServerTransaction) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logStackTrace();
            }
            String string = sIPTransaction.getTransactionId();
            Object object = this.serverTransactionTable.remove((Object)string);
            String string2 = sIPTransaction.getMethod();
            this.removePendingTransaction((SIPServerTransaction)sIPTransaction);
            if (this.isDialogCreated(string2)) {
                this.removeFromMergeTable((SIPServerTransaction)sIPTransaction);
            }
            SipProviderImpl sipProviderImpl = sIPTransaction.getSipProvider();
            if (object != null && sIPTransaction.testAndSetTransactionTerminatedEvent()) {
                TransactionTerminatedEvent transactionTerminatedEvent = new TransactionTerminatedEvent((Object)sipProviderImpl, (ServerTransaction)sIPTransaction);
                sipProviderImpl.handleEvent((EventObject)transactionTerminatedEvent, sIPTransaction);
            }
        } else {
            String string = sIPTransaction.getTransactionId();
            Object object = this.clientTransactionTable.remove((Object)string);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("REMOVED client tx " + object + " KEY = " + string);
            }
            if (object != null && sIPTransaction.testAndSetTransactionTerminatedEvent()) {
                SipProviderImpl sipProviderImpl = sIPTransaction.getSipProvider();
                TransactionTerminatedEvent transactionTerminatedEvent = new TransactionTerminatedEvent((Object)sipProviderImpl, (ClientTransaction)sIPTransaction);
                sipProviderImpl.handleEvent((EventObject)transactionTerminatedEvent, sIPTransaction);
            }
        }
    }

    public void addTransaction(SIPServerTransaction sIPServerTransaction) throws IOException {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("added transaction " + sIPServerTransaction);
        }
        sIPServerTransaction.map();
        this.addTransactionHash(sIPServerTransaction);
        sIPServerTransaction.startTransactionTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransactionHash(SIPTransaction sIPTransaction) {
        SIPRequest sIPRequest = sIPTransaction.getOriginalRequest();
        if (sIPTransaction instanceof SIPClientTransaction) {
            String string;
            block10: {
                if (!this.unlimitedClientTransactionTableSize && this.activeClientTransactionCount > this.clientTransactionTableHiwaterMark) {
                    try {
                        string = this.clientTransactionTable;
                        synchronized (string) {
                            this.clientTransactionTable.wait();
                        }
                    }
                    catch (Exception exception) {
                        if (!this.logWriter.isLoggingEnabled()) break block10;
                        this.logWriter.logError("Exception occured while waiting for room", exception);
                    }
                }
            }
            ++this.activeClientTransactionCount;
            string = sIPRequest.getTransactionId();
            this.clientTransactionTable.put((Object)string, (Object)sIPTransaction);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug(" putTransactionHash :  key = " + string);
            }
        } else {
            String string = sIPRequest.getTransactionId();
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug(" putTransactionHash :  key = " + string);
            }
            this.serverTransactionTable.put((Object)string, (Object)sIPTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementActiveClientTransactionCount() {
        --this.activeClientTransactionCount;
        if (this.activeClientTransactionCount <= this.clientTransactionTableLowaterMark && !this.unlimitedClientTransactionTableSize) {
            ConcurrentHashMap concurrentHashMap = this.clientTransactionTable;
            synchronized (concurrentHashMap) {
                this.clientTransactionTable.notify();
            }
        }
    }

    protected void removeTransactionHash(SIPTransaction sIPTransaction) {
        SIPRequest sIPRequest = sIPTransaction.getOriginalRequest();
        if (sIPRequest == null) {
            return;
        }
        if (sIPTransaction instanceof SIPClientTransaction) {
            String string = sIPTransaction.getTransactionId();
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logStackTrace();
                this.logWriter.logDebug("removing client Tx : " + string);
            }
            this.clientTransactionTable.remove((Object)string);
        } else if (sIPTransaction instanceof SIPServerTransaction) {
            String string = sIPTransaction.getTransactionId();
            this.serverTransactionTable.remove((Object)string);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("removing server Tx : " + string);
            }
        }
    }

    public synchronized void transactionErrorEvent(SIPTransactionErrorEvent sIPTransactionErrorEvent) {
        SIPTransaction sIPTransaction = (SIPTransaction)sIPTransactionErrorEvent.getSource();
        if (sIPTransactionErrorEvent.getErrorID() == 2) {
            sIPTransaction.setState(SIPTransaction.TERMINATED_STATE);
            if (sIPTransaction instanceof SIPServerTransaction) {
                ((SIPServerTransaction)sIPTransaction).collectionTime = 0;
            }
            sIPTransaction.disableTimeoutTimer();
            sIPTransaction.disableRetransmissionTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.pendingTransactions.clear();
        this.toExit = true;
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.clientTransactionTable;
        synchronized (object) {
            this.clientTransactionTable.notifyAll();
        }
        object = this.messageProcessors;
        synchronized (object) {
            MessageProcessor[] messageProcessorArray = this.getMessageProcessors();
            for (int i = 0; i < messageProcessorArray.length; ++i) {
                this.removeMessageProcessor(messageProcessorArray[i]);
            }
            this.ioHandler.closeAll();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clientTransactionTable.clear();
        this.serverTransactionTable.clear();
        this.dialogTable.clear();
        this.serverLog.closeLogFile();
    }

    public void putPendingTransaction(SIPServerTransaction sIPServerTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("putPendingTransaction: " + sIPServerTransaction);
        }
        this.pendingTransactions.put((Object)sIPServerTransaction.getTransactionId(), (Object)sIPServerTransaction);
    }

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    public boolean isLoggingEnabled() {
        return this.logWriter == null ? false : this.logWriter.isLoggingEnabled();
    }

    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public ServerLog getServerLog() {
        return this.serverLog;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int n) {
        this.threadPoolSize = n;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public Hop getNextHop(SIPRequest sIPRequest) throws SipException {
        if (this.useRouterForAll) {
            if (this.router != null) {
                return this.router.getNextHop((Request)sIPRequest);
            }
            return null;
        }
        if (sIPRequest.getRequestURI().isSipURI() || sIPRequest.getRouteHeaders() != null) {
            return this.defaultRouter.getNextHop(sIPRequest);
        }
        if (this.router != null) {
            return this.router.getNextHop((Request)sIPRequest);
        }
        return null;
    }

    public void setStackName(String string) {
        this.stackName = string;
    }

    public Server createServerHeaderForStack() {
        Server server = new Server();
        server.addProductToken(this.stackName);
        return server;
    }

    protected void setHostAddress(String string) throws UnknownHostException {
        this.stackAddress = string.indexOf(58) != string.lastIndexOf(58) && string.trim().charAt(0) != '[' ? '[' + string + ']' : string;
        this.stackInetAddress = InetAddress.getByName(string);
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    protected void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter(SIPRequest sIPRequest) {
        if (sIPRequest.getRequestLine() == null) {
            return this.defaultRouter;
        }
        if (this.useRouterForAll) {
            return this.router;
        }
        if (sIPRequest.getRequestURI().getScheme().equals("sip") || sIPRequest.getRequestURI().getScheme().equals("sips")) {
            return this.defaultRouter;
        }
        if (this.router != null) {
            return this.router;
        }
        return this.defaultRouter;
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageProcessor(MessageProcessor messageProcessor) throws IOException {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            this.messageProcessors.add(messageProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageProcessor(MessageProcessor messageProcessor) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            if (this.messageProcessors.remove(messageProcessor)) {
                messageProcessor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageProcessor[] getMessageProcessors() {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            return this.messageProcessors.toArray(new MessageProcessor[0]);
        }
    }

    protected MessageProcessor createMessageProcessor(InetAddress inetAddress, int n, String string) throws IOException {
        if (string.equalsIgnoreCase("udp")) {
            UDPMessageProcessor uDPMessageProcessor = new UDPMessageProcessor(inetAddress, this, n);
            this.addMessageProcessor(uDPMessageProcessor);
            this.udpFlag = true;
            return uDPMessageProcessor;
        }
        if (string.equalsIgnoreCase("tcp")) {
            TCPMessageProcessor tCPMessageProcessor = new TCPMessageProcessor(inetAddress, this, n);
            this.addMessageProcessor(tCPMessageProcessor);
            return tCPMessageProcessor;
        }
        if (string.equalsIgnoreCase("tls")) {
            TLSMessageProcessor tLSMessageProcessor = new TLSMessageProcessor(inetAddress, this, n);
            this.addMessageProcessor(tLSMessageProcessor);
            return tLSMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(StackMessageFactory stackMessageFactory) {
        this.sipMessageFactory = stackMessageFactory;
    }

    public MessageChannel createRawMessageChannel(String string, int n, Hop hop) throws UnknownHostException {
        Host host = new Host();
        host.setHostname(hop.getHost());
        HostPort hostPort = new HostPort();
        hostPort.setHost(host);
        hostPort.setPort(hop.getPort());
        MessageChannel messageChannel = null;
        Iterator iterator = this.messageProcessors.iterator();
        while (iterator.hasNext() && messageChannel == null) {
            MessageProcessor messageProcessor = (MessageProcessor)iterator.next();
            if (!hop.getTransport().equalsIgnoreCase(messageProcessor.getTransport()) || !string.equals(messageProcessor.getIpAddress().getHostAddress()) || n != messageProcessor.getPort()) continue;
            try {
                messageChannel = messageProcessor.createMessageChannel(hostPort);
            }
            catch (UnknownHostException unknownHostException) {
                if (this.logWriter.isLoggingEnabled()) {
                    this.logWriter.logException(unknownHostException);
                }
                throw unknownHostException;
            }
            catch (IOException iOException) {
                if (!this.logWriter.isLoggingEnabled()) continue;
                this.logWriter.logException(iOException);
            }
        }
        return messageChannel;
    }

    public boolean isEventForked(String string) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("isEventForked: " + string + " returning " + this.forkedEvents.contains(string));
        }
        return this.forkedEvents.contains(string);
    }

    public AddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    public void setLogRecordFactory(LogRecordFactory logRecordFactory) {
        this.logRecordFactory = logRecordFactory;
    }

    public ThreadAuditor getThreadAuditor() {
        return this.threadAuditor;
    }

    public String auditStack(Set set, long l, long l2) {
        String string = null;
        String string2 = this.auditDialogs(set, l);
        String string3 = this.auditTransactions(this.serverTransactionTable, l2);
        String string4 = this.auditTransactions(this.clientTransactionTable, l2);
        if (string2 != null || string3 != null || string4 != null) {
            string = "SIP Stack Audit:\n" + (string2 != null ? string2 : "") + (string3 != null ? string3 : "") + (string4 != null ? string4 : "");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String auditDialogs(Set set, long l) {
        LinkedList linkedList;
        String string = "  Leaked dialogs:\n";
        int n = 0;
        long l2 = System.currentTimeMillis();
        Object object = this.dialogTable;
        synchronized (object) {
            linkedList = new LinkedList(this.dialogTable.values());
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            SIPDialog sIPDialog = (SIPDialog)object.next();
            CallIdHeader callIdHeader = sIPDialog != null ? sIPDialog.getCallId() : null;
            String string2 = callIdHeader != null ? callIdHeader.getCallId() : null;
            if (string2 == null || set.contains(string2)) continue;
            if (sIPDialog.auditTag == 0L) {
                sIPDialog.auditTag = l2;
                continue;
            }
            if (l2 - sIPDialog.auditTag < l) continue;
            ++n;
            DialogState dialogState = sIPDialog.getState();
            String string3 = "dialog id: " + sIPDialog.getDialogId() + ", dialog state: " + (dialogState != null ? dialogState.toString() : "null");
            string = string + "    " + string3 + "\n";
            sIPDialog.setState(3);
            this.logWriter.logDebug("auditDialogs: leaked " + string3);
        }
        string = n > 0 ? string + "    Total: " + Integer.toString(n) + " leaked dialogs detected and removed.\n" : null;
        return string;
    }

    private String auditTransactions(ConcurrentHashMap concurrentHashMap, long l) {
        String string = "  Leaked transactions:\n";
        int n = 0;
        long l2 = System.currentTimeMillis();
        LinkedList linkedList = new LinkedList(concurrentHashMap.values());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            SIPTransaction sIPTransaction = (SIPTransaction)iterator.next();
            if (sIPTransaction == null) continue;
            if (sIPTransaction.auditTag == 0L) {
                sIPTransaction.auditTag = l2;
                continue;
            }
            if (l2 - sIPTransaction.auditTag < l) continue;
            ++n;
            TransactionState transactionState = sIPTransaction.getState();
            SIPRequest sIPRequest = sIPTransaction.getOriginalRequest();
            String string2 = sIPRequest != null ? sIPRequest.getMethod() : null;
            String string3 = sIPTransaction.getClass().getName() + ", state: " + (transactionState != null ? transactionState.toString() : "null") + ", OR: " + (string2 != null ? string2 : "null");
            string = string + "    " + string3 + "\n";
            this.removeTransaction(sIPTransaction);
            this.logWriter.logDebug("auditTransactions: leaked " + string3);
        }
        string = n > 0 ? string + "    Total: " + Integer.toString(n) + " leaked transactions detected and removed.\n" : null;
        return string;
    }

    public void setNon2XXAckPassedToListener(boolean bl) {
        this.non2XXAckPassedToListener = bl;
    }

    public boolean isNon2XXAckPassedToListener() {
        return this.non2XXAckPassedToListener;
    }

    public int getActiveClientTransactionCount() {
        return this.activeClientTransactionCount;
    }

    class PingTimer
    extends SIPStackTimerTask {
        ThreadAuditor.ThreadHandle threadHandle;

        public PingTimer(ThreadAuditor.ThreadHandle threadHandle) {
            this.threadHandle = threadHandle;
        }

        protected void runTask() {
            if (SIPTransactionStack.this.timer != null) {
                if (this.threadHandle == null) {
                    this.threadHandle = SIPTransactionStack.this.getThreadAuditor().addCurrentThread();
                }
                this.threadHandle.ping();
                SIPTransactionStack.this.timer.schedule((TimerTask)new PingTimer(this.threadHandle), this.threadHandle.getPingIntervalInMillisecs());
            }
        }
    }
}

