/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.SAXException;
import weblogic.xml.babel.baseparser.Attribute;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.baseparser.StartElement;
import weblogic.xml.babel.baseparser.ValidatingBaseParser;
import weblogic.xml.babel.dtd.AttributeDefinition;
import weblogic.xml.babel.dtd.AttributeListDeclaration;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.dtd.ElementDeclaration;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.dtd.ExternalID;
import weblogic.xml.babel.dtd.GeneralEntityDeclaration;
import weblogic.xml.babel.dtd.Name;
import weblogic.xml.babel.dtd.NotationDeclaration;
import weblogic.xml.babel.dtd.ParsedEntityDeclaration;
import weblogic.xml.babel.scanner.ScannerException;

public class DocumentTypeDefinition
extends Element {
    private ElementDeclaration elementDecl;
    private ParsedEntityDeclaration peDecl;
    private GeneralEntityDeclaration geDecl;
    private AttributeListDeclaration attListDecl;
    private NotationDeclaration notationDecl;
    private Name name;
    private Space space;
    private ExternalID externalID;
    private EntityTable parameterEntityTable;
    private EntityTable internalEntityTable;
    private EntityTable externalEntityTable;
    private Map elementDeclarations = new HashMap();

    public DocumentTypeDefinition() {
        this.elementDecl = new ElementDeclaration();
        this.attListDecl = new AttributeListDeclaration();
        this.notationDecl = new NotationDeclaration();
        this.peDecl = new ParsedEntityDeclaration();
        this.geDecl = new GeneralEntityDeclaration();
        this.name = new Name();
        this.space = new Space();
        this.externalID = new ExternalID();
        this.parameterEntityTable = new EntityTable();
        this.internalEntityTable = new EntityTable();
        this.externalEntityTable = new EntityTable();
    }

    public void init() {
        super.init();
    }

    public boolean isMarkupDeclStarter(int n) {
        switch (n) {
            case 38: 
            case 40: 
            case 52: 
            case 53: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    public Declaration parseMarkupDecl(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        Declaration declaration;
        switch (baseParser.getCurrentToken().tokenType) {
            case 38: {
                declaration = new ElementDeclaration();
                break;
            }
            case 40: {
                declaration = new AttributeListDeclaration();
                break;
            }
            case 55: {
                declaration = new NotationDeclaration();
                break;
            }
            case 53: {
                declaration = new ParsedEntityDeclaration();
                break;
            }
            case 52: {
                declaration = new GeneralEntityDeclaration();
                break;
            }
            default: {
                return null;
            }
        }
        declaration.parse(baseParser);
        this.space.parse(baseParser);
        return declaration;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        this.space.parse(baseParser);
        baseParser.accept(24);
        this.space.parse(baseParser);
        this.name.parse(baseParser);
        this.space.parse(baseParser);
        if (ExternalID.checkStarters(baseParser.getCurrentToken().tokenType)) {
            this.externalID.parse(baseParser);
            ValidatingBaseParser validatingBaseParser = new ValidatingBaseParser(baseParser);
            validatingBaseParser.setExternalDTD();
            try {
                validatingBaseParser.initDTD(baseParser.resolveEntity(this.externalID.getPubidLiteral(), this.externalID.getSystemLiteral()));
            }
            catch (SAXException sAXException) {
                throw new ParseException("Error resolving externalID " + this.externalID, baseParser.getLine(), baseParser.getCurrentToken());
            }
            this.parseDeclarations(validatingBaseParser);
        }
        this.parseDeclarations(baseParser);
        baseParser.accept(58);
    }

    public void parseDeclarations(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.space.parse(baseParser);
        while (this.isMarkupDeclStarter(baseParser.getCurrentToken().tokenType) || baseParser.getCurrentToken().tokenType == 7 || baseParser.getCurrentToken().tokenType == 19) {
            ElementDeclaration elementDeclaration;
            if (baseParser.getCurrentToken().tokenType == 7 || baseParser.getCurrentToken().tokenType == 19) {
                baseParser.accept();
                continue;
            }
            Declaration declaration = this.parseMarkupDecl(baseParser);
            if (declaration.isElementDecl()) {
                this.elementDeclarations.put(declaration.getRawName(), declaration);
                continue;
            }
            if (!declaration.isAttributeListDecl() || (elementDeclaration = (ElementDeclaration)this.elementDeclarations.get(declaration.getRawName())) != null) continue;
            elementDeclaration = new ElementDeclaration(declaration.getRawName());
            elementDeclaration.addAttributeList((AttributeListDeclaration)declaration);
            this.elementDeclarations.put(elementDeclaration.getRawName(), elementDeclaration);
        }
    }

    public void processAttributes(StartElement startElement) {
        this.addDefaultAttributes(startElement);
        this.setAttributeTypes(startElement);
    }

    public void setAttributeTypes(StartElement startElement) {
        ElementDeclaration elementDeclaration = (ElementDeclaration)this.elementDeclarations.get(startElement.getRawName());
        if (elementDeclaration == null) {
            return;
        }
        Iterator iterator = startElement.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            AttributeDefinition attributeDefinition = elementDeclaration.getAttributeDefinition(attribute.getRawName());
            if (attributeDefinition == null) continue;
            attribute.setType(attributeDefinition.getType());
            if (attributeDefinition.getType() == 11) continue;
            attribute.setValue(attribute.normalizeSpace(attribute.getValue()));
        }
    }

    public void addDefaultAttributes(StartElement startElement) {
        ElementDeclaration elementDeclaration = (ElementDeclaration)this.elementDeclarations.get(startElement.getRawName());
        if (elementDeclaration == null) {
            return;
        }
        if (!elementDeclaration.hasDefaultAttributeDeclarations()) {
            return;
        }
        Iterator iterator = startElement.getAttributes().iterator();
        if (iterator.hasNext()) {
            Object object;
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                object = (Attribute)iterator.next();
                hashSet.add(((Element)object).getRawName());
            }
            object = elementDeclaration.getDefaultAttributes().iterator();
            while (object.hasNext()) {
                AttributeDefinition attributeDefinition = (AttributeDefinition)object.next();
                if (hashSet.contains(attributeDefinition.getRawName())) continue;
                startElement.addAttribute(attributeDefinition.createDefaultAttribute());
            }
        } else {
            Iterator iterator2 = elementDeclaration.getDefaultAttributes().iterator();
            while (iterator2.hasNext()) {
                AttributeDefinition attributeDefinition = (AttributeDefinition)iterator2.next();
                startElement.addAttribute(attributeDefinition.createDefaultAttribute());
            }
        }
    }

    public EntityTable getParameterEntityTable() {
        return this.parameterEntityTable;
    }

    public EntityTable getInternalEntityTable() {
        return this.internalEntityTable;
    }

    public EntityTable getExternalEntityTable() {
        return this.externalEntityTable;
    }

    public void setTables(EntityTable entityTable, EntityTable entityTable2, EntityTable entityTable3) {
        this.parameterEntityTable = entityTable;
        this.internalEntityTable = entityTable3;
        this.externalEntityTable = entityTable2;
    }
}

