/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.reader.XmlChars;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.Token;

public class CharDataElement
extends Element {
    protected int length;
    protected List arrays = new ArrayList();
    private static final char[] blankArray = new char[0];

    CharDataElement() {
        this.init();
    }

    protected void init() {
        super.init();
        this.length = 0;
        this.arrays.clear();
    }

    final void addArray(char[] cArray) {
        this.arrays.add(cArray);
        this.length += cArray.length;
    }

    void addToTextArray(char c) {
        this.addArray(new char[c]);
    }

    void addToTextArray(String string) {
        this.addArray(string.toCharArray());
    }

    void addToTextArray(Token token) {
        if (token.length == 0) {
            return;
        }
        char[] cArray = new char[token.length];
        System.arraycopy(token.textArray, token.start, cArray, 0, token.length);
        this.addArray(cArray);
    }

    void addToTextArrayNonAlloc(Token token) {
        if (token.length == 0) {
            return;
        }
        this.addArray(token.textArray);
    }

    boolean isSpace(char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (!XmlChars.isSpace(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isSpace() {
        int n = 0;
        while (n < this.arrays.size()) {
            if (!this.isSpace((char[])this.arrays.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        this.setPosition(baseParser);
        while (baseParser.compare(19) || baseParser.compare(13) || baseParser.compare(14) || baseParser.compare(15) || baseParser.compare(10)) {
            if (baseParser.compare(10)) {
                baseParser.accept();
                while (baseParser.compare(11) || baseParser.compare(19)) {
                    this.addToTextArray(baseParser.currentToken);
                    baseParser.accept();
                }
                baseParser.accept(12);
                continue;
            }
            if (baseParser.compare(14)) {
                this.addToTextArray(baseParser.currentToken.text);
                baseParser.accept();
                continue;
            }
            if (baseParser.compare(15)) {
                this.addToTextArray(baseParser.currentToken.text);
                baseParser.accept();
                continue;
            }
            this.addToTextArray(baseParser.currentToken);
            baseParser.accept();
        }
        this.type = 5;
    }

    protected char[] allocateArray() {
        if (this.arrays.size() == 1) {
            return (char[])this.arrays.get(0);
        }
        char[] cArray = new char[this.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.arrays.size()) {
            char[] cArray2 = (char[])this.arrays.get(n2);
            if (cArray2.length > 0) {
                System.arraycopy(cArray2, 0, cArray, n, cArray2.length);
            }
            n += cArray2.length;
            ++n2;
        }
        return cArray;
    }

    public char[] getArray() {
        if (this.arrays.size() == 0) {
            return blankArray;
        }
        return this.allocateArray();
    }

    public String getContent() {
        int n = this.arrays.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return new String((char[])this.arrays.get(0));
        }
        StringBuffer stringBuffer = new StringBuffer(this.length);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((char[])this.arrays.get(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getContent();
    }
}

