/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.parsers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import weblogic.xml.babel.baseparser.CharDataElement;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.EndElement;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.ProcessingInstruction;
import weblogic.xml.babel.baseparser.SAXAdapter;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.baseparser.StartElement;
import weblogic.xml.babel.baseparser.ValidatingBaseParser;
import weblogic.xml.babel.helpers.Outputter;
import weblogic.xml.babel.helpers.SAXContentHandlerImpl;
import weblogic.xml.babel.helpers.SAXErrorHandlerImpl;
import weblogic.xml.babel.parsers.SAXDriver;
import weblogic.xml.babel.parsers.SAXFeatureManager;
import weblogic.xml.babel.reader.XmlReader;
import weblogic.xml.babel.scanner.ScannerException;

public class DTDAwareSAXDriver
extends ValidatingBaseParser
implements XMLReader {
    private static final boolean debug = false;
    SAXAdapter saxAdapter = new SAXAdapter();
    SAXElementFactory saxElementFactory = new SAXElementFactory();
    ContentHandler contentHandler;
    ErrorHandler errorHandler = new SAXErrorHandlerImpl();
    DTDHandler dtdHandler;
    EntityResolver entityResolver;
    SAXFeatureManager saxFeatureManager = new SAXFeatureManager();

    protected void putNamespaceURI(String string, String string2) throws SAXException {
        super.putNamespaceURI(string, string2);
        this.saxAdapter.startPrefixMapping(string, string2, this.contentHandler);
    }

    protected void removeNamespaceURI(Object[] objectArray) throws SAXException {
        super.removeNamespaceURI(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            this.saxAdapter.endPrefixMapping(((PrefixMapping)objectArray[n]).getPrefix(), this.contentHandler);
            ++n;
        }
    }

    public Locator getLocator() {
        return SAXElementFactory.createLocator(this);
    }

    public void saxParseSome() throws SAXParseException, SAXException {
        try {
            Element element = super.parseSome();
            this.contentHandler.setDocumentLocator(this.getLocator());
            switch (element.type) {
                case 0: {
                    this.saxAdapter.startElement((StartElement)element, this.contentHandler);
                    break;
                }
                case 3: {
                    this.saxAdapter.endElement((EndElement)element, this.contentHandler);
                    this.removeNamespaceURI(this.outOfScopeNameSpace);
                    break;
                }
                case 5: {
                    if (!this.inDocument()) break;
                    this.saxAdapter.characters((CharDataElement)element, this.contentHandler);
                    break;
                }
                case 4: {
                    if (element.getRawName().equalsIgnoreCase("xml")) break;
                    this.saxAdapter.processingInstruction((ProcessingInstruction)element, this.contentHandler);
                    break;
                }
                case 7: {
                    if (!this.inDocument()) break;
                    this.saxAdapter.characters((Space)element, this.contentHandler);
                }
            }
        }
        catch (ScannerException scannerException) {
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(scannerException, this.getLocator());
            this.errorHandler.fatalError(sAXParseException);
        }
        catch (ParseException parseException) {
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(parseException, this.getLocator());
            this.errorHandler.fatalError(sAXParseException);
        }
        catch (IOException iOException) {
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(iOException, this.getLocator());
            this.errorHandler.fatalError(sAXParseException);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return SAXFeatureManager.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeatureManager.setFeature(string, bl);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("Do not support property: " + string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("Do not support property: " + string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    void subinit(InputSource inputSource) throws IOException, SAXException {
        try {
            super.init(inputSource);
        }
        catch (ScannerException scannerException) {
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(scannerException, this.getLocator());
            this.errorHandler.fatalError(sAXParseException);
        }
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.subinit(inputSource);
        this.contentHandler.startDocument();
        while (this.hasNext()) {
            this.saxParseSome();
        }
        this.contentHandler.endDocument();
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    public static void timeTest(String string, int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                Reader reader = XmlReader.createReader(bufferedInputStream);
                InputSource inputSource = new InputSource(reader);
                SAXDriver sAXDriver = new SAXDriver();
                SAXErrorHandlerImpl sAXErrorHandlerImpl = new SAXErrorHandlerImpl();
                SAXContentHandlerImpl sAXContentHandlerImpl = new SAXContentHandlerImpl();
                sAXContentHandlerImpl.setQuiet();
                sAXDriver.setContentHandler(sAXContentHandlerImpl);
                sAXDriver.setErrorHandler(sAXErrorHandlerImpl);
                long l2 = System.currentTimeMillis();
                sAXDriver.parse(inputSource);
                long l3 = System.currentTimeMillis();
                l += l3 - l2;
            }
            catch (SAXParseException sAXParseException) {
                System.out.println("----- SAXParseException ----");
                System.out.println(sAXParseException);
                sAXParseException.printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("-----JAVA   ----");
                exception.printStackTrace();
            }
            ++n2;
        }
        System.out.println("Parser took:" + l + " milliseconds for " + n + " iterations " + (float)l / (float)n + " milliseconds per iteration");
        System.out.println("Parser:" + (double)l / 1000.0 + " [s] (" + (double)n / ((double)l / 1000.0) + " [iteration/s], " + (float)l / (float)n + " [ms/iteration])");
    }

    public static void outputTest(String string, String string2, String string3) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            Reader reader = XmlReader.createReader(bufferedInputStream);
            InputSource inputSource = new InputSource(reader);
            SAXDriver sAXDriver = new SAXDriver();
            SAXErrorHandlerImpl sAXErrorHandlerImpl = new SAXErrorHandlerImpl();
            Outputter outputter = new Outputter(false, string3);
            sAXDriver.setContentHandler(outputter);
            sAXDriver.setErrorHandler(sAXErrorHandlerImpl);
            sAXDriver.parse(inputSource);
            System.out.println(outputter.getDiagnostic(true));
            outputter.getOutputXML(string2);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("----- SAXParseException ----");
            System.out.println(sAXParseException);
            sAXParseException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("-----JAVA   ----");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length == 2) {
            bl = true;
        }
        if (stringArray.length == 3) {
            bl2 = true;
        }
        if (bl2) {
            DTDAwareSAXDriver.outputTest(stringArray[0], stringArray[1], stringArray[2]);
        } else if (bl) {
            DTDAwareSAXDriver.timeTest(stringArray[0], Integer.parseInt(stringArray[1]));
        } else {
            try {
                InputSource inputSource = SAXElementFactory.createInputSource(stringArray[0]);
                DTDAwareSAXDriver dTDAwareSAXDriver = new DTDAwareSAXDriver();
                dTDAwareSAXDriver.setFeature("http://xml.org/sax/features/validation", false);
                dTDAwareSAXDriver.setFeature("http://xml.org/sax/features/namespaces", true);
                System.out.println("------ Features --------");
                System.out.println("validation set to " + dTDAwareSAXDriver.getFeature("http://xml.org/sax/features/validation"));
                System.out.println("namespace set to " + dTDAwareSAXDriver.getFeature("http://xml.org/sax/features/namespaces"));
                SAXErrorHandlerImpl sAXErrorHandlerImpl = new SAXErrorHandlerImpl();
                SAXContentHandlerImpl sAXContentHandlerImpl = new SAXContentHandlerImpl();
                sAXContentHandlerImpl.setVerbose();
                dTDAwareSAXDriver.setContentHandler(sAXContentHandlerImpl);
                dTDAwareSAXDriver.setErrorHandler(sAXErrorHandlerImpl);
                dTDAwareSAXDriver.parse(inputSource);
            }
            catch (SAXParseException sAXParseException) {
                System.out.println("----- SAXParseException ----");
                System.out.println(sAXParseException);
                sAXParseException.printStackTrace();
            }
            catch (SAXException sAXException) {
                System.out.println("----- SAXException ----");
                System.out.println(sAXException);
                sAXException.printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("-----JAVA   ----");
                exception.printStackTrace();
            }
        }
    }
}

