/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.parsers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.CharDataElement;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.EndElement;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.ProcessingInstruction;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.baseparser.StartElement;
import weblogic.xml.babel.baseparser.StreamElementFactory;
import weblogic.xml.babel.parsers.StreamParserHandler;
import weblogic.xml.babel.reader.XmlReader;
import weblogic.xml.babel.scanner.ScannerException;
import weblogicx.xml.stream.XMLEvent;

public class StreamParser
extends BaseParser {
    StreamElementFactory streamElementFactory;
    SAXElementFactory saxElementFactory;
    StreamParserHandler streamParserHandler;

    public StreamParser(InputSource inputSource, StreamParserHandler streamParserHandler) throws IOException, SAXException {
        try {
            this.streamElementFactory = new StreamElementFactory(this);
            this.saxElementFactory = new SAXElementFactory();
            this.streamParserHandler = streamParserHandler;
            this.init(inputSource);
        }
        catch (ScannerException scannerException) {
            this.saxElementFactory = new SAXElementFactory();
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(scannerException, this.getLocator());
            throw sAXParseException;
        }
    }

    public StreamParser(InputStream inputStream, StreamParserHandler streamParserHandler) throws IOException, SAXException {
        try {
            this.streamElementFactory = new StreamElementFactory(this);
            this.saxElementFactory = new SAXElementFactory();
            this.streamParserHandler = streamParserHandler;
            this.init(XmlReader.createReader(inputStream));
        }
        catch (ScannerException scannerException) {
            this.saxElementFactory = new SAXElementFactory();
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(scannerException, this.getLocator());
            throw sAXParseException;
        }
    }

    public StreamParser(Reader reader, StreamParserHandler streamParserHandler) throws IOException, SAXException {
        try {
            this.streamElementFactory = new StreamElementFactory(this);
            this.saxElementFactory = new SAXElementFactory();
            this.streamParserHandler = streamParserHandler;
            this.init(reader);
        }
        catch (ScannerException scannerException) {
            this.saxElementFactory = new SAXElementFactory();
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(scannerException, this.getLocator());
            throw sAXParseException;
        }
    }

    protected void putNamespaceURI(String string, String string2) throws SAXException {
        super.putNamespaceURI(string, string2);
        this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createStartPrefixMappingEvent(string, string2));
    }

    protected void removeNamespaceURI(Object[] objectArray) throws SAXException {
        super.removeNamespaceURI(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            PrefixMapping prefixMapping = (PrefixMapping)objectArray[n];
            if (prefixMapping.getUri() == null) {
                this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createEndPrefixMappingEvent(prefixMapping.getPrefix()));
            } else {
                this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createChangePrefixMappingEvent(prefixMapping));
            }
            ++n;
        }
    }

    public Locator getLocator() {
        return SAXElementFactory.createLocator(this);
    }

    public void streamParseSome() throws SAXParseException, SAXException {
        try {
            Element element = super.parseSome();
            switch (element.type) {
                case 0: {
                    this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createStartElementEvent((StartElement)element));
                    break;
                }
                case 3: {
                    this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createEndElementEvent((EndElement)element));
                    this.removeNamespaceURI(this.outOfScopeNameSpace);
                    break;
                }
                case 5: {
                    this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createTextEvent((CharDataElement)element));
                    break;
                }
                case 4: {
                    this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createProcessingInstructionEvent((ProcessingInstruction)element));
                    break;
                }
                case 7: {
                    this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createTextEvent((Space)element));
                }
            }
        }
        catch (ScannerException scannerException) {
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(scannerException, this.getLocator());
            scannerException.printTokenStack();
            scannerException.printErrorLine();
            this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createFatalErrorEvent(sAXParseException));
            throw sAXParseException;
        }
        catch (ParseException parseException) {
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(parseException, this.getLocator());
            this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createFatalErrorEvent(sAXParseException));
            throw sAXParseException;
        }
        catch (IOException iOException) {
            SAXParseException sAXParseException = SAXElementFactory.createSAXParseException(iOException, this.getLocator());
            this.streamParserHandler.put((XMLEvent)this.streamElementFactory.createFatalErrorEvent(sAXParseException));
            throw sAXParseException;
        }
    }

    public static void main(String[] stringArray) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[0]));
            Reader reader = XmlReader.createReader(bufferedInputStream);
            StreamParser streamParser = new StreamParser(reader, new StreamParserHandler(){

                public boolean put(XMLEvent xMLEvent) {
                    System.out.println(xMLEvent);
                    return true;
                }
            });
            while (streamParser.hasNext()) {
                streamParser.streamParseSome();
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("----- SAXParseException ----");
            System.out.println(sAXParseException);
            sAXParseException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("-----JAVA   ----");
            exception.printStackTrace();
        }
    }
}

