/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.icbm.MessageAck;
import net.kano.joscar.snaccmd.icbm.MissedMessagesCmd;
import net.kano.joscar.snaccmd.icbm.OldIcbm;
import net.kano.joscar.snaccmd.icbm.ParamInfoCmd;
import net.kano.joscar.snaccmd.icbm.RecvImIcbm;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RecvTypingNotification;
import net.kano.joscar.snaccmd.icbm.RvResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientIcbmCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(4, 5), new CmdType(4, 7), new CmdType(4, 20), new CmdType(4, 10), new CmdType(4, 12), new CmdType(4, 11)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 4) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 5) {
            return new ParamInfoCmd(packet);
        }
        if (command == 7) {
            int channel = AbstractIcbm.getIcbmChannel(packet);
            if (channel == 1) {
                return new RecvImIcbm(packet);
            }
            if (channel == 2) {
                return new RecvRvIcbm(packet);
            }
            if (channel == 4) {
                return new OldIcbm(packet);
            }
            return null;
        }
        if (command == 20) {
            return new RecvTypingNotification(packet);
        }
        if (command == 10) {
            return new MissedMessagesCmd(packet);
        }
        if (command == 12) {
            return new MessageAck(packet);
        }
        if (command == 11) {
            return new RvResponse(packet);
        }
        return null;
    }
}

