/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.MediaRange;
import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Parameters;

public class ContentType
extends ParametersHeader
implements ContentTypeHeader {
    private static final long serialVersionUID = 8475682204373446610L;
    protected MediaRange mediaRange;

    public ContentType() {
        super("Content-Type");
    }

    public ContentType(String string, String string2) {
        this();
        this.setContentType(string, string2);
    }

    public int compareMediaRange(String string) {
        return (this.mediaRange.type + "/" + this.mediaRange.subtype).compareToIgnoreCase(string);
    }

    public String encodeBody() {
        if (this.hasParameters()) {
            return this.mediaRange.encode() + ";" + this.parameters.encode();
        }
        return this.mediaRange.encode();
    }

    public MediaRange getMediaRange() {
        return this.mediaRange;
    }

    public String getMediaType() {
        return this.mediaRange.type;
    }

    public String getMediaSubType() {
        return this.mediaRange.subtype;
    }

    public String getContentSubType() {
        return this.mediaRange == null ? null : this.mediaRange.getSubtype();
    }

    public String getContentType() {
        return this.mediaRange == null ? null : this.mediaRange.getType();
    }

    public String getCharset() {
        return this.getParameter("charset");
    }

    public void setMediaRange(MediaRange mediaRange) {
        this.mediaRange = mediaRange;
    }

    public void setContentType(String string, String string2) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(string);
        this.mediaRange.setSubtype(string2);
    }

    public void setContentType(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(string);
    }

    public void setContentSubType(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setSubtype(string);
    }

    public Object clone() {
        ContentType contentType = (ContentType)super.clone();
        if (this.mediaRange != null) {
            contentType.mediaRange = (MediaRange)this.mediaRange.clone();
        }
        return contentType;
    }

    public boolean equals(Object object) {
        if (object instanceof ContentTypeHeader) {
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)object;
            return this.getContentType().equalsIgnoreCase(contentTypeHeader.getContentType()) && this.getContentSubType().equalsIgnoreCase(contentTypeHeader.getContentSubType()) && this.equalParameters((Parameters)contentTypeHeader);
        }
        return false;
    }
}

