/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;

public class DefaultIoFuture
implements IoFuture {
    private final IoSession session;
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final List<IoFutureListener> listeners = new CopyOnWriteArrayList<IoFutureListener>();
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private volatile Object result;

    public DefaultIoFuture(IoSession session) {
        this.session = session;
    }

    public IoSession getSession() {
        return this.session;
    }

    public void join() {
        while (true) {
            try {
                this.completionLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public boolean join(long timeoutInMillis) {
        boolean ready;
        long startTime = timeoutInMillis <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = timeoutInMillis;
        do {
            ready = false;
            try {
                ready = this.completionLatch.await(waitTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!ready) continue;
            return true;
        } while ((waitTime = timeoutInMillis - (System.currentTimeMillis() - startTime)) > 0L);
        return ready;
    }

    public boolean isReady() {
        return this.ready.get();
    }

    protected void setValue(Object newValue) {
        if (this.ready.compareAndSet(false, true)) {
            this.result = newValue;
            this.completionLatch.countDown();
            this.notifyListeners();
        }
    }

    protected Object getValue() {
        return this.result;
    }

    public void addListener(IoFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add(listener);
        if (this.ready.get()) {
            listener.operationComplete(this);
        }
    }

    public void removeListener(IoFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IoFutureListener listener : this.listeners) {
            listener.operationComplete(this);
        }
    }
}

