/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import org.jitsi.sctp4j.Sctp;
import org.jitsi.sctp4j.SctpDataCallback;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.sctp4j.UdpLink;
import org.jitsi.util.Logger;

public class SampleServer {
    private static final Logger logger = Logger.getLogger(SampleServer.class);

    public static void main(String[] args) throws Exception {
        String localAddr = "127.0.0.1";
        int localPort = 48001;
        int localSctpPort = 5001;
        String remoteAddr = "127.0.0.1";
        int remotePort = 48002;
        Sctp.init();
        SctpSocket sock1 = Sctp.createSocket(localSctpPort);
        UdpLink link = new UdpLink(sock1, localAddr, localPort, remoteAddr, remotePort);
        sock1.setLink(link);
        sock1.listen();
        while (!sock1.accept()) {
            Thread.sleep(100L);
        }
        sock1.setDataCallback(new SctpDataCallback(){

            @Override
            public void onSctpPacket(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
                logger.info("Server got some data: " + data.length + " stream: " + sid + " payload protocol id: " + ppid);
            }
        });
        Thread.sleep(40000L);
        sock1.close();
        Sctp.finish();
    }
}

