/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.fmj.ejmf.toolkit.gui.controls.ProgressBar;

public class ProgressSlider
extends Canvas
implements ProgressBar {
    private static final int DEFAULT_THUMB_WIDTH = 6;
    private static final int DEFAULT_THUMB_HEIGHT = 12;
    private int sliderLen = this.max - this.min;
    private int value = this.sliderLen / 2;
    private int max = 100;
    private int min = 0;
    private Rectangle thumbRect;
    private boolean dragOn = false;
    private boolean isOperational = true;
    private EventListenerList listenerList = null;
    private Object[] listeners;

    public ProgressSlider() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                if (ProgressSlider.this.thumbRect.contains(point)) {
                    ProgressSlider.this.startDrag(point);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ProgressSlider.this.endDrag(mouseEvent.getPoint());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!ProgressSlider.this.dragOn) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                ProgressSlider.this.setValue(point.x);
                ProgressSlider.access$202(ProgressSlider.this, ProgressSlider.this.listenerList.getListenerList());
                for (int i = ProgressSlider.this.listeners.length - 2; i >= 0; i -= 2) {
                    if (ProgressSlider.this.listeners[i] != ChangeListener.class) continue;
                    ((ChangeListener)ProgressSlider.this.listeners[i + 1]).stateChanged(new ChangeEvent(ProgressSlider.this));
                }
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public Rectangle computeThumbRectangle() {
        return new Rectangle(new Point(this.value - 3, 0), new Dimension(6, 12));
    }

    void endDrag(Point point) {
        this.dragOn = false;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.sliderLen + 6 + 1, 12);
    }

    public Rectangle getThumbRect() {
        return this.thumbRect;
    }

    public int getValue() {
        return this.value;
    }

    public void paint(Graphics graphics) {
        this.thumbRect = this.computeThumbRectangle();
        int n = this.thumbRect.width;
        int n2 = this.thumbRect.height;
        int n3 = n / 2;
        int n4 = this.value + n3;
        Color color = graphics.getColor();
        graphics.drawLine(0, 5, this.sliderLen + n, 5);
        graphics.drawLine(0, 6, this.sliderLen + n, 6);
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(0, 7, this.sliderLen + n, 7);
        graphics.drawLine(this.sliderLen + n, 5, this.sliderLen + n, 7);
        this.thumbRect.setLocation(n4 - n3, 0);
        graphics.translate(n4 - n3, 0);
        this.paintThumb(graphics);
        graphics.setColor(color);
        graphics.translate(-(n4 - n3), 0);
    }

    public void paintThumb(Graphics graphics) {
        this.thumbRect = this.computeThumbRectangle();
        int n = this.thumbRect.height;
        int n2 = this.thumbRect.width;
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(0, 0, 0, n);
        graphics.setColor(this.getBackground());
        for (int i = 1; i < n2; ++i) {
            graphics.drawLine(i, 0, i, n);
        }
        graphics.setColor(UIManager.getColor("controlDkShadow"));
        graphics.drawLine(n2, 0, n2, n);
        graphics.drawLine(1, n - 1, n2, n - 1);
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(0, 0, n2 - 1, 0);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public void setValue(int n) {
        if (n < this.min) {
            n = this.min;
        }
        if (n > this.max) {
            n = this.max;
        }
        this.value = n;
        this.repaint();
    }

    void startDrag(Point point) {
        this.dragOn = true;
    }

    static /* synthetic */ Object[] access$202(ProgressSlider progressSlider, Object[] objectArray) {
        progressSlider.listeners = objectArray;
        return objectArray;
    }
}

