/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.credentialsstorage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.credentialsstorage.AESCrypto;
import net.java.sip.communicator.impl.credentialsstorage.CredentialsStorageActivator;
import net.java.sip.communicator.impl.credentialsstorage.Crypto;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.credentialsstorage.CryptoException;
import net.java.sip.communicator.service.credentialsstorage.MasterPasswordInputService;
import net.java.sip.communicator.util.Base64;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;

public class CredentialsStorageServiceImpl
implements CredentialsStorageService {
    private final Logger logger = Logger.getLogger(CredentialsStorageServiceImpl.class);
    public static final String ACCOUNT_ENCRYPTED_PASSWORD = "ENCRYPTED_PASSWORD";
    public static final String ACCOUNT_UNENCRYPTED_PASSWORD = "PASSWORD";
    private static final String MASTER_PROP = "net.java.sip.communicator.impl.credentialsstorage.MASTER";
    private static final String MASTER_PROP_VALUE = "true";
    private ConfigurationService configurationService;
    private Crypto crypto;

    void start(BundleContext bc) {
        this.configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bc, ConfigurationService.class);
        if (!this.isUsingMasterPassword()) {
            this.moveAllPasswordProperties();
        }
    }

    void stop() {
        this.crypto = null;
    }

    @Override
    public synchronized boolean storePassword(String accountPrefix, String password) {
        if (this.createCrypto()) {
            String encryptedPassword = null;
            try {
                if (password != null) {
                    encryptedPassword = this.crypto.encrypt(password);
                }
                this.setEncrypted(accountPrefix, encryptedPassword);
                return true;
            }
            catch (Exception ex) {
                this.logger.error((Object)"Encryption failed, password not saved", (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized String loadPassword(String accountPrefix) {
        String password = null;
        if (this.isStoredEncrypted(accountPrefix) && this.createCrypto()) {
            try {
                password = this.crypto.decrypt(this.getEncrypted(accountPrefix));
            }
            catch (Exception ex) {
                this.logger.error((Object)"Decryption with master password failed", (Throwable)ex);
            }
        }
        return password;
    }

    @Override
    public boolean removePassword(String accountPrefix) {
        this.setEncrypted(accountPrefix, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Password for '" + accountPrefix + "' removed"));
        }
        return true;
    }

    @Override
    public boolean isUsingMasterPassword() {
        return null != this.configurationService.getString(MASTER_PROP);
    }

    @Override
    public boolean verifyMasterPassword(String master) {
        AESCrypto localCrypto = new AESCrypto(master);
        try {
            String encryptedValue = this.getEncryptedMasterPropValue();
            boolean correct = MASTER_PROP_VALUE.equals(localCrypto.decrypt(encryptedValue));
            if (correct) {
                this.setMasterPassword(master);
            }
            return correct;
        }
        catch (CryptoException e) {
            if (e.getErrorCode() == 3) {
                this.logger.debug((Object)"Incorrect master pass", (Throwable)e);
                return false;
            }
            throw new RuntimeException("Decryption failed", e);
        }
    }

    @Override
    public boolean changeMasterPassword(String oldPassword, String newPassword) {
        List encryptedAccountProps = this.configurationService.getPropertyNamesBySuffix(ACCOUNT_ENCRYPTED_PASSWORD);
        HashMap<String, String> passwords = new HashMap<String, String>();
        try {
            this.setMasterPassword(oldPassword);
            for (String string : encryptedAccountProps) {
                String propValue = this.configurationService.getString(string);
                if (propValue == null) continue;
                String decrypted = this.crypto.decrypt(propValue);
                passwords.put(string, decrypted);
            }
            this.setMasterPassword(newPassword);
            for (Map.Entry entry : passwords.entrySet()) {
                String encrypted = this.crypto.encrypt((String)entry.getValue());
                this.configurationService.setProperty((String)entry.getKey(), (Object)encrypted);
            }
            this.writeVerificationValue(newPassword == null);
        }
        catch (CryptoException ce) {
            this.logger.debug((Object)ce);
            this.crypto = null;
            passwords = null;
            return false;
        }
        return true;
    }

    private void setMasterPassword(String master) {
        this.crypto = new AESCrypto(master);
    }

    private void moveAllPasswordProperties() {
        List unencryptedProperties = this.configurationService.getPropertyNamesBySuffix(ACCOUNT_UNENCRYPTED_PASSWORD);
        for (String prop : unencryptedProperties) {
            int idx = prop.lastIndexOf(46);
            if (idx == -1) continue;
            String prefix = prop.substring(0, idx);
            String encodedPassword = this.getUnencrypted(prefix);
            if (encodedPassword == null || encodedPassword.length() == 0 || this.isStoredEncrypted(prefix)) {
                this.setUnencrypted(prefix, null);
                continue;
            }
            if (this.movePasswordProperty(prefix, new String(Base64.decode((String)encodedPassword)))) continue;
            this.logger.warn((Object)("Failed to move password for prefix " + prefix));
        }
    }

    private boolean movePasswordProperty(String accountPrefix, String password) {
        if (this.createCrypto()) {
            try {
                this.setEncrypted(accountPrefix, this.crypto.encrypt(password));
                this.setUnencrypted(accountPrefix, null);
                return true;
            }
            catch (CryptoException cex) {
                this.logger.debug((Object)"Encryption failed", (Throwable)cex);
            }
        }
        return false;
    }

    private void writeVerificationValue(boolean remove) {
        if (remove) {
            this.configurationService.removeProperty(MASTER_PROP);
        } else {
            try {
                this.configurationService.setProperty(MASTER_PROP, (Object)this.crypto.encrypt(MASTER_PROP_VALUE));
            }
            catch (CryptoException cex) {
                this.logger.error((Object)"Failed to encrypt and write verification value", (Throwable)cex);
            }
        }
    }

    private synchronized boolean createCrypto() {
        if (this.crypto == null) {
            this.logger.debug((Object)"Crypto instance is null, creating.");
            if (this.isUsingMasterPassword()) {
                String master = this.showPasswordPrompt();
                if (master == null) {
                    this.crypto = null;
                } else {
                    this.setMasterPassword(master);
                }
                this.moveAllPasswordProperties();
            } else {
                this.logger.debug((Object)"Master password not set");
                this.setMasterPassword(null);
            }
        }
        return this.crypto != null;
    }

    private String showPasswordPrompt() {
        String master;
        boolean correct = true;
        MasterPasswordInputService masterPasswordInputService = CredentialsStorageActivator.getMasterPasswordInputService();
        if (masterPasswordInputService == null) {
            this.logger.error((Object)"Missing MasterPasswordInputService to show input dialog");
            return null;
        }
        do {
            if ((master = masterPasswordInputService.showInputDialog(correct)) != null) continue;
            return null;
        } while (!(correct = master.length() != 0 && this.verifyMasterPassword(master)));
        return master;
    }

    private String getEncryptedMasterPropValue() {
        return this.configurationService.getString(MASTER_PROP);
    }

    private String getEncrypted(String accountPrefix) {
        return this.configurationService.getString(accountPrefix + "." + ACCOUNT_ENCRYPTED_PASSWORD);
    }

    private void setEncrypted(String accountPrefix, String value) {
        this.configurationService.setProperty(accountPrefix + "." + ACCOUNT_ENCRYPTED_PASSWORD, (Object)value);
    }

    @Override
    public boolean isStoredEncrypted(String accountPrefix) {
        return this.configurationService.getString(accountPrefix + "." + ACCOUNT_ENCRYPTED_PASSWORD) != null;
    }

    private String getUnencrypted(String accountPrefix) {
        return this.configurationService.getString(accountPrefix + "." + ACCOUNT_UNENCRYPTED_PASSWORD);
    }

    private void setUnencrypted(String accountPrefix, String value) {
        this.configurationService.setProperty(accountPrefix + "." + ACCOUNT_UNENCRYPTED_PASSWORD, (Object)value);
    }
}

