/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.service.protocol.WhiteboardPoint;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectLine;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectLineJabberImpl
extends WhiteboardObjectJabberImpl
implements WhiteboardObjectLine {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectLineJabberImpl.class);
    private WhiteboardPoint whiteboardPointStart;
    private WhiteboardPoint whiteboardPointEnd;

    public WhiteboardObjectLineJabberImpl() {
        this.whiteboardPointStart = new WhiteboardPoint(0.0, 0.0);
        this.whiteboardPointEnd = new WhiteboardPoint(0.0, 0.0);
    }

    public WhiteboardObjectLineJabberImpl(String xml) {
        block7: {
            this.whiteboardPointStart = new WhiteboardPoint(0.0, 0.0);
            this.whiteboardPointEnd = new WhiteboardPoint(0.0, 0.0);
            try {
                DocumentBuilder builder = XMLUtils.newDocumentBuilderFactory().newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals("line")) {
                    String id = e.getAttribute("id");
                    double x1 = Double.parseDouble(e.getAttribute("x1"));
                    double y1 = Double.parseDouble(e.getAttribute("y1"));
                    double x2 = Double.parseDouble(e.getAttribute("x2"));
                    double y2 = Double.parseDouble(e.getAttribute("y2"));
                    String stroke = e.getAttribute("stroke");
                    String stroke_width = e.getAttribute("stroke-width");
                    this.setID(id);
                    this.setThickness(Integer.parseInt(stroke_width));
                    this.setColor(Color.decode(stroke).getRGB());
                    this.setWhiteboardPointStart(new WhiteboardPoint(x1, y1));
                    this.setWhiteboardPointEnd(new WhiteboardPoint(x2, y2));
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml), (Throwable)ex);
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Problem WhiteboardObject : " + xml), (Throwable)ex);
            }
        }
    }

    public WhiteboardPoint getWhiteboardPointStart() {
        return this.whiteboardPointStart;
    }

    public WhiteboardPoint getWhiteboardPointEnd() {
        return this.whiteboardPointEnd;
    }

    public void setWhiteboardPointStart(WhiteboardPoint whiteboardPointStart) {
        this.whiteboardPointStart = whiteboardPointStart;
    }

    public void setWhiteboardPointEnd(WhiteboardPoint whiteboardPointEnd) {
        this.whiteboardPointEnd = whiteboardPointEnd;
    }

    @Override
    public String toXML() {
        String s = "<line id=\"#i\" x1=\"#x1\" y1=\"#y1\" x2=\"#x2\" y2=\"#y2\" stroke=\"#s\" stroke-width=\"#w\"/> ";
        s = s.replaceAll("#i", this.getID());
        s = s.replaceAll("#s", this.colorToHex(this.getColor()));
        s = s.replaceAll("#w", "" + this.getThickness());
        WhiteboardPoint p1 = this.getWhiteboardPointStart();
        WhiteboardPoint p2 = this.getWhiteboardPointEnd();
        s = s.replaceAll("#x1", "" + p1.getX());
        s = s.replaceAll("#y1", "" + p1.getY());
        s = s.replaceAll("#x2", "" + p2.getX());
        s = s.replaceAll("#y2", "" + p2.getY());
        return s;
    }
}

