/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.NodeEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MultiMapResponse
implements DataSerializable {
    private Collection collection;
    private long nextRecordId = -1L;
    private long txVersion = -1L;

    public MultiMapResponse() {
    }

    public MultiMapResponse(Collection collection) {
        this.collection = collection;
    }

    public long getNextRecordId() {
        return this.nextRecordId;
    }

    public MultiMapResponse setNextRecordId(long recordId) {
        this.nextRecordId = recordId;
        return this;
    }

    public long getTxVersion() {
        return this.txVersion;
    }

    public MultiMapResponse setTxVersion(long txVersion) {
        this.txVersion = txVersion;
        return this;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Collection getObjectCollection(NodeEngine nodeEngine) {
        if (this.collection == null) {
            return Collections.emptyList();
        }
        ArrayList coll = new ArrayList(this.collection.size());
        for (Object obj : this.collection) {
            MultiMapRecord record = (MultiMapRecord)nodeEngine.toObject(obj);
            coll.add(nodeEngine.toObject(record.getObject()));
        }
        return coll;
    }

    public Collection<MultiMapRecord> getRecordCollection(NodeEngine nodeEngine) {
        if (this.collection == null) {
            return Collections.emptyList();
        }
        ArrayList<MultiMapRecord> coll = new ArrayList<MultiMapRecord>(this.collection.size());
        for (Object obj : this.collection) {
            MultiMapRecord record = (MultiMapRecord)nodeEngine.toObject(obj);
            coll.add(record);
        }
        return coll;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.nextRecordId);
        out.writeLong(this.txVersion);
        if (this.collection == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(this.collection.size());
        for (Object obj : this.collection) {
            out.writeObject(obj);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.nextRecordId = in.readLong();
        this.txVersion = in.readLong();
        int size = in.readInt();
        if (size == -1) {
            return;
        }
        this.collection = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.collection.add(in.readObject());
        }
    }
}

