/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.map.record.ObjectRecord;
import com.hazelcast.map.record.ObjectRecordWithStats;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;

public class ObjectRecordFactory
implements RecordFactory<Object> {
    private final SerializationService serializationService;
    private final boolean statisticsEnabled;

    public ObjectRecordFactory(MapConfig config, SerializationService serializationService) {
        this.serializationService = serializationService;
        this.statisticsEnabled = config.isStatisticsEnabled();
    }

    @Override
    public InMemoryFormat getStorageFormat() {
        return InMemoryFormat.OBJECT;
    }

    @Override
    public Record<Object> newRecord(Data key, Object value) {
        Object objectValue = this.serializationService.toObject(value);
        return this.statisticsEnabled ? new ObjectRecordWithStats(key, objectValue) : new ObjectRecord(key, objectValue);
    }

    @Override
    public void setValue(Record<Object> record, Object value) {
        Object v = value;
        if (value instanceof Data) {
            v = this.serializationService.toObject(value);
        }
        record.setValue(v);
    }

    @Override
    public boolean isEquals(Object value1, Object value2) {
        Object v2;
        Object v1 = value1 instanceof Data ? this.serializationService.toObject(value1) : value1;
        Object object = v2 = value2 instanceof Data ? this.serializationService.toObject(value2) : value2;
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }
}

