/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.MergeClustersOperation;
import com.hazelcast.cluster.PrepareMergeOperation;
import com.hazelcast.config.Config;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.util.Clock;
import com.hazelcast.util.FutureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public abstract class AbstractJoiner
implements Joiner {
    private final FutureUtil.ExceptionHandler whileWaitMergeExceptionHandler;
    private final AtomicLong joinStartTime = new AtomicLong(Clock.currentTimeMillis());
    private final AtomicInteger tryCount = new AtomicInteger(0);
    protected final Set<Address> blacklistedAddresses = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final Config config;
    protected final Node node;
    protected final ILogger logger;
    private volatile Address targetAddress;

    public AbstractJoiner(Node node) {
        this.node = node;
        this.logger = node.loggingService.getLogger(this.getClass());
        this.config = node.config;
        this.whileWaitMergeExceptionHandler = FutureUtil.logAllExceptions(this.logger, "While waiting merge response...", Level.FINEST);
    }

    @Override
    public void blacklist(Address callerAddress) {
        this.logger.info(callerAddress + " is added to the blacklist.");
        this.blacklistedAddresses.add(callerAddress);
    }

    @Override
    public boolean isBlacklisted(Address address) {
        return this.blacklistedAddresses.contains(address);
    }

    public abstract void doJoin();

    @Override
    public final void join() {
        this.blacklistedAddresses.clear();
        this.doJoin();
        this.postJoin();
    }

    private void postJoin() {
        this.blacklistedAddresses.clear();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("PostJoin master: " + this.node.getMasterAddress() + ", isMaster: " + this.node.isMaster());
        }
        if (!this.node.isActive()) {
            return;
        }
        if (this.tryCount.incrementAndGet() == 5) {
            this.logger.warning("Join try count exceed limit, setting this node as master!");
            this.node.setAsMaster();
        }
        if (this.node.joined()) {
            if (!this.node.isMaster()) {
                this.ensureConnectionToAllMembers();
            }
            if (this.node.getClusterService().getSize() == 1) {
                StringBuilder sb = new StringBuilder("\n");
                sb.append(this.node.clusterService.membersString());
                this.logger.info(sb.toString());
            }
        }
    }

    private void ensureConnectionToAllMembers() {
        boolean allConnected = false;
        if (this.node.joined()) {
            this.logger.finest("Waiting for all connections");
            int connectAllWaitSeconds = this.node.groupProperties.CONNECT_ALL_WAIT_SECONDS.getInteger();
            int checkCount = 0;
            while (checkCount++ < connectAllWaitSeconds && !allConnected) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                allConnected = true;
                Collection<MemberImpl> members = this.node.getClusterService().getMemberList();
                for (MemberImpl member : members) {
                    if (member.localMember() || this.node.connectionManager.getOrConnect(member.getAddress()) != null) continue;
                    allConnected = false;
                    if (!this.logger.isFinestEnabled()) continue;
                    this.logger.finest("Not-connected to " + member.getAddress());
                }
            }
        }
    }

    protected final long getMaxJoinMillis() {
        return (long)this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000L;
    }

    protected final long getMaxJoinTimeToMasterNode() {
        return (long)(this.node.getGroupProperties().MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger() + 10) * 1000L;
    }

    boolean shouldMerge(JoinMessage joinRequest) {
        boolean shouldMerge = false;
        if (joinRequest != null) {
            try {
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.getClusterService().validateJoinMessage(joinRequest);
                }
                catch (Exception e) {
                    this.logger.finest(e.getMessage());
                    validJoinRequest = false;
                }
                if (validJoinRequest) {
                    for (Member member : this.node.getClusterService().getMembers()) {
                        MemberImpl memberImpl = (MemberImpl)member;
                        if (!memberImpl.getAddress().equals(joinRequest.getAddress())) continue;
                        if (this.logger.isFinestEnabled()) {
                            this.logger.finest("Should not merge to " + joinRequest.getAddress() + ", because it is already member of this cluster.");
                        }
                        return false;
                    }
                    int currentMemberCount = this.node.getClusterService().getMembers().size();
                    if (joinRequest.getMemberCount() > currentMemberCount) {
                        this.logger.info(this.node.getThisAddress() + " is merging to " + joinRequest.getAddress() + ", because : joinRequest.getMemberCount() > currentMemberCount [" + joinRequest.getMemberCount() + " > " + currentMemberCount + "]");
                        if (this.logger.isFinestEnabled()) {
                            this.logger.finest(joinRequest.toString());
                        }
                        shouldMerge = true;
                    } else if (joinRequest.getMemberCount() == currentMemberCount) {
                        if (this.node.getThisAddress().hashCode() > joinRequest.getAddress().hashCode()) {
                            this.logger.info(this.node.getThisAddress() + " is merging to " + joinRequest.getAddress() + ", because : node.getThisAddress().hashCode() > joinRequest.address.hashCode() " + ", this node member count: " + currentMemberCount);
                            if (this.logger.isFinestEnabled()) {
                                this.logger.finest(joinRequest.toString());
                            }
                            shouldMerge = true;
                        } else if (this.logger.isFinestEnabled()) {
                            this.logger.finest(joinRequest.getAddress() + " should merge to this node " + ", because : node.getThisAddress().hashCode() < joinRequest.address.hashCode() " + ", this node member count: " + currentMemberCount);
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.logger.severe(e);
                return false;
            }
        }
        return shouldMerge;
    }

    @Override
    public void reset() {
        this.joinStartTime.set(Clock.currentTimeMillis());
        this.tryCount.set(0);
    }

    protected void startClusterMerge(Address targetAddress) {
        OperationService operationService = this.node.nodeEngine.getOperationService();
        Collection<MemberImpl> memberList = this.node.getClusterService().getMemberList();
        ArrayList<Future> calls = new ArrayList<Future>();
        for (MemberImpl member : memberList) {
            if (member.localMember()) continue;
            PrepareMergeOperation operation = new PrepareMergeOperation(targetAddress);
            InternalCompletableFuture f = operationService.createInvocationBuilder("hz:core:clusterService", (Operation)operation, member.getAddress()).setTryCount(3).invoke();
            calls.add(f);
        }
        FutureUtil.waitWithDeadline(calls, 3L, TimeUnit.SECONDS, this.whileWaitMergeExceptionHandler);
        PrepareMergeOperation prepareMergeOperation = new PrepareMergeOperation(targetAddress);
        prepareMergeOperation.setNodeEngine(this.node.nodeEngine).setService(this.node.getClusterService()).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
        operationService.runOperationOnCallingThread(prepareMergeOperation);
        for (MemberImpl member : memberList) {
            if (member.localMember()) continue;
            operationService.createInvocationBuilder("hz:core:clusterService", (Operation)new MergeClustersOperation(targetAddress), member.getAddress()).setTryCount(1).invoke();
        }
        MergeClustersOperation mergeClustersOperation = new MergeClustersOperation(targetAddress);
        mergeClustersOperation.setNodeEngine(this.node.nodeEngine).setService(this.node.getClusterService()).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
        operationService.runOperationOnCallingThread(mergeClustersOperation);
    }

    @Override
    public final long getStartTime() {
        return this.joinStartTime.get();
    }

    @Override
    public void setTargetAddress(Address targetAddress) {
        this.targetAddress = targetAddress;
    }

    public Address getTargetAddress() {
        Address target = this.targetAddress;
        this.targetAddress = null;
        return target;
    }
}

