/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.record;

import com.hazelcast.cache.impl.record.AbstractCacheRecord;
import com.hazelcast.cache.impl.record.CacheDataRecord;
import com.hazelcast.cache.impl.record.CacheObjectRecord;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;

public class CacheRecordFactory {
    private InMemoryFormat inMemoryFormat;
    private SerializationService serializationService;

    public CacheRecordFactory(InMemoryFormat inMemoryFormat, SerializationService serializationService) {
        this.inMemoryFormat = inMemoryFormat;
        this.serializationService = serializationService;
    }

    public CacheRecord newRecord(Data key, Object value) {
        return this.newRecordWithExpiry(key, value, -1L);
    }

    public CacheRecord newRecordWithExpiry(Data key, Object value, long expiryTime) {
        AbstractCacheRecord record;
        switch (this.inMemoryFormat) {
            case BINARY: {
                Data dataValue = this.serializationService.toData(value);
                record = new CacheDataRecord(key, dataValue, expiryTime);
                break;
            }
            case OBJECT: {
                Object objectValue = this.serializationService.toObject(value);
                record = new CacheObjectRecord(key, objectValue, expiryTime);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.inMemoryFormat));
            }
        }
        return record;
    }

    public static boolean isExpiredAt(long expirationTime, long now) {
        return expirationTime > -1L && expirationTime <= now;
    }
}

