/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.Response;
import java.io.IOException;

public class NormalResponse
extends Response {
    private Object value;
    private int backupCount;

    public NormalResponse() {
    }

    public NormalResponse(Object value, long callId, int backupCount, boolean urgent) {
        super(callId, urgent);
        this.value = value;
        this.backupCount = backupCount;
    }

    public Object getValue() {
        return this.value;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.backupCount);
        boolean isData = this.value instanceof Data;
        out.writeBoolean(isData);
        if (isData) {
            ((Data)this.value).writeData(out);
        } else {
            out.writeObject(this.value);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.backupCount = in.readInt();
        boolean isData = in.readBoolean();
        if (isData) {
            Data data = new Data();
            data.readData(in);
            this.value = data;
        } else {
            this.value = in.readObject();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NormalResponse");
        sb.append("{callId=").append(this.callId);
        sb.append(", urgent=").append(this.urgent);
        sb.append(", value=").append(this.value);
        sb.append(", backupCount=").append(this.backupCount);
        sb.append('}');
        return sb.toString();
    }
}

