/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

final class PromoteFromBackupOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    PromoteFromBackupOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        this.logPromotingPartition();
        try {
            PartitionMigrationEvent event = this.createPartitionMigrationEvent();
            this.sendToAllMigrationAwareServices(event);
        }
        finally {
            this.clearPartitionMigratingFlag();
        }
    }

    private void clearPartitionMigratingFlag() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        InternalPartitionImpl partition = service.getPartition(this.getPartitionId());
        partition.setMigrating(false);
    }

    private void sendToAllMigrationAwareServices(PartitionMigrationEvent event) {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        for (MigrationAwareService service : nodeEngine.getServices(MigrationAwareService.class)) {
            try {
                service.beforeMigration(event);
                service.commitMigration(event);
            }
            catch (Throwable e) {
                this.logMigrationError(e);
            }
        }
    }

    private PartitionMigrationEvent createPartitionMigrationEvent() {
        int partitionId = this.getPartitionId();
        return new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, partitionId);
    }

    private void logMigrationError(Throwable e) {
        ILogger logger = this.getLogger();
        logger.warning("While promoting partition " + this.getPartitionId(), e);
    }

    private void logPromotingPartition() {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Promoting partition " + this.getPartitionId());
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

