/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Map;

public class EntryBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    protected transient Object oldValue;
    private EntryBackupProcessor entryProcessor;

    public EntryBackupOperation() {
    }

    public EntryBackupOperation(String name, Data dataKey, EntryBackupProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() {
        if (this.entryProcessor instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)this.entryProcessor)).setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        }
    }

    @Override
    public void run() {
        long now = this.getNow();
        this.oldValue = this.getValueFor(this.dataKey, now);
        Object key = this.toObject(this.dataKey);
        Object value = this.toObject(this.oldValue);
        Map.Entry entry = this.createMapEntry(key, value);
        this.processBackup(entry);
        if (this.noOpBackup(entry)) {
            return;
        }
        if (this.entryRemovedBackup(entry)) {
            return;
        }
        this.entryAddedOrUpdatedBackup(entry);
    }

    @Override
    public void afterRun() throws Exception {
        this.evict(true);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryBackupProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "EntryBackupOperation{}";
    }

    private void processBackup(Map.Entry entry) {
        this.entryProcessor.processBackup(entry);
    }

    private boolean entryRemovedBackup(Map.Entry entry) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.removeBackup(this.dataKey);
            return true;
        }
        return false;
    }

    private boolean entryAddedOrUpdatedBackup(Map.Entry entry) {
        Object value = entry.getValue();
        if (value != null) {
            this.recordStore.putBackup(this.dataKey, value);
            return true;
        }
        return false;
    }

    private boolean noOpBackup(Map.Entry entry) {
        MapEntrySimple mapEntrySimple = (MapEntrySimple)entry;
        return !mapEntrySimple.isModified() || this.oldValue == null && entry.getValue() == null;
    }

    private Map.Entry createMapEntry(Object key, Object value) {
        return new MapEntrySimple<Object, Object>(key, value);
    }

    private Object getValueFor(Data dataKey, long now) {
        Map.Entry<Data, Object> mapEntry = this.recordStore.getMapEntry(dataKey, now);
        return mapEntry.getValue();
    }

    private Object toObject(Object data) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toObject(data);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }
}

