/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.AbstractRecordStore;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.NearCacheProvider;
import com.hazelcast.map.eviction.EvictionOperator;
import com.hazelcast.map.eviction.ExpirationTimeSetter;
import com.hazelcast.map.eviction.MaxSizeChecker;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class AbstractEvictableRecordStore
extends AbstractRecordStore {
    private static final int POST_READ_CHECK_POINT = 63;
    private volatile boolean expirable;
    private Iterator<Record> expirationIterator;
    private int readCountBeforeCleanUp;
    private long lruAccessSequenceNumber;
    private long lastEvictionTime;
    private final boolean evictionEnabled;
    private final long minEvictionCheckMillis;
    private final MapConfig.EvictionPolicy evictionPolicy;

    protected AbstractEvictableRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        MapConfig mapConfig = mapContainer.getMapConfig();
        this.minEvictionCheckMillis = mapConfig.getMinEvictionCheckMillis();
        this.evictionPolicy = mapContainer.getMapConfig().getEvictionPolicy();
        this.evictionEnabled = !MapConfig.EvictionPolicy.NONE.equals((Object)this.evictionPolicy);
        this.expirable = this.isRecordStoreExpirable();
    }

    private boolean isRecordStoreExpirable() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        return mapConfig.getMaxIdleSeconds() > 0 || mapConfig.getTimeToLiveSeconds() > 0;
    }

    @Override
    public void evictExpiredEntries(int percentage, boolean backup) {
        long now = this.getNow();
        int size = this.size();
        int maxIterationCount = this.getMaxIterationCount(size, percentage);
        int maxRetry = 3;
        int loop = 0;
        int evictedEntryCount = 0;
        while ((evictedEntryCount += this.evictExpiredEntriesInternal(maxIterationCount, now, backup)) < maxIterationCount && ++loop <= 3) {
        }
    }

    @Override
    public boolean isExpirable() {
        return this.expirable;
    }

    private int getMaxIterationCount(int size, int percentage) {
        int defaultMaxIterationCount = 100;
        float oneHundred = 100.0f;
        float maxIterationCount = (float)size * ((float)percentage / 100.0f);
        if (maxIterationCount <= 100.0f) {
            return 100;
        }
        return Math.round(maxIterationCount);
    }

    private int evictExpiredEntriesInternal(int maxIterationCount, long now, boolean backup) {
        int evictedCount = 0;
        int checkedEntryCount = 0;
        this.initExpirationIterator();
        while (this.expirationIterator.hasNext() && checkedEntryCount < maxIterationCount) {
            ++checkedEntryCount;
            Record record = this.expirationIterator.next();
            if ((record = this.getOrNullIfExpired(record, now, backup)) != null) continue;
            ++evictedCount;
        }
        return evictedCount;
    }

    private void initExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = this.records.values().iterator();
        }
    }

    protected void resetAccessSequenceNumber() {
        this.lruAccessSequenceNumber = 0L;
    }

    @Override
    public void evictEntries(long now, boolean backup) {
        if (this.evictionEnabled) {
            this.cleanUp(now, backup);
        }
    }

    protected void postReadCleanUp(long now, boolean backup) {
        if (this.evictionEnabled) {
            ++this.readCountBeforeCleanUp;
            if ((this.readCountBeforeCleanUp & 0x3F) == 0) {
                this.cleanUp(now, backup);
            }
        }
    }

    private void cleanUp(long now, boolean backup) {
        if (this.size() == 0) {
            return;
        }
        if (this.shouldEvict(now)) {
            this.removeEvictableRecords(backup);
            this.lastEvictionTime = now;
            this.readCountBeforeCleanUp = 0;
        }
    }

    protected boolean shouldEvict(long now) {
        return this.evictionEnabled && this.inEvictableTimeWindow(now) && this.isEvictable();
    }

    private void removeEvictableRecords(boolean backup) {
        int evictableSize = this.getEvictableSize();
        if (evictableSize < 1) {
            return;
        }
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        this.getEvictionOperator().removeEvictableRecords(this, evictableSize, mapConfig, backup);
    }

    private int getEvictableSize() {
        int size = this.size();
        if (size < 1) {
            return 0;
        }
        int evictableSize = this.getEvictionOperator().evictableSize(size, this.mapContainer.getMapConfig());
        if (evictableSize < 1) {
            return 0;
        }
        return evictableSize;
    }

    private EvictionOperator getEvictionOperator() {
        return this.mapServiceContext.getEvictionOperator();
    }

    private boolean inEvictableTimeWindow(long now) {
        return this.minEvictionCheckMillis == 0L || now - this.lastEvictionTime > this.minEvictionCheckMillis;
    }

    private boolean isEvictable() {
        EvictionOperator evictionOperator = this.getEvictionOperator();
        MaxSizeChecker maxSizeChecker = evictionOperator.getMaxSizeChecker();
        return maxSizeChecker.checkEvictable(this.mapContainer, this.partitionId);
    }

    protected void markRecordStoreExpirable(long ttl) {
        if (ttl > 0L) {
            this.expirable = true;
        }
    }

    abstract Object evictInternal(Data var1, boolean var2);

    protected Record getOrNullIfExpired(Record record, long now, boolean backup) {
        if (!this.expirable) {
            return record;
        }
        if (record == null) {
            return null;
        }
        Data key = record.getKey();
        if (this.isLocked(key)) {
            return record;
        }
        if (!this.isExpired(record, now, backup)) {
            return record;
        }
        Object value = record.getValue();
        this.evictInternal(key, backup);
        if (!backup) {
            this.doPostExpirationOperations(key, value);
        }
        return null;
    }

    public boolean isExpired(Record record, long time, boolean backup) {
        return record == null || this.isIdleExpired(record, time, backup) == null || this.isTTLExpired(record, time, backup) == null;
    }

    private Record isIdleExpired(Record record, long time, boolean backup) {
        if (record == null) {
            return null;
        }
        long lastAccessTime = record.getLastAccessTime();
        assert (lastAccessTime > 0L);
        assert (time > 0L);
        assert (time >= lastAccessTime);
        boolean result = time - lastAccessTime >= ExpirationTimeSetter.calculateExpirationWithDelay(this.mapContainer.getMaxIdleMillis(), backup);
        return result ? null : record;
    }

    private Record isTTLExpired(Record record, long time, boolean backup) {
        if (record == null) {
            return null;
        }
        long ttl = record.getTtl();
        if (ttl < 1L) {
            return record;
        }
        long lastUpdateTime = record.getLastUpdateTime();
        assert (ttl > 0L) : String.format("wrong ttl %d", ttl);
        assert (lastUpdateTime > 0L) : String.format("wrong lastUpdateTime %d", lastUpdateTime);
        assert (time > 0L) : String.format("wrong time %d", time);
        assert (time >= lastUpdateTime) : String.format("time >= lastUpdateTime (%d >= %d)", time, lastUpdateTime);
        boolean result = time - lastUpdateTime >= ExpirationTimeSetter.calculateExpirationWithDelay(ttl, backup);
        return result ? null : record;
    }

    private void doPostExpirationOperations(Data key, Object value) {
        String mapName = this.name;
        MapServiceContext mapServiceContext = this.mapServiceContext;
        NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
        if (nearCacheProvider.isNearCacheAndInvalidationEnabled(mapName)) {
            nearCacheProvider.invalidateAllNearCaches(mapName, key);
        }
        this.getEvictionOperator().fireEvent(key, value, mapName, mapServiceContext);
    }

    void increaseRecordEvictionCriteriaNumber(Record record, MapConfig.EvictionPolicy evictionPolicy) {
        switch (evictionPolicy) {
            case LRU: {
                ++this.lruAccessSequenceNumber;
                record.setEvictionCriteriaNumber(this.lruAccessSequenceNumber);
                break;
            }
            case LFU: {
                record.setEvictionCriteriaNumber(record.getEvictionCriteriaNumber() + 1L);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate eviction policy [" + (Object)((Object)evictionPolicy) + ']');
            }
        }
    }

    @Override
    protected void accessRecord(Record record, long now) {
        super.accessRecord(record, now);
        this.increaseRecordEvictionCriteriaNumber(record, this.evictionPolicy);
        long maxIdleMillis = this.mapContainer.getMaxIdleMillis();
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
    }

    protected final class ReadOnlyRecordIterator
    implements Iterator<Record> {
        private final long now;
        private final boolean checkExpiration;
        private final boolean backup;
        private final Iterator<Record> iterator;
        private Record nextRecord;
        private Record lastReturned;

        protected ReadOnlyRecordIterator(Collection<Record> values, long now, boolean backup) {
            this(values, now, true, backup);
        }

        protected ReadOnlyRecordIterator(Collection<Record> values) {
            this(values, -1L, false, false);
        }

        private ReadOnlyRecordIterator(Collection<Record> values, long now, boolean checkExpiration, boolean backup) {
            this.iterator = values.iterator();
            this.now = now;
            this.checkExpiration = checkExpiration;
            this.backup = backup;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Record next() {
            if (this.nextRecord == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextRecord;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported by this iterator");
        }

        private void advance() {
            long now = this.now;
            boolean checkExpiration = this.checkExpiration;
            Iterator<Record> iterator = this.iterator;
            while (iterator.hasNext()) {
                this.nextRecord = iterator.next();
                if (this.nextRecord == null) continue;
                if (!checkExpiration) {
                    return;
                }
                if (AbstractEvictableRecordStore.this.isExpired(this.nextRecord, now, this.backup)) continue;
                return;
            }
            this.nextRecord = null;
        }
    }
}

