/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.management.MonitoredThread;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ThreadMonitoringService {
    private static final int PERCENT_MULTIPLIER = 100;
    final ConcurrentMap<Long, ThreadCpuInfo> knownThreads = new ConcurrentHashMap<Long, ThreadCpuInfo>(100);
    final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final ThreadGroup threadGroup;

    public ThreadMonitoringService(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public Set<MonitoredThread> getStats() {
        try {
            TreeSet<MonitoredThread> monitoredThreads = new TreeSet<MonitoredThread>();
            int count = this.threadGroup.activeCount();
            Thread[] threads = new Thread[count];
            this.threadGroup.enumerate(threads);
            long now = System.nanoTime();
            for (Thread thread : threads) {
                ThreadCpuInfoConstructor constructor = new ThreadCpuInfoConstructor(thread);
                ThreadCpuInfo t = ConcurrencyUtil.getOrPutIfAbsent(this.knownThreads, thread.getId(), constructor);
                int percentage = (int)(t.setNewValue(this.threadMXBean.getThreadCpuTime(thread.getId()), now) * 100.0);
                monitoredThreads.add(new MonitoredThread(thread.getName(), thread.getId(), percentage));
            }
            return monitoredThreads;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThreadStats {\n");
        Set<MonitoredThread> stats = this.getStats();
        if (stats != null) {
            int total = 0;
            for (MonitoredThread monitoredThread : stats) {
                sb.append(monitoredThread.toString());
                sb.append("\n");
                total += monitoredThread.cpuPercentage;
            }
            sb.append("Total::: ").append(total).append('\n');
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class ThreadCpuInfoConstructor
    implements ConstructorFunction<Long, ThreadCpuInfo> {
        private Thread thread;

        private ThreadCpuInfoConstructor(Thread thread) {
            this.thread = thread;
        }

        @Override
        public ThreadCpuInfo createNew(Long notUsed) {
            return new ThreadCpuInfo(this.thread);
        }
    }

    static class ThreadCpuInfo {
        final Thread thread;
        long lastSet;
        long lastValue;

        ThreadCpuInfo(Thread thread) {
            this.thread = thread;
        }

        public double setNewValue(long newValue, long now) {
            double diff = newValue - this.lastValue;
            double timeDiff = now - this.lastSet;
            this.lastSet = now;
            this.lastValue = newValue;
            return diff / timeDiff;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreadCpuInfo that = (ThreadCpuInfo)o;
            return this.thread.getId() == that.thread.getId();
        }

        public int hashCode() {
            return this.thread.hashCode();
        }

        public String toString() {
            return "ThreadCpuInfo{name='" + this.thread.getName() + '\'' + ", threadId=" + this.thread.getId() + ", lastSet=" + this.lastSet + ", lastValue=" + this.lastValue + '}';
        }
    }
}

