/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject(value="limits exposure to abuse from request flooding, whether malicious, or as a result of a misconfigured client")
public class DoSFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(DoSFilter.class);
    private static final String IPv4_GROUP = "(\\d{1,3})";
    private static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final String IPv6_GROUP = "(\\p{XDigit}{1,4})";
    private static final Pattern IPv6_PATTERN = Pattern.compile("(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4})");
    private static final Pattern CIDR_PATTERN = Pattern.compile("([^/]+)/(\\d+)");
    private static final String __TRACKER = "DoSFilter.Tracker";
    private static final String __THROTTLED = "DoSFilter.Throttled";
    private static final int __DEFAULT_MAX_REQUESTS_PER_SEC = 25;
    private static final int __DEFAULT_DELAY_MS = 100;
    private static final int __DEFAULT_THROTTLE = 5;
    private static final int __DEFAULT_MAX_WAIT_MS = 50;
    private static final long __DEFAULT_THROTTLE_MS = 30000L;
    private static final long __DEFAULT_MAX_REQUEST_MS_INIT_PARAM = 30000L;
    private static final long __DEFAULT_MAX_IDLE_TRACKER_MS_INIT_PARAM = 30000L;
    static final String MANAGED_ATTR_INIT_PARAM = "managedAttr";
    static final String MAX_REQUESTS_PER_S_INIT_PARAM = "maxRequestsPerSec";
    static final String DELAY_MS_INIT_PARAM = "delayMs";
    static final String THROTTLED_REQUESTS_INIT_PARAM = "throttledRequests";
    static final String MAX_WAIT_INIT_PARAM = "maxWaitMs";
    static final String THROTTLE_MS_INIT_PARAM = "throttleMs";
    static final String MAX_REQUEST_MS_INIT_PARAM = "maxRequestMs";
    static final String MAX_IDLE_TRACKER_MS_INIT_PARAM = "maxIdleTrackerMs";
    static final String INSERT_HEADERS_INIT_PARAM = "insertHeaders";
    static final String TRACK_SESSIONS_INIT_PARAM = "trackSessions";
    static final String REMOTE_PORT_INIT_PARAM = "remotePort";
    static final String IP_WHITELIST_INIT_PARAM = "ipWhitelist";
    static final String ENABLED_INIT_PARAM = "enabled";
    private static final int USER_AUTH = 2;
    private static final int USER_SESSION = 2;
    private static final int USER_IP = 1;
    private static final int USER_UNKNOWN = 0;
    private ServletContext _context;
    private volatile long _delayMs;
    private volatile long _throttleMs;
    private volatile long _maxWaitMs;
    private volatile long _maxRequestMs;
    private volatile long _maxIdleTrackerMs;
    private volatile boolean _insertHeaders;
    private volatile boolean _trackSessions;
    private volatile boolean _remotePort;
    private volatile boolean _enabled;
    private Semaphore _passes;
    private volatile int _throttledRequests;
    private volatile int _maxRequestsPerSec;
    private Queue<Continuation>[] _queue;
    private ContinuationListener[] _listeners;
    private final ConcurrentHashMap<String, RateTracker> _rateTrackers = new ConcurrentHashMap();
    private final List<String> _whitelist = new CopyOnWriteArrayList<String>();
    private Scheduler _scheduler;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._context = filterConfig.getServletContext();
        this._queue = new Queue[this.getMaxPriority() + 1];
        this._listeners = new ContinuationListener[this.getMaxPriority() + 1];
        for (int p = 0; p < this._queue.length; ++p) {
            this._queue[p] = new ConcurrentLinkedQueue<Continuation>();
            final int priority = p;
            this._listeners[p] = new ContinuationListener(){

                public void onComplete(Continuation continuation) {
                }

                public void onTimeout(Continuation continuation) {
                    DoSFilter.this._queue[priority].remove(continuation);
                }
            };
        }
        this._rateTrackers.clear();
        int maxRequests = 25;
        String parameter = filterConfig.getInitParameter(MAX_REQUESTS_PER_S_INIT_PARAM);
        if (parameter != null) {
            maxRequests = Integer.parseInt(parameter);
        }
        this.setMaxRequestsPerSec(maxRequests);
        long delay = 100L;
        parameter = filterConfig.getInitParameter(DELAY_MS_INIT_PARAM);
        if (parameter != null) {
            delay = Long.parseLong(parameter);
        }
        this.setDelayMs(delay);
        int throttledRequests = 5;
        parameter = filterConfig.getInitParameter(THROTTLED_REQUESTS_INIT_PARAM);
        if (parameter != null) {
            throttledRequests = Integer.parseInt(parameter);
        }
        this.setThrottledRequests(throttledRequests);
        long maxWait = 50L;
        parameter = filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM);
        if (parameter != null) {
            maxWait = Long.parseLong(parameter);
        }
        this.setMaxWaitMs(maxWait);
        long throttle = 30000L;
        parameter = filterConfig.getInitParameter(THROTTLE_MS_INIT_PARAM);
        if (parameter != null) {
            throttle = Long.parseLong(parameter);
        }
        this.setThrottleMs(throttle);
        long maxRequestMs = 30000L;
        parameter = filterConfig.getInitParameter(MAX_REQUEST_MS_INIT_PARAM);
        if (parameter != null) {
            maxRequestMs = Long.parseLong(parameter);
        }
        this.setMaxRequestMs(maxRequestMs);
        long maxIdleTrackerMs = 30000L;
        parameter = filterConfig.getInitParameter(MAX_IDLE_TRACKER_MS_INIT_PARAM);
        if (parameter != null) {
            maxIdleTrackerMs = Long.parseLong(parameter);
        }
        this.setMaxIdleTrackerMs(maxIdleTrackerMs);
        String whiteList = "";
        parameter = filterConfig.getInitParameter(IP_WHITELIST_INIT_PARAM);
        if (parameter != null) {
            whiteList = parameter;
        }
        this.setWhitelist(whiteList);
        parameter = filterConfig.getInitParameter(INSERT_HEADERS_INIT_PARAM);
        this.setInsertHeaders(parameter == null || Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(TRACK_SESSIONS_INIT_PARAM);
        this.setTrackSessions(parameter == null || Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(REMOTE_PORT_INIT_PARAM);
        this.setRemotePort(parameter != null && Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(ENABLED_INIT_PARAM);
        this.setEnabled(parameter == null || Boolean.parseBoolean(parameter));
        this._scheduler = this.startScheduler();
        if (this._context != null && Boolean.parseBoolean(filterConfig.getInitParameter(MANAGED_ATTR_INIT_PARAM))) {
            this._context.setAttribute(filterConfig.getFilterName(), (Object)this);
        }
    }

    protected Scheduler startScheduler() throws ServletException {
        try {
            ScheduledExecutorScheduler result = new ScheduledExecutorScheduler();
            result.start();
            return result;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isEnabled()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RateTracker tracker = (RateTracker)request.getAttribute(__TRACKER);
        if (tracker == null) {
            tracker = this.getRateTracker((ServletRequest)request);
            boolean overRateLimit = tracker.isRateExceeded(System.currentTimeMillis());
            if (!overRateLimit) {
                this.doFilterChain(filterChain, request, response);
                return;
            }
            long delayMs = this.getDelayMs();
            boolean insertHeaders = this.isInsertHeaders();
            switch ((int)delayMs) {
                case -1: {
                    LOG.warn("DOS ALERT: Request rejected ip=" + request.getRemoteAddr() + ",session=" + request.getRequestedSessionId() + ",user=" + request.getUserPrincipal(), new Object[0]);
                    if (insertHeaders) {
                        response.addHeader("DoSFilter", "unavailable");
                    }
                    response.sendError(503);
                    return;
                }
                case 0: {
                    LOG.warn("DOS ALERT: Request throttled ip=" + request.getRemoteAddr() + ",session=" + request.getRequestedSessionId() + ",user=" + request.getUserPrincipal(), new Object[0]);
                    request.setAttribute(__TRACKER, (Object)tracker);
                    break;
                }
                default: {
                    LOG.warn("DOS ALERT: Request delayed=" + delayMs + "ms ip=" + request.getRemoteAddr() + ",session=" + request.getRequestedSessionId() + ",user=" + request.getUserPrincipal(), new Object[0]);
                    if (insertHeaders) {
                        response.addHeader("DoSFilter", "delayed");
                    }
                    Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                    request.setAttribute(__TRACKER, (Object)tracker);
                    if (delayMs > 0L) {
                        continuation.setTimeout(delayMs);
                    }
                    continuation.suspend();
                    return;
                }
            }
        }
        boolean accepted = false;
        try {
            accepted = this._passes.tryAcquire(this.getMaxWaitMs(), TimeUnit.MILLISECONDS);
            if (!accepted) {
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                Boolean throttled = (Boolean)request.getAttribute(__THROTTLED);
                long throttleMs = this.getThrottleMs();
                if (throttled != Boolean.TRUE && throttleMs > 0L) {
                    int priority = this.getPriority(request, tracker);
                    request.setAttribute(__THROTTLED, (Object)Boolean.TRUE);
                    if (this.isInsertHeaders()) {
                        response.addHeader("DoSFilter", "throttled");
                    }
                    if (throttleMs > 0L) {
                        continuation.setTimeout(throttleMs);
                    }
                    continuation.suspend();
                    continuation.addContinuationListener(this._listeners[priority]);
                    this._queue[priority].add(continuation);
                    return;
                }
                if (request.getAttribute("javax.servlet.resumed") == Boolean.TRUE) {
                    this._passes.acquire();
                    accepted = true;
                }
            }
            if (accepted) {
                this.doFilterChain(filterChain, request, response);
            } else {
                if (this.isInsertHeaders()) {
                    response.addHeader("DoSFilter", "unavailable");
                }
                response.sendError(503);
            }
        }
        catch (InterruptedException e) {
            this._context.log("DoS", (Throwable)e);
            response.sendError(503);
        }
        finally {
            if (accepted) {
                int p = this._queue.length;
                while (p-- > 0) {
                    Continuation continuation = this._queue[p].poll();
                    if (continuation == null || !continuation.isSuspended()) continue;
                    continuation.resume();
                    break;
                }
                this._passes.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterChain(FilterChain chain, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        final Thread thread = Thread.currentThread();
        Runnable requestTimeout = new Runnable(){

            @Override
            public void run() {
                DoSFilter.this.closeConnection(request, response, thread);
            }
        };
        Scheduler.Task task = this._scheduler.schedule(requestTimeout, this.getMaxRequestMs(), TimeUnit.MILLISECONDS);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            task.cancel();
        }
    }

    protected void closeConnection(HttpServletRequest request, HttpServletResponse response, Thread thread) {
        if (!response.isCommitted()) {
            response.setHeader("Connection", "close");
        }
        try {
            try {
                response.getWriter().close();
            }
            catch (IllegalStateException e) {
                response.getOutputStream().close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        thread.interrupt();
    }

    protected int getPriority(HttpServletRequest request, RateTracker tracker) {
        if (this.extractUserId((ServletRequest)request) != null) {
            return 2;
        }
        if (tracker != null) {
            return tracker.getType();
        }
        return 0;
    }

    protected int getMaxPriority() {
        return 2;
    }

    public RateTracker getRateTracker(ServletRequest request) {
        int type;
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        String loadId = this.extractUserId(request);
        if (loadId != null) {
            type = 2;
        } else if (this.isTrackSessions() && session != null && !session.isNew()) {
            loadId = session.getId();
            type = 2;
        } else {
            loadId = this.isRemotePort() ? request.getRemoteAddr() + request.getRemotePort() : request.getRemoteAddr();
            type = 1;
        }
        RateTracker tracker = this._rateTrackers.get(loadId);
        if (tracker == null) {
            boolean allowed = this.checkWhitelist(this._whitelist, request.getRemoteAddr());
            int maxRequestsPerSec = this.getMaxRequestsPerSec();
            tracker = allowed ? new FixedRateTracker(loadId, type, maxRequestsPerSec) : new RateTracker(loadId, type, maxRequestsPerSec);
            RateTracker existing = this._rateTrackers.putIfAbsent(loadId, tracker);
            if (existing != null) {
                tracker = existing;
            }
            if (type == 1) {
                this._scheduler.schedule((Runnable)tracker, this.getMaxIdleTrackerMs(), TimeUnit.MILLISECONDS);
            } else if (session != null) {
                session.setAttribute(__TRACKER, (Object)tracker);
            }
        }
        return tracker;
    }

    protected boolean checkWhitelist(List<String> whitelist, String candidate) {
        for (String address : whitelist) {
            if (!(address.contains("/") ? this.subnetMatch(address, candidate) : address.equals(candidate))) continue;
            return true;
        }
        return false;
    }

    protected boolean subnetMatch(String subnetAddress, String address) {
        int prefix;
        Matcher cidrMatcher = CIDR_PATTERN.matcher(subnetAddress);
        if (!cidrMatcher.matches()) {
            return false;
        }
        String subnet = cidrMatcher.group(1);
        try {
            prefix = Integer.parseInt(cidrMatcher.group(2));
        }
        catch (NumberFormatException x) {
            LOG.info("Ignoring malformed CIDR address {}", new Object[]{subnetAddress});
            return false;
        }
        byte[] subnetBytes = this.addressToBytes(subnet);
        if (subnetBytes == null) {
            LOG.info("Ignoring malformed CIDR address {}", new Object[]{subnetAddress});
            return false;
        }
        byte[] addressBytes = this.addressToBytes(address);
        if (addressBytes == null) {
            LOG.info("Ignoring malformed remote address {}", new Object[]{address});
            return false;
        }
        int length = subnetBytes.length;
        if (length != addressBytes.length) {
            return false;
        }
        byte[] mask = this.prefixToBytes(prefix, length);
        for (int i = 0; i < length; ++i) {
            if ((subnetBytes[i] & mask[i]) == (addressBytes[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    private byte[] addressToBytes(String address) {
        Matcher ipv4Matcher = IPv4_PATTERN.matcher(address);
        if (ipv4Matcher.matches()) {
            byte[] result = new byte[4];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.valueOf(ipv4Matcher.group(i + 1)).byteValue();
            }
            return result;
        }
        Matcher ipv6Matcher = IPv6_PATTERN.matcher(address);
        if (ipv6Matcher.matches()) {
            byte[] result = new byte[16];
            for (int i = 0; i < result.length; i += 2) {
                int word = Integer.valueOf(ipv6Matcher.group(i / 2 + 1), 16);
                result[i] = (byte)((word & 0xFF00) >>> 8);
                result[i + 1] = (byte)(word & 0xFF);
            }
            return result;
        }
        return null;
    }

    private byte[] prefixToBytes(int prefix, int length) {
        byte[] result = new byte[length];
        int index = 0;
        while (prefix / 8 > 0) {
            result[index] = -1;
            prefix -= 8;
            ++index;
        }
        result[index] = (byte)(~((1 << 8 - prefix) - 1));
        return result;
    }

    public void destroy() {
        LOG.debug("Destroy {}", new Object[]{this});
        this.stopScheduler();
        this._rateTrackers.clear();
        this._whitelist.clear();
    }

    protected void stopScheduler() {
        try {
            this._scheduler.stop();
        }
        catch (Exception x) {
            LOG.ignore((Throwable)x);
        }
    }

    protected String extractUserId(ServletRequest request) {
        return null;
    }

    @ManagedAttribute(value="maximum number of requests allowed from a connection per second")
    public int getMaxRequestsPerSec() {
        return this._maxRequestsPerSec;
    }

    public void setMaxRequestsPerSec(int value) {
        this._maxRequestsPerSec = value;
    }

    @ManagedAttribute(value="delay applied to all requests over the rate limit (in ms)")
    public long getDelayMs() {
        return this._delayMs;
    }

    public void setDelayMs(long value) {
        this._delayMs = value;
    }

    @ManagedAttribute(value="maximum time the filter will block waiting throttled connections, (0 for no delay, -1 to reject requests)")
    public long getMaxWaitMs() {
        return this._maxWaitMs;
    }

    public void setMaxWaitMs(long value) {
        this._maxWaitMs = value;
    }

    @ManagedAttribute(value="number of requests over rate limit")
    public int getThrottledRequests() {
        return this._throttledRequests;
    }

    public void setThrottledRequests(int value) {
        int permits = this._passes == null ? 0 : this._passes.availablePermits();
        this._passes = new Semaphore(value - this._throttledRequests + permits, true);
        this._throttledRequests = value;
    }

    @ManagedAttribute(value="amount of time to async wait for semaphore")
    public long getThrottleMs() {
        return this._throttleMs;
    }

    public void setThrottleMs(long value) {
        this._throttleMs = value;
    }

    @ManagedAttribute(value="maximum time to allow requests to process (in ms)")
    public long getMaxRequestMs() {
        return this._maxRequestMs;
    }

    public void setMaxRequestMs(long value) {
        this._maxRequestMs = value;
    }

    @ManagedAttribute(value="maximum time to track of request rates for connection before discarding")
    public long getMaxIdleTrackerMs() {
        return this._maxIdleTrackerMs;
    }

    public void setMaxIdleTrackerMs(long value) {
        this._maxIdleTrackerMs = value;
    }

    @ManagedAttribute(value="inser DoSFilter headers in response")
    public boolean isInsertHeaders() {
        return this._insertHeaders;
    }

    public void setInsertHeaders(boolean value) {
        this._insertHeaders = value;
    }

    @ManagedAttribute(value="usage rate is tracked by session if one exists")
    public boolean isTrackSessions() {
        return this._trackSessions;
    }

    public void setTrackSessions(boolean value) {
        this._trackSessions = value;
    }

    @ManagedAttribute(value="usage rate is tracked by IP+port is session tracking not used")
    public boolean isRemotePort() {
        return this._remotePort;
    }

    public void setRemotePort(boolean value) {
        this._remotePort = value;
    }

    @ManagedAttribute(value="whether this filter is enabled")
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @ManagedAttribute(value="list of IPs that will not be rate limited")
    public String getWhitelist() {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = this._whitelist.iterator();
        while (iterator.hasNext()) {
            String address = iterator.next();
            result.append(address);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    public void setWhitelist(String value) {
        ArrayList<String> result = new ArrayList<String>();
        for (String address : value.split(",")) {
            this.addWhitelistAddress(result, address);
        }
        this.clearWhitelist();
        this._whitelist.addAll(result);
        LOG.debug("Whitelisted IP addresses: {}", new Object[]{result});
    }

    @ManagedOperation(value="clears the list of IP addresses that will not be rate limited")
    public void clearWhitelist() {
        this._whitelist.clear();
    }

    @ManagedOperation(value="adds an IP address that will not be rate limited")
    public boolean addWhitelistAddress(@Name(value="address") String address) {
        return this.addWhitelistAddress(this._whitelist, address);
    }

    private boolean addWhitelistAddress(List<String> list, String address) {
        return (address = address.trim()).length() > 0 && list.add(address);
    }

    @ManagedOperation(value="removes an IP address that will not be rate limited")
    public boolean removeWhitelistAddress(@Name(value="address") String address) {
        return this._whitelist.remove(address);
    }

    class FixedRateTracker
    extends RateTracker {
        public FixedRateTracker(String id, int type, int numRecentRequestsTracked) {
            super(id, type, numRecentRequestsTracked);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRateExceeded(long now) {
            FixedRateTracker fixedRateTracker = this;
            synchronized (fixedRateTracker) {
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            return false;
        }

        @Override
        public String toString() {
            return "Fixed" + super.toString();
        }
    }

    class RateTracker
    implements Runnable,
    HttpSessionBindingListener,
    HttpSessionActivationListener,
    Serializable {
        private static final long serialVersionUID = 3534663738034577872L;
        protected final transient String _id;
        protected final transient int _type;
        protected final transient long[] _timestamps;
        protected transient int _next;

        public RateTracker(String id, int type, int maxRequestsPerSecond) {
            this._id = id;
            this._type = type;
            this._timestamps = new long[maxRequestsPerSecond];
            this._next = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRateExceeded(long now) {
            long last;
            RateTracker rateTracker = this;
            synchronized (rateTracker) {
                last = this._timestamps[this._next];
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            return last != 0L && now - last < 1000L;
        }

        public String getId() {
            return this._id;
        }

        public int getType() {
            return this._type;
        }

        public void valueBound(HttpSessionBindingEvent event) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Value bound: {}", new Object[]{this.getId()});
            }
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            DoSFilter.this._rateTrackers.remove(this._id);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tracker removed: {}", new Object[]{this.getId()});
            }
        }

        public void sessionWillPassivate(HttpSessionEvent se) {
            DoSFilter.this._rateTrackers.remove(this._id);
            se.getSession().removeAttribute(DoSFilter.__TRACKER);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Value removed: {}", new Object[]{this.getId()});
            }
        }

        public void sessionDidActivate(HttpSessionEvent se) {
            LOG.warn("Unexpected session activation", new Object[0]);
        }

        @Override
        public void run() {
            boolean hasRecentRequest;
            int latestIndex = this._next == 0 ? this._timestamps.length - 1 : this._next - 1;
            long last = this._timestamps[latestIndex];
            boolean bl = hasRecentRequest = last != 0L && System.currentTimeMillis() - last < 1000L;
            if (hasRecentRequest) {
                DoSFilter.this._scheduler.schedule((Runnable)this, DoSFilter.this.getMaxIdleTrackerMs(), TimeUnit.MILLISECONDS);
            } else {
                DoSFilter.this._rateTrackers.remove(this._id);
            }
        }

        public String toString() {
            return "RateTracker/" + this._id + "/" + this._type;
        }
    }
}

