/*
 * Decompiled with CFR 0.152.
 */
package javax.media.mscontrol.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.spi.Driver;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverManager {
    private static boolean initialized = false;
    private static HashMap<String, Driver> internalDrivers = new HashMap();
    private static Map<String, Driver> drivers = Collections.synchronizedMap(internalDrivers);

    private DriverManager() {
    }

    public static void registerDriver(Driver driver) {
        if (!initialized) {
            DriverManager.initialize();
        }
        drivers.put(driver.getName(), driver);
    }

    public static void deregisterDriver(Driver driver) {
        drivers.remove(driver.getName());
    }

    public static MsControlFactory getFactory(String driverName, Properties info) throws MsControlException {
        Driver driver = DriverManager.getDriver(driverName);
        if (driver != null) {
            return driver.getFactory(info);
        }
        throw new MsControlException("Driver " + driverName + " not registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<Driver> getDrivers() {
        if (!initialized) {
            DriverManager.initialize();
        }
        HashMap clone = null;
        Map<String, Driver> map = drivers;
        synchronized (map) {
            clone = (HashMap)internalDrivers.clone();
        }
        return new NonRemoveIterator(clone.values().iterator());
    }

    public static Driver getDriver(String driverName) {
        if (!initialized) {
            DriverManager.initialize();
        }
        return drivers.get(driverName);
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        DriverManager.loadDrivers();
    }

    private static synchronized void loadDrivers() {
        Iterator iter = Service.providers(Driver.class);
        while (iter.hasNext()) {
            Driver driver = (Driver)iter.next();
            drivers.put(driver.getName(), driver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonRemoveIterator
    implements Iterator<Driver> {
        private Iterator<Driver> iter;

        private NonRemoveIterator(Iterator<Driver> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Driver next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove() is not supported");
        }
    }
}

