/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.StandardScreenConfig;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.util.ColorUtil;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import javax.swing.JPanel;

public class WelcomeScreen
extends InstallerScreen {
    public WelcomeScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string = MessageFormat.format(this.messages.getString("WelcomeLabel2") + this.getExtraMessage(), this.getApplicationName());
        String string2 = this.messages.getString("ClickNext");
        this.addDisplayTextArea(string + "\n\n" + string2, jPanel, gridBagConstraints);
    }

    protected boolean isBannerPainted() {
        return true;
    }

    protected String getBannerIconFileName() {
        return "welcome.png";
    }

    protected Color getBannerBackground() {
        StandardScreenConfig standardScreenConfig = InstallerConfig.getCurrentInstance().getScreenForId("welcome");
        return ColorUtil.parseColor(standardScreenConfig.getBannerBackground());
    }

    protected String getTitle() {
        return MessageFormat.format(this.messages.getString("WelcomeLabel1"), this.getApplicationName());
    }

    protected String getSubTitle() {
        return "";
    }

    protected void setupControls() {
        super.setupControls();
        this.btnPrevious.setVisible(false);
    }

    private String getExtraMessage() {
        String string = InstallerConfig.getCurrentInstance().getStatus();
        if (string == null || !string.equals("LCOK")) {
            return "\n\nThis installer was created with an evaluation version of install4j";
        }
        return "";
    }
}

