/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    private static boolean ignoreMissingEndBoundary = true;
    private static boolean ignoreMissingBoundaryParameter = true;
    private static boolean bmparse = true;
    protected DataSource ds = null;
    protected boolean parsed = true;
    private boolean complete = true;
    private String preamble = null;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String string) {
        String string2 = UniqueValue.getUniqueBoundaryValue();
        ContentType contentType = new ContentType("multipart", string, null);
        contentType.setParameter("boundary", string2);
        this.contentType = contentType.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        if (dataSource instanceof MessageAware) {
            MessageContext messageContext = ((MessageAware)dataSource).getMessageContext();
            this.setParent(messageContext.getPart());
        }
        if (dataSource instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)dataSource);
            return;
        }
        this.parsed = false;
        this.ds = dataSource;
        this.contentType = dataSource.getContentType();
    }

    public synchronized void setSubType(String string) throws MessagingException {
        ContentType contentType = new ContentType(this.contentType);
        contentType.setSubType(string);
        this.contentType = contentType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int n) throws MessagingException {
        this.parse();
        return super.getBodyPart(n);
    }

    public synchronized BodyPart getBodyPart(String string) throws MessagingException {
        this.parse();
        int n = this.getCount();
        int n2 = 0;
        while (n2 < n) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)this.getBodyPart(n2);
            String string2 = mimeBodyPart.getContentID();
            if (string2 != null && string2.equals(string)) {
                return mimeBodyPart;
            }
            ++n2;
        }
        return null;
    }

    public boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public void setPreamble(String string) throws MessagingException {
        this.preamble = string;
    }

    protected void updateHeaders() throws MessagingException {
        int n = 0;
        while (n < this.parts.size()) {
            ((MimeBodyPart)this.parts.elementAt(n)).updateHeaders();
            ++n;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.parse();
        String string = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        if (this.preamble != null) {
            byte[] byArray = ASCIIUtility.getBytes(this.preamble);
            lineOutputStream.write(byArray);
            if (byArray.length > 0 && byArray[byArray.length - 1] != 13 && byArray[byArray.length - 1] != 10) {
                lineOutputStream.writeln();
            }
        }
        int n = 0;
        while (n < this.parts.size()) {
            lineOutputStream.writeln(string);
            ((MimeBodyPart)this.parts.elementAt(n)).writeTo(outputStream);
            lineOutputStream.writeln();
            ++n;
        }
        lineOutputStream.writeln(string + "--");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        if (bmparse) {
            this.parsebm();
            return;
        }
        InputStream inputStream = null;
        SharedInputStream sharedInputStream = null;
        long l = 0L;
        long l2 = 0L;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        ContentType contentType = new ContentType(this.contentType);
        String string = null;
        String string2 = contentType.getParameter("boundary");
        if (string2 != null) {
            string = "--" + string2;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            try {
                int n;
                String string3;
                LineInputStream lineInputStream = new LineInputStream(inputStream);
                String string4 = null;
                while ((string3 = lineInputStream.readLine()) != null) {
                    int n2 = string3.length() - 1;
                    while (n2 >= 0 && ((n = (int)string3.charAt(n2)) == 32 || n == 9)) {
                        --n2;
                    }
                    string3 = string3.substring(0, n2 + 1);
                    if (string != null) {
                        if (string3.equals(string)) {
                            break;
                        }
                    } else if (string3.startsWith("--")) {
                        string = string3;
                        break;
                    }
                    if (string3.length() <= 0) continue;
                    if (string4 == null) {
                        try {
                            string4 = System.getProperty("line.separator", "\n");
                        }
                        catch (SecurityException securityException) {
                            string4 = "\n";
                        }
                    }
                    if (this.preamble == null) {
                        this.preamble = string3 + string4;
                        continue;
                    }
                    this.preamble = this.preamble + string3 + string4;
                }
                if (string3 == null) {
                    throw new MessagingException("Missing start boundary");
                }
                byte[] byArray = ASCIIUtility.getBytes(string);
                n = byArray.length;
                boolean bl = false;
                while (!bl) {
                    InternetHeaders internetHeaders = null;
                    if (sharedInputStream != null) {
                        l = sharedInputStream.getPosition();
                        while ((string3 = lineInputStream.readLine()) != null && string3.length() > 0) {
                        }
                        if (string3 == null) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            break;
                        }
                    } else {
                        internetHeaders = this.createInternetHeaders(inputStream);
                    }
                    if (!inputStream.markSupported()) {
                        throw new MessagingException("Stream doesn't support mark");
                    }
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    if (sharedInputStream == null) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                    } else {
                        l2 = sharedInputStream.getPosition();
                    }
                    boolean bl2 = true;
                    int n3 = -1;
                    int n4 = -1;
                    block15: while (true) {
                        int n5;
                        if (bl2) {
                            inputStream.mark(n + 4 + 1000);
                            int n6 = 0;
                            while (n6 < n && inputStream.read() == (byArray[n6] & 0xFF)) {
                                ++n6;
                            }
                            if (n6 == n) {
                                int n7 = inputStream.read();
                                if (n7 == 45 && inputStream.read() == 45) {
                                    this.complete = true;
                                    bl = true;
                                    break;
                                }
                                while (true) {
                                    if (n7 != 32 && n7 != 9) {
                                        if (n7 != 10) break;
                                        break block15;
                                    }
                                    n7 = inputStream.read();
                                }
                                if (n7 == 13) {
                                    inputStream.mark(1);
                                    if (inputStream.read() == 10) break;
                                    inputStream.reset();
                                    break;
                                }
                            }
                            inputStream.reset();
                            if (byteArrayOutputStream != null && n3 != -1) {
                                byteArrayOutputStream.write(n3);
                                if (n4 != -1) {
                                    byteArrayOutputStream.write(n4);
                                }
                                n4 = -1;
                                n3 = -1;
                            }
                        }
                        if ((n5 = inputStream.read()) < 0) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            bl = true;
                            break;
                        }
                        if (n5 == 13 || n5 == 10) {
                            bl2 = true;
                            if (sharedInputStream != null) {
                                l2 = sharedInputStream.getPosition() - 1L;
                            }
                            n3 = n5;
                            if (n5 != 13) continue;
                            inputStream.mark(1);
                            n5 = inputStream.read();
                            if (n5 == 10) {
                                n4 = n5;
                                continue;
                            }
                            inputStream.reset();
                            continue;
                        }
                        bl2 = false;
                        if (byteArrayOutputStream == null) continue;
                        byteArrayOutputStream.write(n5);
                    }
                    MimeBodyPart mimeBodyPart = sharedInputStream != null ? this.createMimeBodyPart(sharedInputStream.newStream(l, l2)) : this.createMimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                    this.addBodyPart(mimeBodyPart);
                }
            }
            catch (IOException iOException) {
                throw new MessagingException("IO Error", iOException);
            }
            Object var25_27 = null;
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        this.parsed = true;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void parsebm() throws MessagingException {
        block62: {
            if (this.parsed) {
                return;
            }
            var1_1 = null;
            var2_2 = null;
            var3_3 = 0L;
            var5_4 = 0L;
            try {
                var1_1 = this.ds.getInputStream();
                if (!(var1_1 instanceof ByteArrayInputStream || var1_1 instanceof BufferedInputStream || var1_1 instanceof SharedInputStream)) {
                    var1_1 = new BufferedInputStream(var1_1);
                }
            }
            catch (Exception var7_5) {
                throw new MessagingException("No inputstream from datasource");
            }
            if (var1_1 instanceof SharedInputStream) {
                var2_2 = (SharedInputStream)var1_1;
            }
            var7_6 = new ContentType(this.contentType);
            var8_7 = null;
            var9_8 = var7_6.getParameter("boundary");
            if (var9_8 != null) {
                var8_7 = "--" + var9_8;
            } else if (!MimeMultipart.ignoreMissingBoundaryParameter) {
                throw new MessagingException("Missing boundary parameter");
            }
            var10_9 = new LineInputStream(var1_1);
            var12_11 = null;
            while ((var11_12 = var10_9.readLine()) != null) {
                var13_13 = var11_12.length() - 1;
                while (var13_13 >= 0) {
                    var14_15 = var11_12.charAt(var13_13);
                    if (var14_15 != 32 && var14_15 != 9) break;
                    --var13_13;
                }
                var11_12 = var11_12.substring(0, var13_13 + 1);
                if (var8_7 != null) {
                    if (var11_12.equals(var8_7)) {
                        break;
                    }
                } else if (var11_12.startsWith("--")) {
                    var8_7 = var11_12;
                    break;
                }
                if (var11_12.length() <= 0) continue;
                if (var12_11 == null) {
                    try {
                        var12_11 = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException var14_16) {
                        var12_11 = "\n";
                    }
                }
                this.preamble = this.preamble == null ? var11_12 + var12_11 : this.preamble + var11_12 + var12_11;
            }
            if (var11_12 == null) {
                throw new MessagingException("Missing start boundary");
            }
            var13_14 = ASCIIUtility.getBytes(var8_7);
            var14_15 = var13_14.length;
            var15_17 = new int[256];
            var16_18 = 0;
            while (var16_18 < var14_15) {
                var15_17[var13_14[var16_18]] = var16_18 + 1;
                ++var16_18;
            }
            var17_19 = new int[var14_15];
            var18_20 = var14_15;
            while (var18_20 > 0) {
                block59: {
                    var19_21 = var14_15 - 1;
                    while (var19_21 >= var18_20) {
                        if (var13_14[var19_21] == var13_14[var19_21 - var18_20]) {
                            var17_19[var19_21 - 1] = var18_20;
                            --var19_21;
                            continue;
                        }
                        break block59;
                    }
                    while (var19_21 > 0) {
                        var17_19[--var19_21] = var18_20;
                    }
                }
                --var18_20;
            }
            var17_19[var14_15 - 1] = 1;
            var19_21 = 0;
            while (var19_21 == 0) {
                var20_22 = null;
                if (var2_2 != null) {
                    var3_3 = var2_2.getPosition();
                    while ((var11_12 = var10_9.readLine()) != null && var11_12.length() > 0) {
                    }
                    if (var11_12 == null) {
                        if (!MimeMultipart.ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        break;
                    }
                } else {
                    var20_22 = this.createInternetHeaders(var1_1);
                }
                if (!var1_1.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                var21_23 = null;
                if (var2_2 == null) {
                    var21_23 = new ByteArrayOutputStream();
                } else {
                    var5_4 = var2_2.getPosition();
                }
                var23_25 = new byte[var14_15];
                var24_26 = new byte[var14_15];
                var25_27 = 0;
                var26_28 = 0;
                var28_30 = true;
                while (true) {
                    block60: {
                        block61: {
                            var1_1.mark(var14_15 + 4 + 1000);
                            var27_29 = 0;
                            var25_27 = var1_1.read(var23_25, 0, var14_15);
                            if (var25_27 < var14_15) {
                                if (!MimeMultipart.ignoreMissingEndBoundary) {
                                    throw new MessagingException("missing multipart end boundary");
                                }
                                if (var2_2 != null) {
                                    var5_4 = var2_2.getPosition();
                                }
                                this.complete = false;
                                var19_21 = 1;
                                break;
                            }
                            var29_32 = var14_15 - 1;
                            while (var29_32 >= 0) {
                                if (var23_25[var29_32] != var13_14[var29_32]) break;
                                --var29_32;
                            }
                            if (var29_32 >= 0) break block60;
                            var27_29 = 0;
                            if (!(var28_30 || (var22_24 = var24_26[var26_28 - 1]) != 13 && var22_24 != 10)) {
                                var27_29 = 1;
                                if (var22_24 == 10 && var26_28 >= 2 && (var22_24 = var24_26[var26_28 - 2]) == 13) {
                                    var27_29 = 2;
                                }
                            }
                            if (!var28_30 && var27_29 <= 0) break block61;
                            if (var2_2 != null) {
                                var5_4 = var2_2.getPosition() - (long)var14_15 - (long)var27_29;
                            }
                            if ((var30_33 = var1_1.read()) != 45 || var1_1.read() != 45) ** GOTO lbl136
                            this.complete = true;
                            var19_21 = 1;
                            break;
lbl-1000:
                            // 1 sources

                            {
                                var30_33 = var1_1.read();
lbl136:
                                // 2 sources

                                ** while (var30_33 == 32 || var30_33 == 9)
                            }
lbl137:
                            // 1 sources

                            if (var30_33 == 10) break;
                            if (var30_33 == 13) {
                                var1_1.mark(1);
                                if (var1_1.read() == 10) break;
                                var1_1.reset();
                                break;
                            }
                        }
                        var29_32 = 0;
                    }
                    if ((var30_33 = Math.max(var29_32 + 1 - var15_17[var23_25[var29_32] & 127], var17_19[var29_32])) < 2) {
                        if (var2_2 == null && var26_28 > 1) {
                            var21_23.write(var24_26, 0, var26_28 - 1);
                        }
                        var1_1.reset();
                        var1_1.skip(1L);
                        if (var26_28 >= 1) {
                            var24_26[0] = var24_26[var26_28 - 1];
                            var24_26[1] = var23_25[0];
                            var26_28 = 2;
                        } else {
                            var24_26[0] = var23_25[0];
                            var26_28 = 1;
                        }
                    } else {
                        if (var26_28 > 0 && var2_2 == null) {
                            var21_23.write(var24_26, 0, var26_28);
                        }
                        var26_28 = var30_33;
                        var1_1.reset();
                        var1_1.skip(var26_28);
                        var31_34 = var23_25;
                        var23_25 = var24_26;
                        var24_26 = var31_34;
                    }
                    var28_30 = false;
                }
                if (var2_2 != null) {
                    var29_31 = this.createMimeBodyPart(var2_2.newStream(var3_3, var5_4));
                } else {
                    if (var26_28 - var27_29 > 0) {
                        var21_23.write(var24_26, 0, var26_28 - var27_29);
                    }
                    if (!this.complete && var25_27 > 0) {
                        var21_23.write(var23_25, 0, var25_27);
                    }
                    var29_31 = this.createMimeBodyPart(var20_22, var21_23.toByteArray());
                }
                this.addBodyPart(var29_31);
            }
            var33_35 = null;
            try {
                var1_1.close();
            }
            catch (IOException var34_37) {}
            break block62;
            {
                catch (IOException var10_10) {
                    throw new MessagingException("IO Error", var10_10);
                }
            }
            catch (Throwable var32_39) {
                var33_36 = null;
                try {
                    var1_1.close();
                }
                catch (IOException var34_38) {
                    // empty catch block
                }
                throw var32_39;
            }
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        return new MimeBodyPart(internetHeaders, byArray);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream inputStream) throws MessagingException {
        return new MimeBodyPart(inputStream);
    }

    static {
        try {
            String string = System.getProperty("mail.mime.multipart.ignoremissingendboundary");
            ignoreMissingEndBoundary = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.multipart.ignoremissingboundaryparameter");
            ignoreMissingBoundaryParameter = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.multipart.bmparse");
            bmparse = string == null || !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

