/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.ReadOnlyIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousQueueIterator<E>
extends ReadOnlyIterator<E> {
    private final Loggerf log;
    private Future<?> producerFuture;
    private BlockingQueue<E> queue;
    private Iterator<E> bufferIterator;
    private int maxBufferSize;
    private List<E> buffer;
    private long sleepMS = 10L;
    private E next;
    private int objectsFetched;

    public AsynchronousQueueIterator(Loggerf log, BlockingQueue<E> queue, Future<?> producerFuture, long sleepMS, int maxBufferSize) {
        this.log = log;
        this.queue = queue;
        this.producerFuture = producerFuture;
        this.sleepMS = sleepMS;
        this.maxBufferSize = maxBufferSize;
        this.buffer = new LinkedList();
    }

    public AsynchronousQueueIterator(BlockingQueue<E> queue, Future<?> producerFuture) {
        this(Loggerf.getLogger(AsynchronousQueueIterator.class), queue, producerFuture, 10L, Integer.MAX_VALUE);
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.fetchNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        if (this.next == null && !this.fetchNext()) {
            throw new IllegalStateException("Next element not available");
        }
        try {
            E e = this.next;
            return e;
        }
        finally {
            this.next = null;
        }
    }

    private boolean fetchNext() {
        if (this.bufferIterator != null && this.bufferIterator.hasNext()) {
            this.next = this.bufferIterator.next();
            this.bufferIterator.remove();
            this.incrementFetchCount();
            return true;
        }
        this.waitForProducer();
        this.checkProducer();
        this.queue.drainTo(this.buffer, this.maxBufferSize);
        if (this.buffer.size() > 0) {
            this.bufferIterator = this.buffer.iterator();
            return this.fetchNext();
        }
        return false;
    }

    private void incrementFetchCount() {
        if (++this.objectsFetched % 10000 == 0) {
            this.log.debug("%,d objects fetched", this.objectsFetched);
        }
    }

    private void waitForProducer() {
        while (this.queue.isEmpty() && !this.producerFuture.isDone()) {
            try {
                Thread.sleep(this.sleepMS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread interrupted", e);
            }
        }
    }

    private void checkProducer() {
        if (this.producerFuture.isDone()) {
            try {
                this.producerFuture.get();
            }
            catch (Exception e) {
                throw new IllegalStateException("Producer threw an exception", e);
            }
        }
    }
}

