/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.rooms;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.rooms.RoomCommand;

public class ExchangeInfoReq
extends RoomCommand {
    private final int exchange;

    protected ExchangeInfoReq(SnacPacket snacPacket) {
        super(3);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.exchange = BinaryTools.getUShort(byteBlock, 0);
    }

    public ExchangeInfoReq(int n) {
        super(3);
        DefensiveTools.checkRange(n, "exchange", 0);
        this.exchange = n;
    }

    public final int getExchange() {
        return this.exchange;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.exchange != -1) {
            BinaryTools.writeUShort(outputStream, this.exchange);
        }
    }

    public String toString() {
        return "ExchangeInfoReq for exchange #" + this.exchange;
    }
}

