/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rv;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.rv.NewRvSessionEvent;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rv.RvCommandFactory;
import net.kano.joscar.rv.RvProcessorListener;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rv.RvSessionListener;
import net.kano.joscar.rv.RvSnacResponseEvent;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.VetoableSnacPacketListener;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.snaccmd.icbm.RvResponse;
import net.kano.joscar.snaccmd.icbm.SendRvIcbm;

public class RvProcessor {
    public static final Object ERRTYPE_RV_CMD_GEN = "ERRTYPE_RV_CMD_GEN";
    public static final Object ERRTYPE_RV_LISTENER = "ERRTYPE_RV_LISTENER";
    public static final Object ERRTYPE_RV_SESSION_LISTENER = "ERRTYPE_RV_SESSION_LISTENER";
    private static final Logger logger = Logger.getLogger("net.kano.joscar.rv");
    private ClientSnacProcessor snacProcessor = null;
    private final Object sessionLock = new Object();
    private SeqNum sessionId = new SeqNum(Long.MIN_VALUE, Long.MAX_VALUE, new Random().nextLong());
    private Map sessions = new HashMap();
    private CopyOnWriteArrayList rvListeners = new CopyOnWriteArrayList();
    private Map rvFactories = new HashMap();
    private VetoableSnacPacketListener packetListener = new VetoableSnacPacketListener(){

        public Object handlePacket(SnacPacketEvent snacPacketEvent) {
            SnacCommand snacCommand = snacPacketEvent.getSnacCommand();
            if (snacCommand instanceof RecvRvIcbm) {
                logger.finer("RvProcessor got RecvRvIcbm: " + snacCommand);
                RvProcessor.this.processRv(snacPacketEvent);
                return STOP_PROCESSING_LISTENERS;
            }
            if (snacCommand instanceof RvResponse) {
                logger.finer("RvProcessor got RvResponse: " + snacCommand);
                RvProcessor.this.processResponse(snacPacketEvent);
                return STOP_PROCESSING_LISTENERS;
            }
            return CONTINUE_PROCESSING;
        }
    };

    public RvProcessor() {
    }

    public RvProcessor(ClientSnacProcessor clientSnacProcessor) {
        this.attachToSnacProcessor(clientSnacProcessor);
    }

    public final synchronized ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    public final synchronized void attachToSnacProcessor(ClientSnacProcessor clientSnacProcessor) {
        DefensiveTools.checkNull(clientSnacProcessor, "snacProcessor");
        this.detach();
        this.snacProcessor = clientSnacProcessor;
        clientSnacProcessor.addVetoablePacketListener(this.packetListener);
    }

    public final synchronized void detach() {
        if (this.snacProcessor != null) {
            this.snacProcessor.removeVetoablePacketListener(this.packetListener);
            this.snacProcessor = null;
        }
    }

    public final void addListener(RvProcessorListener rvProcessorListener) {
        DefensiveTools.checkNull(rvProcessorListener, "l");
        this.rvListeners.addIfAbsent(rvProcessorListener);
    }

    public final void removeListener(RvProcessorListener rvProcessorListener) {
        DefensiveTools.checkNull(rvProcessorListener, "l");
        this.rvListeners.remove(rvProcessorListener);
    }

    public final synchronized void registerRvCmdFactory(RvCommandFactory rvCommandFactory) {
        DefensiveTools.checkNull(rvCommandFactory, "factory");
        CapabilityBlock[] capabilityBlockArray = rvCommandFactory.getSupportedCapabilities();
        if (capabilityBlockArray == null) {
            this.registerRvCmdFactory(null, rvCommandFactory);
        } else {
            for (int i = 0; i < capabilityBlockArray.length; ++i) {
                this.registerRvCmdFactory(capabilityBlockArray[i], rvCommandFactory);
            }
        }
    }

    public final synchronized void registerRvCmdFactory(CapabilityBlock capabilityBlock, RvCommandFactory rvCommandFactory) {
        DefensiveTools.checkNull(rvCommandFactory, "factory");
        this.rvFactories.put(capabilityBlock, rvCommandFactory);
    }

    public final synchronized RvCommandFactory getRegisteredRvCmdFactory(CapabilityBlock capabilityBlock) {
        return (RvCommandFactory)this.rvFactories.get(capabilityBlock);
    }

    public final synchronized void unregisterRvCmdFactory(RvCommandFactory rvCommandFactory) {
        DefensiveTools.checkNull(rvCommandFactory, "factory");
        this.rvFactories.values().remove(rvCommandFactory);
    }

    public final synchronized void unregisterRvCmdFactory(CapabilityBlock capabilityBlock, RvCommandFactory rvCommandFactory) {
        DefensiveTools.checkNull(rvCommandFactory, "factory");
        if (this.rvFactories.get(capabilityBlock) == rvCommandFactory) {
            this.rvFactories.remove(capabilityBlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RvCommand genRvCommand(RecvRvIcbm recvRvIcbm) {
        RvCommandFactory rvCommandFactory;
        DefensiveTools.checkNull(recvRvIcbm, "icbm");
        RvProcessor rvProcessor = this;
        synchronized (rvProcessor) {
            rvCommandFactory = (RvCommandFactory)this.rvFactories.get(recvRvIcbm.getCapability());
            if (rvCommandFactory == null) {
                rvCommandFactory = (RvCommandFactory)this.rvFactories.get(null);
            }
        }
        if (rvCommandFactory == null) {
            return null;
        }
        return rvCommandFactory.genRvCommand(recvRvIcbm);
    }

    private synchronized RvSessionImpl getSession(long l, String string) {
        DefensiveTools.checkNull(string, "sn");
        RvSessionMapKey rvSessionMapKey = new RvSessionMapKey(l, string);
        return (RvSessionImpl)this.sessions.get(rvSessionMapKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RvSessionImpl getOrCreateIncomingSession(long l, String string) {
        DefensiveTools.checkNull(string, "sn");
        RvSessionImpl rvSessionImpl = this.getSession(l, string);
        if (rvSessionImpl == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating new incoming RV session for " + string + ", id=0x" + Long.toHexString(l));
            }
            Object object = this.sessionLock;
            synchronized (object) {
                rvSessionImpl = this.createNewSession(l, string);
                this.fireNewSessionEvent(rvSessionImpl, NewRvSessionEvent.TYPE_INCOMING);
            }
        }
        return rvSessionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Object object, Throwable throwable, Object object2) {
        ClientSnacProcessor clientSnacProcessor;
        DefensiveTools.checkNull(object, "type");
        DefensiveTools.checkNull(throwable, "t");
        if (logger.isLoggable(Level.FINE)) {
            logger.finer("RV processor got exception type " + object + ": " + throwable + " - " + object2);
        }
        Object object3 = this;
        synchronized (object3) {
            clientSnacProcessor = this.snacProcessor;
        }
        if (clientSnacProcessor != null && (object3 = clientSnacProcessor.getFlapProcessor()) != null) {
            ((FlapProcessor)object3).handleException(object, throwable, object2);
            return;
        }
        logger.warning("RV processor got exception; no exception handlerspresent (type=" + object + ", info=" + object2 + ")");
        logger.warning(Arrays.asList(throwable.getStackTrace()).toString());
    }

    private void fireNewSessionEvent(RvSessionImpl rvSessionImpl, Object object) {
        NewRvSessionEvent newRvSessionEvent = new NewRvSessionEvent(this, rvSessionImpl, object);
        Iterator iterator = this.rvListeners.iterator();
        while (iterator.hasNext()) {
            RvProcessorListener rvProcessorListener = (RvProcessorListener)iterator.next();
            try {
                rvProcessorListener.handleNewSession(newRvSessionEvent);
            }
            catch (Throwable throwable) {
                this.handleException(ERRTYPE_RV_LISTENER, throwable, rvProcessorListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RvSessionImpl createNewSession(long l, String string) {
        RvSessionImpl rvSessionImpl = new RvSessionImpl(l, string);
        RvSessionMapKey rvSessionMapKey = new RvSessionMapKey(l, string);
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessions.put(rvSessionMapKey, rvSessionImpl);
        }
        return rvSessionImpl;
    }

    private void processRv(SnacPacketEvent snacPacketEvent) {
        RecvRvIcbm recvRvIcbm = (RecvRvIcbm)snacPacketEvent.getSnacCommand();
        RvSessionImpl rvSessionImpl = this.getOrCreateIncomingSession(recvRvIcbm.getRvSessionId(), recvRvIcbm.getSender().getScreenname());
        RvCommand rvCommand = null;
        try {
            rvCommand = this.genRvCommand(recvRvIcbm);
        }
        catch (Throwable throwable) {
            this.handleException(ERRTYPE_RV_CMD_GEN, throwable, recvRvIcbm);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Generated RV command: " + rvCommand);
        }
        RecvRvEvent recvRvEvent = new RecvRvEvent(snacPacketEvent, this, (RvSession)rvSessionImpl, rvCommand);
        rvSessionImpl.processRv(recvRvEvent);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Done processing RV");
        }
    }

    private void processResponse(SnacPacketEvent snacPacketEvent) {
        RvResponse rvResponse = (RvResponse)snacPacketEvent.getSnacCommand();
        RvSessionImpl rvSessionImpl = this.getOrCreateIncomingSession(rvResponse.getRvSessionId(), rvResponse.getScreenname());
        RecvRvEvent recvRvEvent = new RecvRvEvent(snacPacketEvent, this, (RvSession)rvSessionImpl, rvResponse.getResultCode());
        rvSessionImpl.processRv(recvRvEvent);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Done processing RV response");
        }
    }

    public final RvSession createRvSession(String string) {
        DefensiveTools.checkNull(string, "sn");
        return this.createRvSession(string, this.sessionId.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RvSession createRvSession(String string, long l) {
        RvSessionImpl rvSessionImpl;
        DefensiveTools.checkNull(string, "sn");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating new outgoing RV session for " + string);
        }
        Object object = this.sessionLock;
        synchronized (object) {
            rvSessionImpl = this.createNewSession(l, string);
            this.fireNewSessionEvent(rvSessionImpl, NewRvSessionEvent.TYPE_OUTGOING);
        }
        return rvSessionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSnac(SnacRequest snacRequest) {
        ClientSnacProcessor clientSnacProcessor;
        RvProcessor rvProcessor = this;
        synchronized (rvProcessor) {
            clientSnacProcessor = this.snacProcessor;
        }
        if (clientSnacProcessor == null) {
            return;
        }
        clientSnacProcessor.sendSnac(snacRequest);
    }

    private class RvSessionImpl
    implements RvSession {
        private final long rvSessionId;
        private final String sn;
        private CopyOnWriteArrayList listeners = new CopyOnWriteArrayList();
        private SnacRequestListener reqListener = new SnacRequestAdapter(this){
            private final /* synthetic */ RvSessionImpl this$1;
            {
                this.this$1 = rvSessionImpl;
            }

            public void handleResponse(SnacResponseEvent snacResponseEvent) {
                RvSnacResponseEvent rvSnacResponseEvent = new RvSnacResponseEvent(snacResponseEvent, RvSessionImpl.access$400(this.this$1), this.this$1);
                RvSessionImpl.access$500(this.this$1, rvSnacResponseEvent);
            }
        };

        public RvSessionImpl(long l, String string) {
            this.rvSessionId = l;
            this.sn = string;
        }

        public RvProcessor getRvProcessor() {
            return RvProcessor.this;
        }

        public long getRvSessionId() {
            return this.rvSessionId;
        }

        public String getScreenname() {
            return this.sn;
        }

        public void addListener(RvSessionListener rvSessionListener) {
            DefensiveTools.checkNull(rvSessionListener, "l");
            this.listeners.addIfAbsent(rvSessionListener);
        }

        public void removeListener(RvSessionListener rvSessionListener) {
            DefensiveTools.checkNull(rvSessionListener, "l");
            this.listeners.remove(rvSessionListener);
        }

        private void processRv(RecvRvEvent recvRvEvent) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                RvSessionListener rvSessionListener = (RvSessionListener)iterator.next();
                try {
                    rvSessionListener.handleRv(recvRvEvent);
                }
                catch (Throwable throwable) {
                    RvProcessor.this.handleException(ERRTYPE_RV_SESSION_LISTENER, throwable, rvSessionListener);
                }
            }
        }

        private void processSnacResponse(RvSnacResponseEvent rvSnacResponseEvent) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                RvSessionListener rvSessionListener = (RvSessionListener)iterator.next();
                try {
                    rvSessionListener.handleSnacResponse(rvSnacResponseEvent);
                }
                catch (Throwable throwable) {
                    RvProcessor.this.handleException(ERRTYPE_RV_SESSION_LISTENER, throwable, rvSessionListener);
                }
            }
        }

        public void sendRv(RvCommand rvCommand) {
            this.sendRv(rvCommand, 0L);
        }

        public void sendRv(RvCommand rvCommand, long l) {
            DefensiveTools.checkNull(rvCommand, "command");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Sending RV to " + this.sn + ": " + rvCommand);
            }
            SendRvIcbm sendRvIcbm = new SendRvIcbm(this.sn, l, this.rvSessionId, rvCommand);
            RvProcessor.this.sendSnac(new SnacRequest(sendRvIcbm, this.reqListener));
        }

        public void sendResponse(int n) {
            RvResponse rvResponse = new RvResponse(this.rvSessionId, 2, this.sn, n);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Sending RV response to " + this.sn + ": " + n);
            }
            RvProcessor.this.sendSnac(new SnacRequest(rvResponse, this.reqListener));
        }

        public String toString() {
            return "RvSession with " + this.getScreenname() + " (sessionid=0x" + Long.toHexString(this.rvSessionId) + ")";
        }

        static /* synthetic */ RvProcessor access$400(RvSessionImpl rvSessionImpl) {
            return rvSessionImpl.RvProcessor.this;
        }

        static /* synthetic */ void access$500(RvSessionImpl rvSessionImpl, RvSnacResponseEvent rvSnacResponseEvent) {
            rvSessionImpl.processSnacResponse(rvSnacResponseEvent);
        }
    }

    private static class RvSessionMapKey {
        private final long sessionId;
        private final String sn;

        public RvSessionMapKey(long l, String string) {
            this.sessionId = l;
            this.sn = OscarTools.normalize(string);
        }

        public int hashCode() {
            return (int)(this.sessionId >> 32 ^ this.sessionId ^ (long)this.sn.hashCode());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RvSessionMapKey)) {
                return false;
            }
            RvSessionMapKey rvSessionMapKey = (RvSessionMapKey)object;
            return this.sessionId == rvSessionMapKey.sessionId && this.sn.equals(rvSessionMapKey.sn);
        }
    }
}

