/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.dtmf;

import com.sun.medialib.codec.dtmf.Constants;
import com.sun.medialib.codec.dtmf.DTMFException;
import com.sun.medialib.codec.dtmf.dtmf_tables;

final class DTMF_DECODE
implements Constants {
    protected double thresh = 0.5;
    protected int std = 0;
    protected int rate = 8000;
    protected int amp = 5000;
    double[] g_buf = null;
    int tmp_tone = -1;
    double[] coeff_buf = new double[10];
    double[] coeff_buf_2 = new double[8];
    double[] last_row_coeff = new double[8];
    double[] last_row_pow = new double[4];
    double[] cos_buf0 = new double[4];
    double[] cos_buf1 = new double[4];
    double[] cos_buf2 = new double[4];
    double pow_aver = 0.0;
    double pow_last = 0.0;
    double q_av = 0.0;
    int on = 0;
    int off = 0;
    int silence = 1;
    int bad = 0;
    int count = 0;
    int noise_count = 0;
    int fini1 = -1;
    int fini2 = -1;
    double[] num = new double[5];
    double[] denom = new double[5];
    double[] delay = new double[8];
    double gain = 0.0;
    double[] comp_coeff_buf = null;

    DTMF_DECODE() {
    }

    public double getThresh() {
        return this.thresh;
    }

    public int getStd() {
        return this.std;
    }

    public int getRate() {
        return this.rate;
    }

    public int getAmp() {
        return this.amp;
    }

    public void setThresh(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DTMFException(7);
        }
        this.thresh = d;
    }

    public void setStd(int n) {
        double[] dArray = dtmf_tables.dtmf_STD;
        for (int i = 0; i < 5; ++i) {
            if (n != (int)dArray[8 * i]) continue;
            this.std = n;
            this.comp_coeff_buf = n == 2 ? dtmf_tables.dtmf_COMP_COEFF_BUF_DAN : (n == 4 ? dtmf_tables.dtmf_COMP_COEFF_BUF_DAN : dtmf_tables.dtmf_COMP_COEFF_BUF_ATT);
            return;
        }
        throw new DTMFException(3);
    }

    public void setAmp(int n) {
        if (n < 0 || n > Short.MAX_VALUE) {
            throw new DTMFException(8);
        }
        this.amp = n;
    }

    public void setRate(int n) {
        int n2;
        int[] nArray = dtmf_tables.dtmf_FR;
        if (n < 0) {
            throw new DTMFException(6);
        }
        int n3 = 106 * n / 8000;
        double[] dArray = new double[106 * n / 8000 + 2 * (80 * n / 1000) + 2];
        this.g_buf = dArray;
        this.tmp_tone = n3 + 1;
        this.pow_aver = 0.0;
        this.pow_last = 0.0;
        this.q_av = 0.0;
        this.rate = n;
        this.on = 0;
        this.off = 0;
        this.silence = 1;
        this.bad = 0;
        this.count = 0;
        this.noise_count = 0;
        this.fini1 = -1;
        this.fini2 = -1;
        double d = Math.PI * 2 / (double)n;
        this.coeff_buf[0] = 2.0 * Math.cos(d * (double)nArray[0]);
        this.coeff_buf[1] = 2.0 * Math.cos(d * (double)nArray[1]);
        this.coeff_buf[2] = 2.0 * Math.cos(d * (double)nArray[2]);
        this.coeff_buf[3] = 2.0 * Math.cos(d * (double)nArray[3]);
        this.coeff_buf[4] = 2.0 * Math.cos(d * (double)nArray[4]);
        this.coeff_buf[5] = 2.0 * Math.cos(d * (double)nArray[5]);
        this.coeff_buf[6] = 2.0 * Math.cos(d * (double)nArray[6]);
        this.coeff_buf[7] = 2.0 * Math.cos(d * (double)nArray[7]);
        this.coeff_buf[8] = 2.0 * Math.cos(d * (double)nArray[8]);
        this.coeff_buf[9] = 2.0 * Math.cos(d * (double)nArray[9]);
        this.coeff_buf_2[0] = 2.0 * Math.cos(d * 2.0 * (double)nArray[0]);
        this.coeff_buf_2[1] = 2.0 * Math.cos(d * 2.0 * (double)nArray[1]);
        this.coeff_buf_2[2] = 2.0 * Math.cos(d * 2.0 * (double)nArray[2]);
        this.coeff_buf_2[3] = 2.0 * Math.cos(d * 2.0 * (double)nArray[3]);
        this.coeff_buf_2[4] = 2.0 * Math.cos(d * 2.0 * (double)nArray[4]);
        this.coeff_buf_2[5] = 2.0 * Math.cos(d * 2.0 * (double)nArray[5]);
        this.coeff_buf_2[6] = 2.0 * Math.cos(d * 2.0 * (double)nArray[6]);
        this.coeff_buf_2[7] = 2.0 * Math.cos(d * 2.0 * (double)nArray[7]);
        d = Math.PI * 2 * (double)(n3 - 1) / (double)n;
        this.cos_buf0[0] = 2.0 * Math.cos(d * (double)nArray[0]);
        this.cos_buf0[1] = 2.0 * Math.cos(d * (double)nArray[1]);
        this.cos_buf0[2] = 2.0 * Math.cos(d * (double)nArray[2]);
        this.cos_buf0[3] = 2.0 * Math.cos(d * (double)nArray[3]);
        d = Math.PI * 2 * (double)n3 / (double)n;
        this.cos_buf1[0] = 2.0 * Math.cos(d * (double)nArray[0]);
        this.cos_buf1[1] = 2.0 * Math.cos(d * (double)nArray[1]);
        this.cos_buf1[2] = 2.0 * Math.cos(d * (double)nArray[2]);
        this.cos_buf1[3] = 2.0 * Math.cos(d * (double)nArray[3]);
        d = Math.PI * 2 * (double)(n3 + 1) / (double)n;
        this.cos_buf2[0] = 2.0 * Math.cos(d * (double)nArray[0]);
        this.cos_buf2[1] = 2.0 * Math.cos(d * (double)nArray[1]);
        this.cos_buf2[2] = 2.0 * Math.cos(d * (double)nArray[2]);
        this.cos_buf2[3] = 2.0 * Math.cos(d * (double)nArray[3]);
        for (n2 = 0; n2 < 2 * (80 * n / 1000); ++n2) {
            dArray[this.tmp_tone + n2] = 0.0;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.last_row_coeff[n2] = 0.0;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.last_row_pow[n2] = 0.0;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.delay[n2] = 0.0;
        }
        this.dtmf_filter_create(n);
    }

    private void dtmf_filter_create(int n) {
        int n2;
        double[] dArray = new double[16];
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        double[] dArray4 = this.denom;
        double[] dArray5 = this.num;
        dArray4[0] = 1.0;
        dArray5[0] = 1.0;
        dArray2[0] = 0.0;
        dArray3[0] = 0.0;
        for (n2 = 1; n2 < 5; ++n2) {
            dArray4[n2] = 0.0;
            dArray5[n2] = 0.0;
            dArray2[n2] = 0.0;
            dArray3[n2] = 0.0;
        }
        double d = 628.3185307179587 / (double)n;
        double d2 = Math.sin(d) / Math.cos(d);
        double d3 = Math.cos(2513.2741228718346 / (double)n) / Math.cos(d);
        int n3 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            double d4;
            double d5 = dtmf_tables.dtmf_PZ_S[2 * n2];
            double d6 = dtmf_tables.dtmf_PZ_S[2 * n2 + 1];
            double d7 = d2 * d5;
            double d8 = d2 * d6;
            double d9 = 2.0 - 2.0 * d7;
            double d10 = -2.0 * d8;
            double d11 = 4.0 * (d3 * d3 + d7 * d7 - d8 * d8 - 1.0);
            double d12 = 8.0 * d7 * d8;
            if (d12 == 0.0) {
                if (d11 < 0.0) {
                    d8 = Math.sqrt(-d11);
                    d11 = 0.0;
                } else {
                    d11 = Math.sqrt(d11);
                    d8 = 0.0;
                }
            } else if (d11 == 0.0) {
                d8 = d4 = Math.sqrt(0.5 * Math.abs(d12));
                d11 = d12 > 0.0 ? d4 : -d4;
            } else {
                double d13 = Math.sqrt(Math.sqrt(d11 * d11 + d12 * d12));
                double d14 = 0.5 * Math.atan2(d12, d11);
                if (d14 < 0.0) {
                    d14 += Math.PI;
                }
                d11 = d13 * Math.cos(d14);
                d8 = d13 * Math.sin(d14);
            }
            d7 = 2.0 * d3 + d11;
            d4 = d9 * d9 + d10 * d10;
            double d15 = (d7 * d9 + d8 * d10) / d4;
            double d16 = (d8 * d9 - d7 * d10) / d4;
            dArray[n3] = d15;
            dArray[++n3] = d16;
            ++n3;
            if (d16 != 0.0) {
                dArray[n3] = d15;
                dArray[++n3] = -d16;
                ++n3;
            }
            if (d6 == 0.0 && d16 != 0.0) continue;
            d7 = 2.0 * d3 - d11;
            d8 = -d8;
            d4 = d9 * d9 + d10 * d10;
            d15 = (d7 * d9 + d8 * d10) / d4;
            d16 = (d8 * d9 - d7 * d10) / d4;
            dArray[n3] = d15;
            dArray[++n3] = d16;
            ++n3;
            if (d16 == 0.0) continue;
            dArray[n3] = d15;
            dArray[++n3] = -d16;
            ++n3;
        }
        while (n3 < 8) {
            dArray[n3] = -1.0;
            dArray[n3 + 1] = 0.0;
            n3 += 2;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            double d17 = dArray[2 * n3];
            double d18 = dArray[2 * n3 + 1];
            double d19 = dArray[2 * n3 + 8];
            double d20 = dArray[2 * n3 + 9];
            for (n2 = 0; n2 <= n3; ++n2) {
                int n4 = n3 - n2;
                int n5 = n4 + 1;
                dArray4[n5] = dArray4[n5] + (d18 * dArray2[n4] - d17 * dArray4[n4]);
                int n6 = n4 + 1;
                dArray2[n6] = dArray2[n6] - (d18 * dArray4[n4] + d17 * dArray2[n4]);
                int n7 = n4 + 1;
                dArray5[n7] = dArray5[n7] + (d20 * dArray3[n4] - d19 * dArray5[n4]);
                int n8 = n4 + 1;
                dArray3[n8] = dArray3[n8] - (d20 * dArray5[n4] + d19 * dArray3[n4]);
            }
        }
        double d21 = 1.0;
        double d22 = 1.0;
        for (n3 = 1; n3 <= 4; ++n3) {
            d21 = dArray5[n3] + d21;
            d22 = dArray4[n3] + d22;
        }
        this.gain = d21 / d22;
    }
}

