/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import java.util.IllegalFormatException;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmpp.jnodes.smack.JingleChannelIQ;

public class JingleNodesProvider
implements IQProvider {
    public JingleChannelIQ parseIQ(XmlPullParser parser) throws Exception {
        JingleChannelIQ iq = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.getEventType();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("channel") && namespace.equals("http://jabber.org/protocol/jinglenodes#channel")) {
                    String protocol = parser.getAttributeValue(null, "protocol");
                    String porta = parser.getAttributeValue(null, "localport");
                    String portb = parser.getAttributeValue(null, "remoteport");
                    String host = parser.getAttributeValue(null, "host");
                    try {
                        iq = new JingleChannelIQ();
                        iq.setProtocol(protocol == null ? "udp" : protocol);
                        if (host != null) {
                            iq.setHost(host);
                        }
                        if (porta != null) {
                            iq.setLocalport(Integer.valueOf(porta));
                        }
                        if (portb != null) {
                            iq.setRemoteport(Integer.valueOf(portb));
                        }
                    }
                    catch (IllegalFormatException e) {
                        e.printStackTrace();
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            } else if (eventType == 3) {
                done = true;
            }
            if (done) continue;
            parser.next();
        }
        return iq;
    }
}

