/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RemoteRosterEntry {
    private String user;
    private String name;
    private final List<String> groupNames = new ArrayList<String>();

    public RemoteRosterEntry(String user, String name, String[] groups) {
        this.user = user;
        this.name = name;
        if (groups != null) {
            this.groupNames.addAll(Arrays.asList(groups));
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getGroupNames() {
        List<String> list = this.groupNames;
        synchronized (list) {
            return Collections.unmodifiableList(this.groupNames).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroupArrayNames() {
        List<String> list = this.groupNames;
        synchronized (list) {
            return Collections.unmodifiableList(this.groupNames).toArray(new String[this.groupNames.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<item jid=\"").append(this.user).append("\"");
        if (this.name != null) {
            buf.append(" name=\"").append(this.name).append("\"");
        }
        buf.append(">");
        List<String> list = this.groupNames;
        synchronized (list) {
            for (String groupName : this.groupNames) {
                buf.append("<group>").append(groupName).append("</group>");
            }
        }
        buf.append("</item>");
        return buf.toString();
    }
}

