/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnAllKeysCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAllPartitionsMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.PartitionWideEntryOperationFactory;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapExecuteOnAllKeysMessageTask
extends AbstractAllPartitionsMessageTask<MapExecuteOnAllKeysCodec.RequestParameters> {
    public MapExecuteOnAllKeysMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        EntryProcessor entryProcessor = (EntryProcessor)this.serializationService.toObject(((MapExecuteOnAllKeysCodec.RequestParameters)this.parameters).entryProcessor);
        return new PartitionWideEntryOperationFactory(((MapExecuteOnAllKeysCodec.RequestParameters)this.parameters).name, entryProcessor);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashMap<Data, Data> dataMap = new HashMap<Data, Data>();
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntrySet entrySet = (MapEntrySet)mapService.getMapServiceContext().toObject(o);
            Set<Map.Entry<Data, Data>> entries = entrySet.getEntrySet();
            for (Map.Entry<Data, Data> entry : entries) {
                dataMap.put(entry.getKey(), entry.getValue());
            }
        }
        return dataMap;
    }

    @Override
    protected MapExecuteOnAllKeysCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapExecuteOnAllKeysCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapExecuteOnAllKeysCodec.encodeResponse((Map)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapExecuteOnAllKeysCodec.RequestParameters)this.parameters).name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapExecuteOnAllKeysCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "executeOnEntries";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapExecuteOnAllKeysCodec.RequestParameters)this.parameters).entryProcessor};
    }
}

