/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class GetAllOperation
extends AbstractMapOperation
implements ReadonlyOperation,
PartitionAwareOperation {
    private Set<Data> keys = new HashSet<Data>();
    private MapEntrySet entrySet;
    private transient RecordStore recordStore;

    public GetAllOperation() {
    }

    public GetAllOperation(String name, Set<Data> keys) {
        super(name);
        this.keys = keys;
    }

    @Override
    public void run() {
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        int partitionId = this.getPartitionId();
        this.recordStore = this.mapService.getMapServiceContext().getRecordStore(partitionId, this.name);
        HashSet<Data> partitionKeySet = new HashSet<Data>();
        for (Data key : this.keys) {
            if (partitionId != partitionService.getPartitionId(key)) continue;
            partitionKeySet.add(key);
        }
        this.entrySet = this.recordStore.getAll(partitionKeySet);
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (!this.entrySet.isEmpty()) {
            this.evict(false);
        }
    }

    protected void evict(boolean backup) {
        if (this.recordStore == null) {
            return;
        }
        long now = Clock.currentTimeMillis();
        this.recordStore.evictEntries(now, backup);
    }

    @Override
    public Object getResponse() {
        return this.entrySet;
    }

    @Override
    public String toString() {
        return "GetAllOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (this.keys == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                out.writeData(key);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size > -1) {
            for (int i = 0; i < size; ++i) {
                Data data = in.readData();
                this.keys.add(data);
            }
        }
    }
}

