/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.instance.GroupProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;

public class QueryResultSizeLimiter {
    public static final int MINIMUM_MAX_RESULT_LIMIT = 100000;
    public static final float MAX_RESULT_LIMIT_FACTOR = 1.15f;
    static final int DISABLED = -1;
    private final MapServiceContext mapServiceContext;
    private final ILogger log;
    private final int maxResultLimit;
    private final int maxLocalPartitionsLimitForPreCheck;
    private final float resultLimitPerPartition;
    private final boolean isQueryResultLimitEnabled;
    private final boolean isPreCheckEnabled;

    public QueryResultSizeLimiter(MapServiceContext mapServiceContext, ILogger log) {
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.mapServiceContext = mapServiceContext;
        this.log = log;
        GroupProperties groupProperties = nodeEngine.getGroupProperties();
        this.maxResultLimit = this.getMaxResultLimit(groupProperties);
        this.maxLocalPartitionsLimitForPreCheck = this.getMaxLocalPartitionsLimitForPreCheck(groupProperties);
        this.resultLimitPerPartition = (float)this.maxResultLimit * 1.15f / (float)this.getPartitionCount(nodeEngine);
        this.isQueryResultLimitEnabled = this.maxResultLimit != -1;
        this.isPreCheckEnabled = this.isQueryResultLimitEnabled && this.maxLocalPartitionsLimitForPreCheck != -1;
    }

    boolean isQueryResultLimitEnabled() {
        return this.isQueryResultLimitEnabled;
    }

    boolean isPreCheckEnabled() {
        return this.isPreCheckEnabled;
    }

    long getNodeResultLimit(int ownedPartitions) {
        return this.isQueryResultLimitEnabled ? (long)Math.ceil(this.resultLimitPerPartition * (float)ownedPartitions) : Long.MAX_VALUE;
    }

    void checkMaxResultLimitOnLocalPartitions(String mapName) {
        if (!this.isPreCheckEnabled) {
            return;
        }
        Collection<Integer> localPartitions = this.mapServiceContext.getOwnedPartitions();
        int partitionsToCheck = Math.min(localPartitions.size(), this.maxLocalPartitionsLimitForPreCheck);
        if (partitionsToCheck == 0) {
            return;
        }
        int localPartitionSize = this.getLocalPartitionSize(mapName, localPartitions, partitionsToCheck);
        if (localPartitionSize == 0) {
            return;
        }
        long localResultLimit = this.getNodeResultLimit(partitionsToCheck);
        if ((long)localPartitionSize > localResultLimit) {
            throw new QueryResultSizeExceededException(this.maxResultLimit, " Result size exceeded in local pre-check.");
        }
    }

    private int getLocalPartitionSize(String mapName, Collection<Integer> localPartitions, int partitionsToCheck) {
        int localSize = 0;
        int partitionsChecked = 0;
        for (int partitionId : localPartitions) {
            localSize += this.mapServiceContext.getRecordStore(partitionId, mapName).size();
            if (++partitionsChecked != partitionsToCheck) continue;
            break;
        }
        return localSize;
    }

    private int getMaxResultLimit(GroupProperties groupProperties) {
        int maxResultLimit = groupProperties.QUERY_RESULT_SIZE_LIMIT.getInteger();
        if (maxResultLimit == -1) {
            return -1;
        }
        if (maxResultLimit <= 0) {
            throw new IllegalArgumentException(groupProperties.QUERY_RESULT_SIZE_LIMIT.getName() + " has to be -1 (disabled) or a positive number!");
        }
        if (maxResultLimit < 100000) {
            this.log.finest("Max result limit was set to minimal value of 100000");
            return 100000;
        }
        return maxResultLimit;
    }

    private int getMaxLocalPartitionsLimitForPreCheck(GroupProperties groupProperties) {
        int maxLocalPartitionLimitForPreCheck = groupProperties.QUERY_MAX_LOCAL_PARTITION_LIMIT_FOR_PRE_CHECK.getInteger();
        if (maxLocalPartitionLimitForPreCheck == -1) {
            return -1;
        }
        if (maxLocalPartitionLimitForPreCheck <= 0) {
            throw new IllegalArgumentException(groupProperties.QUERY_MAX_LOCAL_PARTITION_LIMIT_FOR_PRE_CHECK.getName() + " has to be -1 (disabled) or a positive number!");
        }
        return maxLocalPartitionLimitForPreCheck;
    }

    private int getPartitionCount(NodeEngine nodeEngine) {
        return nodeEngine.getPartitionService().getPartitionCount();
    }
}

