/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilterStrategies;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCodes;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.math.IntMath;
import java.io.Serializable;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class BloomFilter<T>
implements Serializable {
    private final BitArray bits;
    private final int hashBitsPerSlice;
    private final int numHashFunctions;
    private final Funnel<T> funnel;
    private final HashFunction hashFunction;
    private static final double LN2 = Math.log(2.0);
    private static final double LN2_SQUARED = LN2 * LN2;

    private BloomFilter(BitArray bits, int numHashFunctions, Funnel<T> funnel, HashFunction hashFunction) {
        Preconditions.checkArgument(numHashFunctions > 0, "numHashFunctions zero or negative");
        this.bits = Preconditions.checkNotNull(bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = Preconditions.checkNotNull(funnel);
        this.hashFunction = Preconditions.checkNotNull(hashFunction);
        this.hashBitsPerSlice = IntMath.log2(Math.max(bits.size(), 64), RoundingMode.CEILING);
    }

    public boolean mightContain(T instance) {
        HashCodes.HashCodeSlicer slicer = HashCodes.slice(this.hashFunction.newHasher().putObject(instance, this.funnel).hash(), this.hashBitsPerSlice);
        for (int i = 0; i < this.numHashFunctions; ++i) {
            if (this.bits.get(slicer.nextSlice())) continue;
            return false;
        }
        return true;
    }

    public void put(T instance) {
        HashCodes.HashCodeSlicer slicer = HashCodes.slice(this.hashFunction.newHasher().putObject(instance, this.funnel).hash(), this.hashBitsPerSlice);
        for (int i = 0; i < this.numHashFunctions; ++i) {
            int nextSlice = slicer.nextSlice();
            this.bits.set(nextSlice);
        }
    }

    @VisibleForTesting
    int getHashCount() {
        return this.numHashFunctions;
    }

    @VisibleForTesting
    double computeExpectedFalsePositiveRate(int insertions) {
        return Math.pow(1.0 - Math.exp((double)(-this.numHashFunctions) * ((double)insertions / (double)this.bits.size())), this.numHashFunctions);
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions, double falsePositiveProbability) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(expectedInsertions > 0, "Expected insertions must be positive");
        Preconditions.checkArgument(falsePositiveProbability > 0.0 & falsePositiveProbability < 1.0, "False positive probability in (0.0, 1.0)");
        int m = BloomFilter.optimalM(expectedInsertions, falsePositiveProbability);
        int k = BloomFilter.optimalK(expectedInsertions, m);
        BitArray bits = new BitArray(1 << IntMath.log2(Math.max(m, 64), RoundingMode.CEILING));
        BloomFilterStrategies.From128ToN hashFunction = BloomFilterStrategies.From128ToN.withBits(bits.size() * k, Hashing.murmur3_128());
        return new BloomFilter<T>(bits, k, funnel, hashFunction);
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions) {
        return BloomFilter.create(funnel, expectedInsertions, 0.03);
    }

    @VisibleForTesting
    static int optimalK(int n, int m) {
        return Math.max(1, (int)Math.round((double)(m / n) * LN2));
    }

    @VisibleForTesting
    static int optimalM(int n, double p) {
        return (int)((double)(-n) * Math.log(p) / LN2_SQUARED);
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerialForm<T>
    implements Serializable {
        final long[] data;
        final int numHashFunctions;
        final Funnel<T> funnel;
        final HashFunction hashFunction;
        private static final long serialVersionUID = 0L;

        SerialForm(BloomFilter<T> bf) {
            this.data = ((BloomFilter)bf).bits.data;
            this.numHashFunctions = ((BloomFilter)bf).numHashFunctions;
            this.funnel = ((BloomFilter)bf).funnel;
            this.hashFunction = ((BloomFilter)bf).hashFunction;
        }

        Object readResolve() {
            return new BloomFilter(new BitArray(this.data), this.numHashFunctions, this.funnel, this.hashFunction);
        }
    }

    private static class BitArray {
        final long[] data;

        BitArray(int bits) {
            this(new long[bits >> 6]);
        }

        BitArray(long[] data) {
            Preconditions.checkArgument(data.length > 0, "data length is zero!");
            this.data = data;
        }

        void set(int index) {
            int n = index >> 6;
            this.data[n] = this.data[n] | 1L << index;
        }

        boolean get(int index) {
            return (this.data[index >> 6] & 1L << index) != 0L;
        }

        int size() {
            return this.data.length * 64;
        }
    }
}

