/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.MergeClustersOperation;
import com.hazelcast.cluster.PrepareMergeOperation;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.SystemLogService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractJoiner
implements Joiner {
    private final AtomicLong joinStartTime = new AtomicLong(Clock.currentTimeMillis());
    private final AtomicInteger tryCount = new AtomicInteger(0);
    protected final Config config;
    protected final Node node;
    protected final ILogger logger;
    protected final SystemLogService systemLogService;
    private volatile Address targetAddress;

    public AbstractJoiner(Node node) {
        this.node = node;
        this.systemLogService = node.getSystemLogService();
        this.logger = node.loggingService.getLogger(this.getClass().getName());
        this.config = node.config;
    }

    public abstract void doJoin(AtomicBoolean var1);

    @Override
    public void join(AtomicBoolean joined) {
        this.doJoin(joined);
        this.postJoin();
    }

    private void postJoin() {
        this.systemLogService.logJoin("PostJoin master: " + this.node.getMasterAddress() + ", isMaster: " + this.node.isMaster());
        if (!this.node.isActive()) {
            return;
        }
        if (this.tryCount.incrementAndGet() == 5) {
            this.logger.warning("Join try count exceed limit, setting this node as master!");
            this.node.setAsMaster();
        }
        if (!this.node.isMaster()) {
            boolean allConnected = false;
            int checkCount = 0;
            long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
            if (this.node.joined()) {
                this.systemLogService.logJoin("Waiting for all connections");
                while (checkCount++ < this.node.groupProperties.CONNECT_ALL_WAIT_SECONDS.getInteger() && !allConnected) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    Collection members = this.node.getClusterService().getMembers();
                    allConnected = true;
                    for (Member member : members) {
                        MemberImpl memberImpl = (MemberImpl)member;
                        if (memberImpl.localMember() || this.node.connectionManager.getOrConnect(memberImpl.getAddress()) != null) continue;
                        allConnected = false;
                        this.systemLogService.logJoin("Not-connected to " + memberImpl.getAddress());
                    }
                }
            }
            if (!this.node.joined() || !allConnected) {
                if (Clock.currentTimeMillis() - this.getStartTime() < maxJoinMillis) {
                    this.logger.warning("Failed to connect, node joined= " + this.node.joined() + ", allConnected= " + allConnected + " to all other members after " + checkCount + " seconds.");
                    this.logger.warning("Rebooting after 10 seconds.");
                    try {
                        Thread.sleep(10000L);
                        this.node.rejoin();
                    }
                    catch (InterruptedException e) {
                        this.logger.warning(e);
                        this.node.shutdown(false);
                    }
                } else {
                    throw new HazelcastException("Failed to join in " + maxJoinMillis / 1000L + " seconds!");
                }
                return;
            }
        }
        if (this.node.getClusterService().getSize() == 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append(this.node.clusterService.membersString());
            this.logger.info(sb.toString());
        }
    }

    protected void failedJoiningToMaster(boolean multicast, int tryCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("======================================================");
        sb.append("\n");
        sb.append("Couldn't connect to discovered master! tryCount: ").append(tryCount);
        sb.append("\n");
        sb.append("address: ").append(this.node.getThisAddress());
        sb.append("\n");
        sb.append("masterAddress: ").append(this.node.getMasterAddress());
        sb.append("\n");
        sb.append("multicast: ").append(multicast);
        sb.append("\n");
        sb.append("connection: ").append(this.node.connectionManager.getConnection(this.node.getMasterAddress()));
        sb.append("\n");
        sb.append("======================================================");
        sb.append("\n");
        throw new IllegalStateException(sb.toString());
    }

    boolean shouldMerge(JoinMessage joinRequest) {
        boolean shouldMerge = false;
        if (joinRequest != null) {
            try {
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.getClusterService().validateJoinMessage(joinRequest);
                }
                catch (Exception e) {
                    this.logger.finest(e.getMessage());
                    validJoinRequest = false;
                }
                if (validJoinRequest) {
                    for (Member member : this.node.getClusterService().getMembers()) {
                        MemberImpl memberImpl = (MemberImpl)member;
                        if (!memberImpl.getAddress().equals(joinRequest.getAddress())) continue;
                        this.logger.finest("Should not merge to " + joinRequest.getAddress() + ", because it is already member of this cluster.");
                        return false;
                    }
                    int currentMemberCount = this.node.getClusterService().getMembers().size();
                    if (joinRequest.getMemberCount() > currentMemberCount) {
                        this.logger.info(this.node.getThisAddress() + " is merging to " + joinRequest.getAddress() + ", because : joinRequest.getMemberCount() > currentMemberCount [" + joinRequest.getMemberCount() + " > " + currentMemberCount + "]");
                        this.logger.finest(joinRequest.toString());
                        shouldMerge = true;
                    } else if (joinRequest.getMemberCount() == currentMemberCount) {
                        if (this.node.getThisAddress().hashCode() > joinRequest.getAddress().hashCode()) {
                            this.logger.info(this.node.getThisAddress() + " is merging to " + joinRequest.getAddress() + ", because : node.getThisAddress().hashCode() > joinRequest.address.hashCode() " + ", this node member count: " + currentMemberCount);
                            this.logger.finest(joinRequest.toString());
                            shouldMerge = true;
                        } else {
                            this.logger.finest(joinRequest.getAddress() + " should merge to this node " + ", because : node.getThisAddress().hashCode() < joinRequest.address.hashCode() " + ", this node member count: " + currentMemberCount);
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.logger.severe(e);
                return false;
            }
        }
        return shouldMerge;
    }

    protected void connectAndSendJoinRequest(Collection<Address> colPossibleAddresses) {
        for (Address possibleAddress : colPossibleAddresses) {
            Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
            if (conn == null) continue;
            this.logger.finest("sending join request for " + possibleAddress);
            this.node.clusterService.sendJoinRequest(possibleAddress, true);
        }
    }

    @Override
    public void reset() {
        this.joinStartTime.set(Clock.currentTimeMillis());
        this.tryCount.set(0);
    }

    protected void startClusterMerge(Address targetAddress) {
        OperationService operationService = this.node.nodeEngine.getOperationService();
        Collection<MemberImpl> memberList = this.node.getClusterService().getMemberList();
        ArrayList<Future> calls = new ArrayList<Future>();
        for (MemberImpl member : memberList) {
            if (member.localMember()) continue;
            Future f = operationService.createInvocationBuilder("hz:core:clusterService", (Operation)new PrepareMergeOperation(targetAddress), member.getAddress()).setTryCount(3).build().invoke();
            calls.add(f);
        }
        for (Future f : calls) {
            try {
                f.get(1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.logger.finest("While waiting merge response...", e);
            }
        }
        PrepareMergeOperation prepareMergeOperation = new PrepareMergeOperation(targetAddress);
        prepareMergeOperation.setNodeEngine(this.node.nodeEngine).setService(this.node.getClusterService()).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
        operationService.runOperation(prepareMergeOperation);
        for (MemberImpl member : memberList) {
            if (member.localMember()) continue;
            operationService.createInvocationBuilder("hz:core:clusterService", (Operation)new MergeClustersOperation(targetAddress), member.getAddress()).setTryCount(1).build().invoke();
        }
        MergeClustersOperation mergeClustersOperation = new MergeClustersOperation(targetAddress);
        mergeClustersOperation.setNodeEngine(this.node.nodeEngine).setService(this.node.getClusterService()).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
        operationService.runOperation(mergeClustersOperation);
    }

    @Override
    public final long getStartTime() {
        return this.joinStartTime.get();
    }

    @Override
    public void setTargetAddress(Address targetAddress) {
        this.targetAddress = targetAddress;
    }

    public Address getTargetAddress() {
        Address target = this.targetAddress;
        this.targetAddress = null;
        return target;
    }
}

