/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.packet.AdHocCommandData;

public class RemoteCommand
extends AdHocCommand {
    private Connection connection;
    private String jid;
    private String sessionID;
    private long packetReplyTimeout;

    protected RemoteCommand(Connection connection, String node, String jid) {
        this.connection = connection;
        this.jid = jid;
        this.setNode(node);
        this.packetReplyTimeout = SmackConfiguration.getPacketReplyTimeout();
    }

    @Override
    public void cancel() throws XMPPException {
        this.executeAction(AdHocCommand.Action.cancel, this.packetReplyTimeout);
    }

    @Override
    public void complete(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.complete, form, this.packetReplyTimeout);
    }

    @Override
    public void execute() throws XMPPException {
        this.executeAction(AdHocCommand.Action.execute, this.packetReplyTimeout);
    }

    public void execute(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.execute, form, this.packetReplyTimeout);
    }

    @Override
    public void next(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.next, form, this.packetReplyTimeout);
    }

    @Override
    public void prev() throws XMPPException {
        this.executeAction(AdHocCommand.Action.prev, this.packetReplyTimeout);
    }

    private void executeAction(AdHocCommand.Action action, long packetReplyTimeout) throws XMPPException {
        this.executeAction(action, null, packetReplyTimeout);
    }

    private void executeAction(AdHocCommand.Action action, Form form, long timeout) throws XMPPException {
        AdHocCommandData data = new AdHocCommandData();
        data.setType(IQ.Type.SET);
        data.setTo(this.getOwnerJID());
        data.setNode(this.getNode());
        data.setSessionID(this.sessionID);
        data.setAction(action);
        if (form != null) {
            data.setForm(form.getDataFormToSend());
        }
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(data.getPacketID()));
        this.connection.sendPacket((Packet)data);
        Packet response = collector.nextResult(timeout);
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        AdHocCommandData responseData = (AdHocCommandData)response;
        this.sessionID = responseData.getSessionID();
        super.setData(responseData);
    }

    @Override
    public String getOwnerJID() {
        return this.jid;
    }

    public long getPacketReplyTimeout() {
        return this.packetReplyTimeout;
    }

    public void setPacketReplyTimeout(long packetReplyTimeout) {
        this.packetReplyTimeout = packetReplyTimeout;
    }
}

