/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import gnu.java.zrtp.utils.ZrtpFortuna;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.AbstractSrtpControl;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;

public class DtlsControlImpl
extends AbstractSrtpControl<DtlsTransformEngine>
implements DtlsControl {
    private static final char[] HEX_ENCODE_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger logger = Logger.getLogger(DtlsControlImpl.class);
    private static final long ONE_DAY = 86400000L;
    static final int[] SRTP_PROTECTION_PROFILES = new int[]{1, 2};
    private static final boolean VERIFY_AND_VALIDATE_CERTIFICATE;
    private static final String VERIFY_AND_VALIDATE_CERTIFICATE_PNAME;
    private final org.bouncycastle.crypto.tls.Certificate certificate;
    private AbstractRTPConnector connector;
    private final boolean disableSRTP;
    private boolean disposed = false;
    private final AsymmetricCipherKeyPair keyPair;
    private final String localFingerprint;
    private final String localFingerprintHashFunction;
    private Map<String, String> remoteFingerprints;
    private boolean rtcpmux = false;
    private DtlsControl.Setup setup;
    private final Set<Object> users = new HashSet<Object>();

    static int chooseSRTPProtectionProfile(int ... theirs) {
        int[] ours = SRTP_PROTECTION_PROFILES;
        if (theirs != null) {
            for (int t = 0; t < theirs.length; ++t) {
                int their = theirs[t];
                for (int o = 0; o < ours.length; ++o) {
                    int our = ours[o];
                    if (their != our) continue;
                    return their;
                }
            }
        }
        return 0;
    }

    private static final String computeFingerprint(Certificate certificate, String hashFunction) {
        try {
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(hashFunction.toUpperCase());
            ExtendedDigest digest = BcDefaultDigestProvider.INSTANCE.get(digAlgId);
            byte[] in = certificate.getEncoded("DER");
            byte[] out = new byte[digest.getDigestSize()];
            digest.update(in, 0, in.length);
            digest.doFinal(out, 0);
            return DtlsControlImpl.toHex(out);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to generate certificate fingerprint!", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    static SecureRandom createSecureRandom() {
        return new SecureRandom(){

            @Override
            public byte[] generateSeed(int numBytes) {
                byte[] seed = new byte[numBytes];
                ZrtpFortuna.getInstance().nextBytes(seed);
                return seed;
            }

            @Override
            public void nextBytes(byte[] bytes) {
                ZrtpFortuna.getInstance().nextBytes(bytes);
            }
        };
    }

    private static String findHashFunction(Certificate certificate) {
        try {
            AlgorithmIdentifier sigAlgId = certificate.getSignatureAlgorithm();
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            return BcDefaultDigestProvider.INSTANCE.get(digAlgId).getAlgorithmName().toLowerCase();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.warn("Failed to find the hash function of the signature algorithm of a certificate!", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static X500Name generateCN() {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        String applicationName = System.getProperty("sip-communicator.application.name");
        String applicationVersion = System.getProperty("sip-communicator.version");
        StringBuilder cn = new StringBuilder();
        if (!StringUtils.isNullOrEmpty(applicationName, true)) {
            cn.append(applicationName);
        }
        if (!StringUtils.isNullOrEmpty(applicationVersion, true)) {
            if (cn.length() != 0) {
                cn.append(' ');
            }
            cn.append(applicationVersion);
        }
        if (cn.length() == 0) {
            cn.append(DtlsControlImpl.class.getName());
        }
        builder.addRDN(BCStyle.CN, cn.toString());
        return builder.build();
    }

    private static AsymmetricCipherKeyPair generateKeyPair() {
        RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
        generator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(new BigInteger("10001", 16), DtlsControlImpl.createSecureRandom(), 1024, 80));
        return generator.generateKeyPair();
    }

    private static Certificate generateX509Certificate(X500Name subject, AsymmetricCipherKeyPair keyPair) {
        try {
            long now = System.currentTimeMillis();
            Date notBefore = new Date(now - 86400000L);
            Date notAfter = new Date(now + 518400000L);
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(subject, BigInteger.valueOf(now), notBefore, notAfter, subject, SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)keyPair.getPublic()));
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            ContentSigner signer = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(keyPair.getPrivate());
            return builder.build(signer).toASN1Structure();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to generate self-signed X.509 certificate", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static String toHex(byte[] fingerprint) {
        if (fingerprint.length == 0) {
            throw new IllegalArgumentException("fingerprint");
        }
        char[] chars = new char[3 * fingerprint.length - 1];
        int fLast = fingerprint.length - 1;
        int c = 0;
        for (int f = 0; f <= fLast; ++f) {
            int b = fingerprint[f] & 0xFF;
            chars[c++] = HEX_ENCODE_TABLE[b >>> 4];
            chars[c++] = HEX_ENCODE_TABLE[b & 0xF];
            if (f == fLast) continue;
            chars[c++] = 58;
        }
        return new String(chars);
    }

    public DtlsControlImpl() {
        this(false);
    }

    public DtlsControlImpl(boolean disableSRTP) {
        super(SrtpControlType.DTLS_SRTP);
        this.disableSRTP = disableSRTP;
        this.keyPair = DtlsControlImpl.generateKeyPair();
        Certificate x509Certificate = DtlsControlImpl.generateX509Certificate(DtlsControlImpl.generateCN(), this.keyPair);
        this.certificate = new org.bouncycastle.crypto.tls.Certificate(new Certificate[]{x509Certificate});
        this.localFingerprintHashFunction = DtlsControlImpl.findHashFunction(x509Certificate);
        this.localFingerprint = DtlsControlImpl.computeFingerprint(x509Certificate, this.localFingerprintHashFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(Object user) {
        Set<Object> set = this.users;
        synchronized (set) {
            if (this.users.remove(user) && this.users.isEmpty()) {
                this.doCleanup();
            }
        }
    }

    @Override
    protected DtlsTransformEngine createTransformEngine() {
        DtlsTransformEngine transformEngine = new DtlsTransformEngine(this);
        transformEngine.setConnector(this.connector);
        transformEngine.setSetup(this.setup);
        transformEngine.setRtcpmux(this.rtcpmux);
        return transformEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup() {
        super.cleanup(null);
        this.setConnector(null);
        DtlsControlImpl dtlsControlImpl = this;
        synchronized (dtlsControlImpl) {
            this.disposed = true;
            this.notifyAll();
        }
    }

    org.bouncycastle.crypto.tls.Certificate getCertificate() {
        return this.certificate;
    }

    AsymmetricCipherKeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public String getLocalFingerprint() {
        return this.localFingerprint;
    }

    @Override
    public String getLocalFingerprintHashFunction() {
        return this.localFingerprintHashFunction;
    }

    @Override
    public boolean getSecureCommunicationStatus() {
        return false;
    }

    boolean isSrtpDisabled() {
        return this.disableSRTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUser(Object user) {
        Set<Object> set = this.users;
        synchronized (set) {
            this.users.add(user);
        }
    }

    @Override
    public boolean requiresSecureSignalingTransport() {
        return true;
    }

    @Override
    public void setConnector(AbstractRTPConnector connector) {
        if (this.connector != connector) {
            this.connector = connector;
            DtlsTransformEngine transformEngine = (DtlsTransformEngine)this.transformEngine;
            if (transformEngine != null) {
                transformEngine.setConnector(this.connector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRemoteFingerprints(Map<String, String> remoteFingerprints) {
        if (remoteFingerprints == null) {
            throw new NullPointerException("remoteFingerprints");
        }
        DtlsControlImpl dtlsControlImpl = this;
        synchronized (dtlsControlImpl) {
            this.remoteFingerprints = remoteFingerprints;
            this.notifyAll();
        }
    }

    @Override
    public void setRtcpmux(boolean rtcpmux) {
        if (this.rtcpmux != rtcpmux) {
            this.rtcpmux = rtcpmux;
            DtlsTransformEngine transformEngine = (DtlsTransformEngine)this.transformEngine;
            if (transformEngine != null) {
                transformEngine.setRtcpmux(rtcpmux);
            }
        }
    }

    @Override
    public void setSetup(DtlsControl.Setup setup) {
        if (this.setup != setup) {
            this.setup = setup;
            DtlsTransformEngine transformEngine = (DtlsTransformEngine)this.transformEngine;
            if (transformEngine != null) {
                transformEngine.setSetup(this.setup);
            }
        }
    }

    @Override
    public void start(MediaType mediaType) {
        DtlsTransformEngine transformEngine = (DtlsTransformEngine)this.getTransformEngine();
        if (transformEngine != null) {
            transformEngine.start(mediaType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAndValidateCertificate(Certificate certificate) throws Exception {
        String remoteFingerprint;
        String hashFunction = DtlsControlImpl.findHashFunction(certificate);
        String fingerprint = DtlsControlImpl.computeFingerprint(certificate, hashFunction);
        DtlsControlImpl dtlsControlImpl = this;
        synchronized (dtlsControlImpl) {
            if (this.disposed) {
                throw new IllegalStateException("disposed");
            }
            Map<String, String> remoteFingerprints = this.remoteFingerprints;
            if (remoteFingerprints == null) {
                throw new IOException("No fingerprints declared over the signaling path!");
            }
            remoteFingerprint = remoteFingerprints.get(hashFunction);
        }
        if (remoteFingerprint == null) {
            throw new IOException("No fingerprint declared over the signaling path with hash function: " + hashFunction + "!");
        }
        if (!remoteFingerprint.equals(fingerprint)) {
            throw new IOException("Fingerprint " + remoteFingerprint + " does not match the " + hashFunction + "-hashed certificate " + fingerprint + "!");
        }
    }

    boolean verifyAndValidateCertificate(org.bouncycastle.crypto.tls.Certificate certificate) throws Exception {
        boolean b = false;
        try {
            Certificate[] certificateList = certificate.getCertificateList();
            if (certificateList.length == 0) {
                throw new IllegalArgumentException("certificate.certificateList");
            }
            for (Certificate x509Certificate : certificateList) {
                this.verifyAndValidateCertificate(x509Certificate);
            }
            b = true;
        }
        catch (Exception e) {
            String message = "Failed to verify and/or validate a certificate offered over the media path against fingerprints declared over the signaling path!";
            String throwableMessage = e.getMessage();
            if (VERIFY_AND_VALIDATE_CERTIFICATE) {
                if (throwableMessage == null || throwableMessage.length() == 0) {
                    logger.error(message, e);
                } else {
                    logger.error(message + " " + throwableMessage);
                }
                throw e;
            }
            if (throwableMessage == null || throwableMessage.length() == 0) {
                logger.warn(message, e);
            }
            logger.warn(message + " " + throwableMessage);
        }
        return b;
    }

    static {
        VERIFY_AND_VALIDATE_CERTIFICATE_PNAME = DtlsControlImpl.class.getName() + ".verifyAndValidateCertificate";
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean verifyAndValidateCertificate = true;
        if (cfg == null) {
            String s = System.getProperty(VERIFY_AND_VALIDATE_CERTIFICATE_PNAME);
            if (s != null) {
                verifyAndValidateCertificate = Boolean.parseBoolean(s);
            }
        } else {
            verifyAndValidateCertificate = cfg.getBoolean(VERIFY_AND_VALIDATE_CERTIFICATE_PNAME, verifyAndValidateCertificate);
        }
        VERIFY_AND_VALIDATE_CERTIFICATE = verifyAndValidateCertificate;
    }
}

